/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.parser.query;

import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ExpressionParser;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.query.Expand;
import de.fraunhofer.iosb.ilt.frostserver.query.Metadata;
import de.fraunhofer.iosb.ilt.frostserver.query.OrderBy;
import de.fraunhofer.iosb.ilt.frostserver.query.PropertyPlaceholder;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.query.QueryDefaults;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.DynamicContext;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.Expression;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.Node;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.ParseException;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.QParser;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.Token;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.nodes.P_ExpandItem;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.nodes.P_Option;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.nodes.P_OrderBy;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.nodes.P_PlainPath;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.nodes.P_Ref;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.nodes.Start;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.nodes.T_ARRAYINDEX;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.nodes.T_BOOL;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.nodes.T_CHARSEQ_FORMAT;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.nodes.T_CHARSEQ_METADATA;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.nodes.T_DISTINCT;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.nodes.T_LONG;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.nodes.T_O_COUNT;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.nodes.T_O_DESC;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.nodes.T_O_EXPAND;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.nodes.T_O_FILTER;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.nodes.T_O_FORMAT;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.nodes.T_O_METADATA;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.nodes.T_O_ORDERBY;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.nodes.T_O_SELECT;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.nodes.T_O_SKIP;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.nodes.T_O_SKIPFILTER;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.nodes.T_O_TOP;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.nodes.T_PATH_SEPARATOR;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.nodes.T_STRING;
import de.fraunhofer.iosb.ilt.frostserver.util.user.PrincipalExtended;
import java.nio.charset.Charset;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryParser
extends Node.Visitor {
    private static final String VISIT_CALLED_WITHOUT_PARAMETER = "Visit called without parameter.";
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryParser.class);
    private final QueryDefaults queryDefaults;
    private final ModelRegistry modelRegistry;
    private final ResourcePath path;
    private final PrincipalExtended user;
    private final DynamicContext context;
    private ExpressionParser expressionParser;
    private Query currentQuery;
    private P_Option currentOption;

    public QueryParser(QueryDefaults queryDefaults, ModelRegistry modelRegistry, ResourcePath path, PrincipalExtended user, DynamicContext context) {
        this.queryDefaults = queryDefaults;
        this.modelRegistry = modelRegistry;
        this.path = path;
        this.user = user;
        this.context = context;
    }

    private Query handle(Start node) {
        Query query = new Query(this.modelRegistry, this.queryDefaults, this.path, this.user);
        for (P_Ref p_Ref : node.childrenOfType(P_Ref.class)) {
            this.handle(p_Ref, query);
        }
        for (P_Option p_Option : node.childrenOfType(P_Option.class)) {
            this.handle(p_Option, query);
        }
        return query;
    }

    private void handle(P_Ref ref, Query query) {
        List<T_STRING> children = ref.childrenOfType(T_STRING.class);
        if (children.size() != 1) {
            throw new IllegalArgumentException("$id must be followed by a string");
        }
        query.setId(children.get(0).getImage());
    }

    private void handle(P_Option option, Query query) {
        Query lastQuery = this.currentQuery;
        P_Option lastOption = this.currentOption;
        Node type = option.getFirstChild();
        this.currentQuery = query;
        this.currentOption = option;
        this.visit(type);
        this.currentQuery = lastQuery;
        this.currentOption = lastOption;
    }

    public void visit(T_O_COUNT node) {
        List<T_BOOL> values;
        if (node == null) {
            LOGGER.warn(VISIT_CALLED_WITHOUT_PARAMETER);
        }
        if ((values = this.currentOption.childrenOfType(T_BOOL.class)).isEmpty()) {
            return;
        }
        this.currentQuery.setCount(Boolean.parseBoolean(values.get(0).getImage()));
    }

    public void visit(T_O_SKIP node) {
        List<T_LONG> values;
        if (node == null) {
            LOGGER.warn(VISIT_CALLED_WITHOUT_PARAMETER);
        }
        if ((values = this.currentOption.childrenOfType(T_LONG.class)).isEmpty()) {
            return;
        }
        this.currentQuery.setSkip(Integer.parseInt(values.get(0).getImage()));
    }

    public void visit(T_O_TOP node) {
        List<T_LONG> values;
        if (node == null) {
            LOGGER.warn(VISIT_CALLED_WITHOUT_PARAMETER);
        }
        if ((values = this.currentOption.childrenOfType(T_LONG.class)).isEmpty()) {
            return;
        }
        String image = values.get(0).getImage();
        this.currentQuery.setTop(Integer.parseInt(image));
    }

    public void visit(T_O_FORMAT node) {
        List<T_CHARSEQ_FORMAT> values;
        if (node == null) {
            LOGGER.warn(VISIT_CALLED_WITHOUT_PARAMETER);
        }
        if ((values = this.currentOption.childrenOfType(T_CHARSEQ_FORMAT.class)).isEmpty()) {
            return;
        }
        this.currentQuery.setFormat(values.get(0).getImage());
    }

    public void visit(T_O_METADATA node) {
        List<T_CHARSEQ_METADATA> values;
        if (node == null) {
            LOGGER.warn(VISIT_CALLED_WITHOUT_PARAMETER);
        }
        if ((values = this.currentOption.childrenOfType(T_CHARSEQ_METADATA.class)).isEmpty()) {
            return;
        }
        this.currentQuery.setMetadata(Metadata.lookup(values.get(0).getImage()));
    }

    public void visit(T_O_SELECT node) {
        List<P_PlainPath> values;
        if (node == null) {
            LOGGER.warn(VISIT_CALLED_WITHOUT_PARAMETER);
        }
        if (this.currentOption.getChild(1) instanceof T_DISTINCT) {
            this.currentQuery.setSelectDistinct(true);
        }
        if ((values = this.currentOption.childrenOfType(P_PlainPath.class)).isEmpty()) {
            return;
        }
        for (P_PlainPath pp : values) {
            PropertyPlaceholder property = this.handle(pp);
            this.currentQuery.addSelect(property);
        }
    }

    public PropertyPlaceholder handle(P_PlainPath pp) {
        List<Token> children = pp.childrenOfType(Token.class);
        PropertyPlaceholder property = new PropertyPlaceholder(children.get(0).toString());
        for (int i = 1; i < children.size(); ++i) {
            Token child = children.get(i);
            if (child instanceof T_PATH_SEPARATOR) continue;
            String img = child.toString();
            if (child instanceof T_ARRAYINDEX) {
                property.addToSubPath(img.substring(1, img.length() - 1));
                continue;
            }
            property.addToSubPath(img);
        }
        return property;
    }

    public void visit(T_O_ORDERBY node) {
        List<P_OrderBy> values;
        if (node == null) {
            LOGGER.warn(VISIT_CALLED_WITHOUT_PARAMETER);
        }
        if ((values = this.currentOption.childrenOfType(P_OrderBy.class)).isEmpty()) {
            return;
        }
        for (P_OrderBy orderby : values) {
            this.handle(orderby);
        }
    }

    public void handle(P_OrderBy node) {
        OrderBy.OrderType dir = OrderBy.OrderType.ASCENDING;
        if (node.getChildCount() == 2 && node.getChild(1) instanceof T_O_DESC) {
            dir = OrderBy.OrderType.DESCENDING;
        }
        Expression expression = this.getExpressionParser().parseExpression(node.getChild(0));
        this.currentQuery.addOrderBy(new OrderBy(expression, dir));
    }

    public void visit(T_O_FILTER node) {
        if (node == null) {
            LOGGER.warn(VISIT_CALLED_WITHOUT_PARAMETER);
        }
        this.currentQuery.setFilter(this.getExpressionParser().parseExpression(this.currentOption.getChild(1)));
    }

    public void visit(T_O_SKIPFILTER node) {
        if (node == null) {
            LOGGER.warn(VISIT_CALLED_WITHOUT_PARAMETER);
        }
        this.currentQuery.setSkipFilter(this.getExpressionParser().parseExpression(this.currentOption.getChild(1)));
    }

    public void visit(T_O_EXPAND node) {
        List<P_ExpandItem> values;
        if (node == null) {
            LOGGER.warn(VISIT_CALLED_WITHOUT_PARAMETER);
        }
        if ((values = this.currentOption.childrenOfType(P_ExpandItem.class)).isEmpty()) {
            return;
        }
        for (P_ExpandItem expand : values) {
            this.handle(expand);
        }
    }

    public void handle(P_ExpandItem expandItem) {
        Expand expand = new Expand(this.modelRegistry);
        List<P_PlainPath> paths = expandItem.childrenOfType(P_PlainPath.class);
        if (paths.isEmpty()) {
            return;
        }
        PropertyPlaceholder property = this.handle(paths.get(0));
        expand.addToRawPath(property.getName());
        for (String item : property.getSubPath()) {
            expand.addToRawPath(item);
        }
        List<P_Option> subOptions = expandItem.childrenOfType(P_Option.class);
        if (!subOptions.isEmpty()) {
            Query subQuery = new Query(this.modelRegistry, this.queryDefaults, this.path, this.user);
            for (P_Option subOption : subOptions) {
                this.handle(subOption, subQuery);
            }
            expand.setSubQuery(subQuery);
        }
        this.currentQuery.addExpand(expand);
    }

    private ExpressionParser getExpressionParser() {
        if (this.expressionParser == null) {
            this.expressionParser = new ExpressionParser(this, this.user.isAdmin(), this.context);
        }
        return this.expressionParser;
    }

    public static Query parseQuery(String query, QueryDefaults queryDefaults, ModelRegistry modelRegistry, ResourcePath path) {
        return QueryParser.parseQuery(query, StringHelper.UTF8, queryDefaults, modelRegistry, path, PrincipalExtended.ANONYMOUS_PRINCIPAL, new DynamicContext());
    }

    public static Query parseQuery(String query, QueryDefaults queryDefaults, ModelRegistry modelRegistry, ResourcePath path, PrincipalExtended user) {
        return QueryParser.parseQuery(query, StringHelper.UTF8, queryDefaults, modelRegistry, path, user, new DynamicContext());
    }

    public static Query parseQuery(String query, QueryDefaults queryDefaults, ModelRegistry modelRegistry, ResourcePath path, PrincipalExtended user, DynamicContext context) {
        return QueryParser.parseQuery(query, StringHelper.UTF8, queryDefaults, modelRegistry, path, user, context);
    }

    public static Query parseQuery(String query, Charset encoding, QueryDefaults queryDefaults, ModelRegistry modelRegistry, ResourcePath path) {
        return QueryParser.parseQuery(query, encoding, queryDefaults, modelRegistry, path, PrincipalExtended.ANONYMOUS_PRINCIPAL, new DynamicContext());
    }

    public static Query parseQuery(String query, Charset encoding, QueryDefaults queryDefaults, ModelRegistry modelRegistry, ResourcePath path, PrincipalExtended user, DynamicContext context) {
        if (query == null || query.isEmpty()) {
            return new Query(modelRegistry, queryDefaults, path, user);
        }
        LOGGER.debug("Parsing: {}", (Object)query);
        QParser t2 = new QParser(query);
        try {
            Start start = t2.Start();
            QueryParser v = new QueryParser(queryDefaults, modelRegistry, path, user, context);
            return v.handle(start);
        }
        catch (ParseException | IllegalArgumentException ex) {
            LOGGER.error("Exception parsing: {}", (Object)StringHelper.cleanForLogging(query));
            throw new IllegalArgumentException("Query is not valid: " + ex.getMessage(), ex);
        }
    }
}

