/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.parser.path;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.QueryParser;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElement;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementArrayIndex;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementCustomProperty;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntity;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementProperty;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.query.QueryDefaults;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.Node;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.PParser;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.ParseException;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.Token;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.P_EntityId;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.T_ARRAYINDEX;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.T_LONG;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.T_NAME;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.T_REF;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.T_STR_LIT;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.T_VALUE;
import de.fraunhofer.iosb.ilt.frostserver.util.user.PrincipalExtended;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathParser
extends Node.Visitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathParser.class);
    private final ModelRegistry modelRegistry;
    private final ResourcePath resourcePath;
    private final boolean adminUser;
    private boolean foundFirstId;

    public PathParser(ModelRegistry modelRegistry, ResourcePath resourcePath, boolean adminUser) {
        this.modelRegistry = modelRegistry;
        this.resourcePath = resourcePath;
        this.adminUser = adminUser;
    }

    private void addAsEntity(EntityType type, String id) {
        PathElementEntity epa = new PathElementEntity(type, this.resourcePath.getLastElement());
        if (id != null) {
            epa.setPkValues(type.parsePrimaryKey(id));
            this.resourcePath.setIdentifiedElement(epa);
        }
        this.resourcePath.addPathElement(epa, true, false);
    }

    private void addAsEntity(NavigationPropertyMain.NavigationPropertyEntity type, String id) {
        PathElementEntity epa = new PathElementEntity(type, this.resourcePath.getLastElement());
        if (id != null) {
            epa.setPkValues(type.getEntityType().parsePrimaryKey(id));
            this.resourcePath.setIdentifiedElement(epa);
        }
        this.resourcePath.addPathElement(epa, true, false);
    }

    private void addAsEntitySet(EntityType type) {
        if (this.resourcePath.getLastElement() != null) {
            throw new IllegalArgumentException("Adding a set by type should only happen on an empty path. Add a set by NavigationProperty instead." + this.resourcePath);
        }
        PathElementEntitySet espa = new PathElementEntitySet(type);
        this.resourcePath.addPathElement(espa, true, false);
    }

    private void addAsEntitySet(NavigationPropertyMain type) {
        if (type instanceof NavigationPropertyMain.NavigationPropertyEntitySet) {
            NavigationPropertyMain.NavigationPropertyEntitySet npEntitySet = (NavigationPropertyMain.NavigationPropertyEntitySet)type;
            PathElement lastElement = this.resourcePath.getLastElement();
            if (lastElement instanceof PathElementEntity) {
                PathElementEntity peEntity = (PathElementEntity)lastElement;
                PathElementEntitySet espa = new PathElementEntitySet(npEntitySet, peEntity);
                this.resourcePath.addPathElement(espa, true, false);
            }
        } else {
            throw new IllegalArgumentException("NavigationProperty should be of type NavigationPropertyEntitySet, got: " + StringHelper.cleanForLogging(type));
        }
    }

    private void addAsEntityProperty(EntityPropertyMain type) {
        PathElementProperty ppe = new PathElementProperty();
        ppe.setProperty(type);
        ppe.setParent(this.resourcePath.getLastElement());
        this.resourcePath.addPathElement(ppe);
    }

    private void addAsCustomProperty(String name) {
        PathElementCustomProperty cppa = new PathElementCustomProperty();
        cppa.setName(name);
        cppa.setParent(this.resourcePath.getLastElement());
        this.resourcePath.addPathElement(cppa);
    }

    private void addAsArrayIndex(Token node) {
        String image = node.getImage();
        PathElement parent = this.resourcePath.getLastElement();
        if (!(parent instanceof PathElementProperty || parent instanceof PathElementCustomProperty || parent instanceof PathElementArrayIndex)) {
            throw new IllegalArgumentException("Array indices must follow a property or array index: " + StringHelper.cleanForLogging(image));
        }
        if (!image.startsWith("[") && image.endsWith("]")) {
            throw new IllegalArgumentException("Received node is not an array index: " + StringHelper.cleanForLogging(image));
        }
        String numberString = image.substring(1, image.length() - 1);
        try {
            int index = Integer.parseInt(numberString);
            PathElementArrayIndex cpai = new PathElementArrayIndex();
            cpai.setIndex(index);
            cpai.setParent(parent);
            this.resourcePath.addPathElement(cpai);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Array indices must be integer values. Failed to parse: " + StringHelper.cleanForLogging(image));
        }
    }

    public void visit(T_REF node) {
        this.resourcePath.setRef(true);
        this.recurse(node);
    }

    public void visit(T_VALUE node) {
        this.resourcePath.setValue(true);
        this.recurse(node);
    }

    public void visit(T_NAME node) {
        String name = node.getImage();
        PathElement parent = this.resourcePath.getLastElement();
        if (parent == null) {
            EntityType entityType = this.modelRegistry.getEntityTypeForName(name, this.adminUser);
            if (entityType == null) {
                throw new IllegalArgumentException("Unknown EntityType: '" + StringHelper.cleanForLogging(name) + "'");
            }
            if (!entityType.plural.equals(name)) {
                throw new IllegalArgumentException("Path must start with an EntitySet.");
            }
            this.addAsEntitySet(entityType);
            return;
        }
        if (!this.foundFirstId) {
            throw new IllegalArgumentException("Second element should be an ID or $ref, not " + StringHelper.cleanForLogging(node.toString()));
        }
        if (parent instanceof PathElementEntitySet) {
            throw new IllegalArgumentException("A property name can not follow a set: " + StringHelper.cleanForLogging(node.toString()));
        }
        if (parent instanceof PathElementEntity) {
            PathElementEntity parentEntity = (PathElementEntity)parent;
            this.parentIsEntity(name, parentEntity);
            return;
        }
        if (parent instanceof PathElementProperty) {
            this.addAsCustomProperty(name);
            return;
        }
        if (parent instanceof PathElementCustomProperty) {
            this.addAsCustomProperty(name);
            return;
        }
        if (parent instanceof PathElementArrayIndex) {
            this.addAsCustomProperty(name);
            return;
        }
        throw new IllegalArgumentException("Do not know what to do with: " + StringHelper.cleanForLogging(node.toString()));
    }

    public void parentIsEntity(String name, PathElementEntity parentEntity) throws IllegalArgumentException {
        EntityType parentType = parentEntity.getEntityType();
        Property property = parentType.getProperty(name);
        if (property instanceof EntityPropertyMain) {
            EntityPropertyMain epMain = (EntityPropertyMain)property;
            this.addAsEntityProperty(epMain);
            return;
        }
        if (property instanceof NavigationProperty) {
            NavigationProperty np = (NavigationProperty)property;
            if (np.isAdminOnly() && !this.adminUser) {
                throw new IllegalArgumentException("EntityType " + parentType + " does not have a property: " + StringHelper.cleanForLogging(name));
            }
            if (np instanceof NavigationPropertyMain.NavigationPropertyEntity) {
                NavigationPropertyMain.NavigationPropertyEntity npEntity = (NavigationPropertyMain.NavigationPropertyEntity)np;
                this.addAsEntity(npEntity, null);
                return;
            }
            if (np instanceof NavigationPropertyMain.NavigationPropertyEntitySet) {
                NavigationPropertyMain.NavigationPropertyEntitySet npEntitySet = (NavigationPropertyMain.NavigationPropertyEntitySet)np;
                this.addAsEntitySet(npEntitySet);
                return;
            }
        }
        throw new IllegalArgumentException("EntityType " + parentType + " does not have a property: " + StringHelper.cleanForLogging(name));
    }

    public void visit(T_ARRAYINDEX node) {
        this.addAsArrayIndex(node);
        this.recurse(node);
    }

    public void visit(P_EntityId node) {
        this.foundFirstId = true;
        this.recurse(node);
    }

    public void visit(T_LONG node) {
        this.handleIdentifierToken(node);
    }

    public void visit(T_STR_LIT node) {
        this.handleIdentifierToken(node);
    }

    void handleIdentifierToken(Token node) throws IllegalArgumentException {
        PathElementEntitySet peEntitySet;
        PathElement parent = this.resourcePath.getLastElement();
        if (!(parent instanceof PathElementEntitySet)) {
            throw new IllegalArgumentException("An ID must follow a set: " + StringHelper.cleanForLogging(node.getImage()));
        }
        PathElementEntitySet parentSet = peEntitySet = (PathElementEntitySet)parent;
        this.addAsEntity(parentSet.getEntityType(), node.getImage());
    }

    public static ResourcePath parsePath(ModelRegistry modelRegistry, String serviceRootUrl, Version version, String path) {
        return PathParser.parsePath(modelRegistry, serviceRootUrl, version, path, PrincipalExtended.ANONYMOUS_PRINCIPAL);
    }

    public static ResourcePath parsePath(ModelRegistry modelRegistry, String serviceRootUrl, Version version, String path, PrincipalExtended user) {
        ResourcePath resourcePath = new ResourcePath();
        resourcePath.setServiceRootUrl(serviceRootUrl);
        resourcePath.setVersion(version);
        if (path == null) {
            resourcePath.setPath("");
            return resourcePath;
        }
        resourcePath.setPath(path);
        LOGGER.debug("Parsing: {}", (Object)path);
        PParser parser = new PParser(path);
        try {
            parser.Start();
            PathParser pp = new PathParser(modelRegistry, resourcePath, user.isAdmin());
            pp.visit(parser.rootNode());
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Path is not valid: " + ex.getMessage());
        }
        return resourcePath;
    }

    public static Query parsePathAndQuery(Version version, String pathAndQuery, CoreSettings settings, QueryDefaults queryDefaults) {
        int index = pathAndQuery.indexOf(63);
        String pathString = pathAndQuery.substring(0, index);
        String queryString = pathAndQuery.substring(index + 1);
        ResourcePath path = PathParser.parsePath(settings.getModelRegistry(), queryDefaults.getServiceRootUrl(), version, pathString);
        return QueryParser.parseQuery(queryString, queryDefaults, settings.getModelRegistry(), path).validate(null, path.getMainElementType());
    }
}

