/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription;

import de.fraunhofer.iosb.ilt.frostserver.json.serialize.JsonWriter;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.PkValue;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription.AbstractSubscription;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription.SubscriptionFactory;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntity;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementProperty;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.persistence.PersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.user.PrincipalExtended;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class PropertySubscription
extends AbstractSubscription {
    private Property property;
    private Predicate<? super Entity> matcher;
    private Query query;

    public PropertySubscription(String topic, ResourcePath path, CoreSettings settings) {
        super(topic, path, settings);
        this.init();
    }

    private void init() {
        if (!SubscriptionFactory.getQueryFromTopic(this.topic).isEmpty()) {
            throw new IllegalArgumentException("Invalid subscription to: '" + this.topic + "': query options not allowed for subscription on a property.");
        }
        int size = this.path.size();
        this.entityType = ((PathElementEntity)this.path.get(size - 2)).getEntityType();
        this.property = ((PathElementProperty)this.path.get(size - 1)).getProperty();
        if (this.path.getIdentifiedElement() != null) {
            PkValue id = this.path.getIdentifiedElement().getPkValues();
            this.matcher = x -> x.getPrimaryKeyValues().equals(id);
        }
        this.query = new Query(this.modelRegistry, this.queryDefaults, this.path, PrincipalExtended.ANONYMOUS_PRINCIPAL);
        this.query.addSelect(this.property);
        this.generateFilter(2, null);
    }

    @Override
    public boolean matches(PersistenceManager persistenceManager, Entity newEntity, Set<Property> fields2) {
        if (this.matcher != null && !this.matcher.test(newEntity)) {
            return false;
        }
        if (fields2 == null || !fields2.contains(this.property)) {
            return false;
        }
        return super.matches(persistenceManager, newEntity, fields2);
    }

    @Override
    public String doFormatMessage(Entity entity) throws IOException {
        entity.setQuery(this.query);
        return JsonWriter.writeEntity(entity);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.property);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertySubscription other = (PropertySubscription)obj;
        return super.equals(obj) && Objects.equals(this.property, other.property);
    }
}

