/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription;

import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.PkValue;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription.AbstractSubscription;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription.SubscriptionFactory;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntity;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.persistence.PersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncorrectRequestException;
import de.fraunhofer.iosb.ilt.frostserver.util.user.PrincipalExtended;
import java.io.IOException;
import java.util.Set;
import java.util.function.Predicate;

public class EntitySubscription
extends AbstractSubscription {
    private Query emptyQuery;
    private Predicate<? super Entity> matcher;

    public EntitySubscription(CoreSettings settings, String topic, ResourcePath path) {
        super(topic, path, settings);
        this.init();
    }

    private void init() {
        this.emptyQuery = new Query(this.modelRegistry, this.queryDefaults, this.path, PrincipalExtended.ANONYMOUS_PRINCIPAL).validate();
        if (!SubscriptionFactory.getQueryFromTopic(this.topic).isEmpty()) {
            throw new IllegalArgumentException("Invalid subscription to: '" + this.topic + "': query options not allowed for subscription on an entity.");
        }
        this.entityType = ((PathElementEntity)this.path.getLastElement()).getEntityType();
        int size = this.path.size();
        if (size == 2 && this.path.get(0) instanceof PathElementEntitySet) {
            PkValue id = ((PathElementEntity)this.path.getLastElement()).getPkValues();
            this.matcher = x -> x.getPrimaryKeyValues().equals(id);
        }
        this.generateFilter(1, null);
    }

    @Override
    public boolean matches(PersistenceManager persistenceManager, Entity newEntity, Set<Property> fields2) {
        if (this.matcher != null && !this.matcher.test(newEntity)) {
            return false;
        }
        return super.matches(persistenceManager, newEntity, fields2);
    }

    @Override
    public String doFormatMessage(Entity entity) throws IOException {
        try {
            entity.setQuery(this.emptyQuery);
            return this.settings.getFormatter(this.emptyQuery.getVersion(), "default").format(this.path, this.emptyQuery, entity, true).getFormatted();
        }
        catch (IncorrectRequestException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

