/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription;

import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription.AbstractSubscription;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription.SubscriptionFactory;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.QueryParser;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.persistence.PersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.query.Expand;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.Expression;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncorrectRequestException;
import de.fraunhofer.iosb.ilt.frostserver.util.user.PrincipalExtended;
import java.net.URLDecoder;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitySetSubscription
extends AbstractSubscription {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntitySetSubscription.class);
    private Query query;
    private Query expandQuery;

    public EntitySetSubscription(CoreSettings settings, String topic, ResourcePath path) {
        super(topic, path, settings);
        this.init();
    }

    private void init() {
        this.entityType = ((PathElementEntitySet)this.path.getLastElement()).getEntityType();
        String queryString = SubscriptionFactory.getQueryFromTopic(this.topic);
        this.query = this.parseQuery(queryString);
        Expression filter = null;
        if (this.query != null) {
            Query queryCopy;
            if (this.query.getCount().isPresent() || !this.query.getOrderBy().isEmpty() || this.query.getSkip().isPresent() || this.query.getTop().isPresent()) {
                throw new IllegalArgumentException("Invalid subscription to: '" + this.topic + "': $count, $skip, $top and $orderby are not allowed in query options.");
            }
            if (!this.query.getExpand().isEmpty() && !this.settings.getMqttSettings().isAllowMqttExpand()) {
                throw new IllegalArgumentException("Invalid subscription to: '" + this.topic + "': $expand is not allowed in query options.");
            }
            if (this.query.getFilter() != null && !this.settings.getMqttSettings().isAllowMqttFilter()) {
                throw new IllegalArgumentException("Invalid subscription to: '" + this.topic + "': $filter is not allowed in query options.");
            }
            filter = this.query.getFilter();
            if (!this.query.getExpand().isEmpty() && (queryCopy = this.parseQuery(queryString)) != null) {
                List<Expand> expandList = queryCopy.getExpand();
                this.expandQuery = new Query(this.modelRegistry, this.queryDefaults, queryCopy.getPath()).setExpand(expandList).addSelect(this.entityType.getPrimaryKey().getKeyProperties());
            }
        }
        this.generateFilter(1, filter);
    }

    private Query parseQuery(String topic) {
        String queryString = URLDecoder.decode(topic, StringHelper.UTF8);
        try {
            return QueryParser.parseQuery(queryString, this.queryDefaults, this.modelRegistry, this.path).validate();
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Invalid query: {} ERROR: {}", (Object)queryString, (Object)e.getMessage());
            return new Query(this.modelRegistry, this.queryDefaults, this.path, PrincipalExtended.ANONYMOUS_PRINCIPAL).validate();
        }
    }

    @Override
    public String doFormatMessage(Entity entity) {
        try {
            entity.setQuery(this.query);
            return this.settings.getFormatter(this.query.getVersion(), "default").format(this.path, this.query, entity, true).getFormatted();
        }
        catch (IncorrectRequestException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public Entity fetchExpand(PersistenceManager persistenceManager, Entity newEntity) {
        ResourcePath resourcePath;
        Object expandEntity;
        if (this.expandQuery != null && (expandEntity = persistenceManager.get(resourcePath = newEntity.getPath().setVersion(this.expandQuery.getVersion()).setServiceRootUrl(this.expandQuery.getServiceRootUrl()), this.expandQuery)) instanceof Entity) {
            Entity entity = (Entity)expandEntity;
            Set<EntityPropertyMain> fields2 = entity.getEntityType().getEntityProperties();
            fields2.forEach(field -> entity.setProperty(field, newEntity.getProperty(field)));
            entity.setQuery(this.query);
            return entity;
        }
        return super.fetchExpand(persistenceManager, newEntity);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.query);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        EntitySetSubscription other = (EntitySetSubscription)obj;
        return Objects.equals(this.query, other.query);
    }
}

