/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.PkValue;
import de.fraunhofer.iosb.ilt.frostserver.model.core.PrimaryKey;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription.Subscription;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElement;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntity;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntityType;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.path.UrlHelper;
import de.fraunhofer.iosb.ilt.frostserver.persistence.PersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.query.QueryDefaults;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.Expression;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.Path;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.IntegerConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.StringConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.comparison.Equal;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.logical.And;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.user.PrincipalExtended;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public abstract class AbstractSubscription
implements Subscription {
    protected final String topic;
    protected EntityType entityType;
    private Expression matchExpression = null;
    private Query query;
    private Predicate<? super Entity> matcher;
    private NavigationPropertyMain parentRelation;
    private PkValue parentId;
    protected ResourcePath path;
    protected CoreSettings settings;
    protected QueryDefaults queryDefaults;
    protected ModelRegistry modelRegistry;

    protected AbstractSubscription(String topic, ResourcePath path, CoreSettings settings) {
        this.topic = topic;
        this.path = path;
        this.settings = settings;
        this.queryDefaults = settings.getQueryDefaults().setAlwaysOrder(false);
        this.modelRegistry = settings.getModelRegistry();
    }

    @Override
    public boolean matches(PersistenceManager persistenceManager, Entity newEntity, Set<Property> fields2) {
        if (!newEntity.getEntityType().equals(this.entityType)) {
            return false;
        }
        if (this.matcher != null && !this.matcher.test(newEntity)) {
            return false;
        }
        if (this.matchExpression != null) {
            Object result = persistenceManager.get(newEntity.getPath(), this.query);
            return result != null;
        }
        return true;
    }

    protected void generateFilter(int pathElementOffset, Expression extraFilter) {
        ArrayList<Property> properties = new ArrayList<Property>();
        boolean direct = extraFilter == null;
        int size = this.path.size();
        int startIdx = size - 1 - pathElementOffset;
        if (startIdx < 0) {
            this.createMatchExpression(extraFilter);
            return;
        }
        PathElement nextPathElement = startIdx < size ? this.path.get(startIdx + 1) : null;
        for (int i = startIdx; i >= 0; --i) {
            PathElement element = this.path.get(i);
            if (element instanceof PathElementEntitySet) {
                NavigationPropertyMain navProp;
                NavigationPropertyMain navPropInverse = null;
                if (nextPathElement instanceof PathElementEntityType && (navProp = (peet = (PathElementEntityType)nextPathElement).getNavigationProperty()) != null) {
                    navPropInverse = navProp.getInverse();
                }
                properties.add(navPropInverse);
                direct = false;
            } else if (element instanceof PathElementEntity) {
                PathElementEntity epe = (PathElementEntity)element;
                NavigationPropertyMain navProp = null;
                if (nextPathElement instanceof PathElementEntityType) {
                    peet = (PathElementEntityType)nextPathElement;
                    navProp = peet.getNavigationProperty().getInverse();
                }
                PkValue id = epe.getPkValues();
                if (direct && navProp != null && !navProp.isEntitySet() && id != null) {
                    this.createMatcher(navProp, id);
                    assert (i <= 1);
                    return;
                }
                properties.add(navProp);
                if (id != null) {
                    this.createMatchExpression(properties, epe, extraFilter);
                    assert (i <= 1);
                    return;
                }
            }
            nextPathElement = element;
        }
    }

    private void createMatcher(NavigationPropertyMain navProp, PkValue pkValue) {
        this.parentRelation = navProp;
        this.parentId = pkValue;
        this.matcher = t2 -> {
            Entity parent = (Entity)t2.getProperty(navProp);
            if (parent == null) {
                return false;
            }
            return pkValue.equals(parent.getPrimaryKeyValues());
        };
    }

    private void createMatchExpression(Expression extraFilter) {
        if (extraFilter == null) {
            return;
        }
        this.matchExpression = extraFilter;
        this.query = new Query(this.modelRegistry, this.queryDefaults, this.path, PrincipalExtended.ANONYMOUS_PRINCIPAL);
        this.query.setFilter(extraFilter);
    }

    private void createMatchExpression(List<Property> properties, PathElementEntity epe, Expression extraFilter) {
        PrimaryKey primaryKey = this.entityType.getPrimaryKey();
        properties.addAll(primaryKey.getKeyProperties());
        String epeId = UrlHelper.quoteForUrl(primaryKey, epe.getPkValues());
        this.matchExpression = epeId.startsWith("'") ? new Equal(new Path(properties), new StringConstant(epeId.substring(1, epeId.length() - 1))) : new Equal(new Path(properties), new IntegerConstant(epeId));
        if (extraFilter != null) {
            this.matchExpression = new And(this.matchExpression, extraFilter);
        }
        this.query = new Query(this.modelRegistry, this.queryDefaults, this.path, PrincipalExtended.ANONYMOUS_PRINCIPAL);
        this.query.setFilter(this.matchExpression);
    }

    @Override
    public EntityType getEntityType() {
        return this.entityType;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public String formatMessage(Entity entity) throws IOException {
        return this.doFormatMessage(entity);
    }

    @Override
    public NavigationPropertyMain getParentRelation() {
        return this.parentRelation;
    }

    @Override
    public PkValue getParentId() {
        return this.parentId;
    }

    public abstract String doFormatMessage(Entity var1) throws IOException;

    public int hashCode() {
        return Objects.hash(this.topic, this.entityType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSubscription other = (AbstractSubscription)obj;
        if (!Objects.equals(this.topic, other.topic)) {
            return false;
        }
        return this.entityType == other.entityType;
    }
}

