/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.mqtt;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.MqttManager;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.SubscriptionSet;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.SubscriptionSetDirectParent;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription.Subscription;
import de.fraunhofer.iosb.ilt.frostserver.persistence.PersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

class SubscriptionManager {
    private final EntityType entityType;
    private final Map<NavigationPropertyMain, SubscriptionSetDirectParent> parentedSubscriptions = new HashMap<NavigationPropertyMain, SubscriptionSetDirectParent>();
    private final SubscriptionSet complexSubscriptions;
    private final MqttManager mqttManager;
    private final AtomicInteger topicCount;

    public SubscriptionManager(EntityType entityType, MqttManager mqttManager, AtomicInteger topicCount) {
        this.entityType = entityType;
        this.mqttManager = mqttManager;
        this.topicCount = topicCount;
        this.complexSubscriptions = new SubscriptionSet(topicCount);
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public void handleEntityChanged(PersistenceManager persistenceManager, Entity entity, Set<Property> fields2) {
        for (SubscriptionSetDirectParent subSet : this.parentedSubscriptions.values()) {
            subSet.handleEntityChanged(persistenceManager, entity, fields2);
        }
        for (Subscription subscription : this.complexSubscriptions.getSubscriptions().keySet()) {
            if (!subscription.matches(persistenceManager, entity, fields2)) continue;
            Entity newEntity = subscription.fetchExpand(persistenceManager, entity);
            this.mqttManager.notifySubscription(subscription, newEntity);
        }
    }

    public synchronized void addSubscription(Subscription subscription) {
        SubscriptionSetDirectParent parentSet;
        NavigationPropertyMain parentRelation = subscription.getParentRelation();
        if (parentRelation != null && (parentSet = this.parentedSubscriptions.computeIfAbsent(parentRelation, t2 -> new SubscriptionSetDirectParent(this.mqttManager, parentRelation, this.topicCount))).addSubscription(subscription)) {
            return;
        }
        this.complexSubscriptions.addSubscription(subscription);
    }

    public synchronized void removeSubscription(Subscription subscription) {
        NavigationPropertyMain parentRelation = subscription.getParentRelation();
        if (parentRelation != null) {
            SubscriptionSetDirectParent parentSet = this.parentedSubscriptions.get(parentRelation);
            parentSet.removeSubscription(subscription);
        }
        this.complexSubscriptions.removeSubscription(subscription);
    }
}

