/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.modelextractor;

import de.fraunhofer.iosb.ilt.frostserver.modelextractor.FXMLController;
import de.fraunhofer.iosb.ilt.frostserver.modelextractor.FieldData;
import de.fraunhofer.iosb.ilt.frostserver.modelextractor.ForeignKeyData;
import de.fraunhofer.iosb.ilt.frostserver.modelextractor.TableDataController;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import org.apache.commons.text.CaseUtils;
import org.jooq.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableData {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableData.class.getName());
    final String tableName;
    final Map<String, List<ForeignKeyData>> refsToOther = new TreeMap<String, List<ForeignKeyData>>();
    final Map<String, List<ForeignKeyData>> refsFromOther = new TreeMap<String, List<ForeignKeyData>>();
    private final Map<String, FieldData> fields = new TreeMap<String, FieldData>();
    private int pkSize;
    private Node node;
    private TableDataController controller;
    private final String setPostFix;

    public TableData(String tableName, String setPostFix) {
        this.tableName = tableName;
        this.setPostFix = setPostFix;
        this.getNode();
    }

    public Node getNode() {
        if (this.node == null) {
            try {
                FXMLLoader loader = new FXMLLoader(TableDataController.class.getResource("/fxml/TableData.fxml"));
                this.node = (Pane)loader.load();
                this.controller = (TableDataController)loader.getController();
                this.controller.setTableName(this.tableName);
                String prettyName = CaseUtils.toCamelCase(this.tableName, true, '_');
                this.controller.setSingular(prettyName);
                this.controller.setPlural(prettyName + this.setPostFix);
            }
            catch (IOException ex) {
                LOGGER.error("Failed to load FXML", ex);
            }
        }
        return this.node;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getEntityName() {
        return this.controller.getSingular();
    }

    public String getEntityPlural() {
        return this.controller.getPlural();
    }

    public FXMLController.TableChoice getTableType() {
        return this.controller.getChoice();
    }

    public boolean isEntityType() {
        return this.controller.getChoice() == FXMLController.TableChoice.ENTITY_TYPE;
    }

    public boolean isLinkTable() {
        return this.controller.getChoice() == FXMLController.TableChoice.LINK_TABLE;
    }

    public boolean isIgnored() {
        return this.controller.getChoice() == FXMLController.TableChoice.IGNORE;
    }

    public void addReferenceToOther(ForeignKeyData fk) {
        this.refsToOther.computeIfAbsent(fk.otherTableName, t2 -> new ArrayList()).add(fk);
    }

    public void addReferenceFromOther(ForeignKeyData fk) {
        this.refsFromOther.computeIfAbsent(fk.myTableName, t2 -> new ArrayList()).add(fk);
    }

    public void setPkSize(int pkSize) {
        this.pkSize = pkSize;
    }

    public void analyse() {
        if ((this.pkSize == 0 || this.pkSize > 1) && this.refsToOther.size() >= 1) {
            this.controller.setChoice(FXMLController.TableChoice.LINK_TABLE);
            return;
        }
        if (this.pkSize == 1 && this.refsFromOther.size() + this.refsToOther.size() > 0) {
            this.controller.setChoice(FXMLController.TableChoice.ENTITY_TYPE);
            return;
        }
        this.controller.setChoice(FXMLController.TableChoice.IGNORE);
    }

    public Map<String, FieldData> getFields() {
        return this.fields;
    }

    public boolean hasField(String fieldName) {
        return this.fields.containsKey(fieldName.toLowerCase());
    }

    public FieldData getField(String fieldName) {
        return this.fields.get(fieldName.toLowerCase());
    }

    public void addFields(List<Field> tableFields, boolean pks) {
        for (Field field : tableFields) {
            String fieldName = field.getName();
            if (this.fields.containsKey(fieldName.toLowerCase())) continue;
            FieldData fieldData = FieldData.from(field, pks);
            this.fields.put(fieldData.name.toLowerCase(), fieldData);
        }
    }

    public String toString() {
        return this.tableName;
    }
}

