/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.model.loader;

import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableClass;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorClass;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorList;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorSubclass;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntityValidator;
import java.util.ArrayList;
import java.util.List;

@ConfigurableClass
public class DefValidator {
    @ConfigurableField(editor=EditorList.class, label="createValidators", description="The validators to apply when creating a new entity of this type.")
    @EditorList.EdOptsList(editor=EditorClass.class)
    @EditorClass.EdOptsClass(clazz=NamedValidator.class)
    private List<NamedValidator> createValidators;
    @ConfigurableField(editor=EditorList.class, label="updateValidators", description="The validators to apply when updating an entity of this type.")
    @EditorList.EdOptsList(editor=EditorClass.class)
    @EditorClass.EdOptsClass(clazz=NamedValidator.class)
    private List<NamedValidator> updateValidators;

    public void createValidators(ModelRegistry modelRegistry, EntityType entityType) {
        for (NamedValidator namedValidator : this.getCreateValidators()) {
            entityType.addCreateValidator(namedValidator.name, namedValidator.validator);
        }
        for (NamedValidator namedValidator : this.getUpdateValidators()) {
            entityType.addUpdateValidator(namedValidator.name, namedValidator.validator);
        }
    }

    public List<NamedValidator> getCreateValidators() {
        if (this.createValidators == null) {
            this.createValidators = new ArrayList<NamedValidator>();
        }
        return this.createValidators;
    }

    public DefValidator setCreateValidators(List<NamedValidator> createValidators) {
        this.createValidators = createValidators;
        return this;
    }

    public List<NamedValidator> getUpdateValidators() {
        if (this.updateValidators == null) {
            this.updateValidators = new ArrayList<NamedValidator>();
        }
        return this.updateValidators;
    }

    public DefValidator setUpdateValidators(List<NamedValidator> updateValidators) {
        this.updateValidators = updateValidators;
        return this;
    }

    @ConfigurableClass
    public static class NamedValidator {
        @ConfigurableField(editor=EditorString.class, label="name", description="The name of the validator. Using an existing name overwrites that validator.")
        @EditorString.EdOptsString
        public String name;
        @ConfigurableField(editor=EditorSubclass.class, label="validator", description="The implementation class of the validator.")
        @EditorSubclass.EdOptsSubclass(iface=EntityValidator.class, merge=true, nameField="@class", shortenClassNames=true)
        public EntityValidator validator;
    }
}

