/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.model.loader;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.fraunhofer.iosb.ilt.configurable.AnnotatedConfigurable;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableClass;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorBoolean;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorClass;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorInt;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorList;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorSubclass;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.annotations.Annotation;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.PropertyPersistenceMapper;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigurableClass
public class DefNavigationProperty
implements AnnotatedConfigurable<Void, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefNavigationProperty.class.getName());
    @ConfigurableField(editor=EditorString.class, label="Name", description="The name of the Entity Type.")
    @EditorString.EdOptsString
    private String name;
    @ConfigurableField(editor=EditorBoolean.class, label="Is A Set", description="Flag indicating the NavigationProperty points to an EntitySet.")
    @EditorBoolean.EdOptsBool
    private boolean entitySet;
    @ConfigurableField(editor=EditorString.class, label="Target Type", description="The entity type of the entity(set) this NavigationProperty points to.")
    @EditorString.EdOptsString
    private String entityType;
    @ConfigurableField(editor=EditorBoolean.class, label="Required", description="Flag indicating the property must be set.")
    @EditorBoolean.EdOptsBool
    private boolean required;
    @ConfigurableField(editor=EditorBoolean.class, label="Symmetrical", description="The relation is its own inverse")
    @EditorBoolean.EdOptsBool
    private boolean symmetrical;
    @ConfigurableField(editor=EditorInt.class, label="Priority", description="The priority for ordering.")
    @EditorInt.EdOptsInt(min=-999, max=999)
    private int priority;
    @ConfigurableField(editor=EditorClass.class, label="Inverse", description="The inverse of this relation.")
    @EditorClass.EdOptsClass(clazz=Inverse.class)
    private Inverse inverse;
    @ConfigurableField(editor=EditorList.class, label="Handlers")
    @EditorList.EdOptsList(editor=EditorSubclass.class)
    @EditorSubclass.EdOptsSubclass(iface=PropertyPersistenceMapper.class, merge=true, nameField="@class", shortenClassNames=true)
    private List<PropertyPersistenceMapper> handlers;
    @ConfigurableField(editor=EditorList.class, label="Annotations", description="The (OData)annotations for this Element.")
    @EditorList.EdOptsList(editor=EditorSubclass.class)
    @EditorSubclass.EdOptsSubclass(iface=Annotation.class, merge=true, nameField="@class", shortenClassNames=true)
    private final List<Annotation> annotations = new ArrayList<Annotation>();
    @JsonIgnore
    private EntityType sourceEntityType;
    @JsonIgnore
    private EntityType targetEntityType;
    @JsonIgnore
    private NavigationPropertyMain navProp;
    @JsonIgnore
    private NavigationPropertyMain navPropInverse;

    public void init() {
        if (!this.symmetrical && this.inverse == null) {
            LOGGER.error("Inverse relation not defined for navLink {} on entityType {}", (Object)this.name, (Object)this.entityType);
        }
        if (this.handlers == null) {
            this.handlers = Collections.emptyList();
        }
        if (this.entityType == null) {
            this.entityType = this.name;
        }
        for (PropertyPersistenceMapper handler : this.handlers) {
            handler.setParent(this);
        }
    }

    public void registerProperties(ModelRegistry modelRegistry) {
        if (this.navProp != null) {
            return;
        }
        this.navProp = this.entitySet ? new NavigationPropertyMain.NavigationPropertyEntitySet(this.name, this.priority) : new NavigationPropertyMain.NavigationPropertyEntity(this.name, this.required, this.priority);
        this.targetEntityType = modelRegistry.getEntityTypeForName(this.entityType, true);
        if (this.targetEntityType == null) {
            LOGGER.error("Failed to find target EntityType: {} for navProp {} in {}", this.entityType, this.name, this.sourceEntityType);
            throw new IllegalArgumentException("Missing entityType: " + this.entityType);
        }
        this.navProp.setEntityType(this.targetEntityType);
        this.sourceEntityType.registerProperty(this.navProp);
        this.navProp.addAnnotations(this.annotations);
        if (this.symmetrical) {
            this.navPropInverse = this.targetEntityType.getNavigationProperty(this.name);
            if (this.navPropInverse == null) {
                this.navPropInverse = this.navProp;
            }
            LOGGER.debug("    {} -> {} -> {}", this.name, this.targetEntityType.entityName, this.navPropInverse.getName());
            this.navProp.setInverses(this.navPropInverse);
        } else if (this.inverse == null) {
            LOGGER.debug("    {} -> {}", (Object)this.name, (Object)this.targetEntityType.entityName);
            LOGGER.warn("No inverse for navigation property {}", (Object)this.name);
        } else {
            this.navPropInverse = this.targetEntityType.getNavigationProperty(this.inverse.name);
            if (this.navPropInverse == null) {
                this.navPropInverse = this.inverse.entitySet ? new NavigationPropertyMain.NavigationPropertyEntitySet(this.inverse.name, this.navProp, this.inverse.priority) : new NavigationPropertyMain.NavigationPropertyEntity(this.inverse.name, this.navProp, this.inverse.required, this.inverse.priority);
                this.navPropInverse.setEntityType(this.sourceEntityType);
                this.navPropInverse.addAnnotations(this.inverse.annotations);
                this.targetEntityType.registerProperty(this.navPropInverse);
            }
            LOGGER.debug("    {} -> {} -> {}", this.name, this.targetEntityType.entityName, this.navPropInverse.getName());
            this.navProp.setInverses(this.navPropInverse);
        }
    }

    public NavigationPropertyMain getNavigationProperty() {
        return this.navProp;
    }

    public NavigationPropertyMain getNavigationPropertyInverse() {
        return this.navPropInverse;
    }

    public String getName() {
        return this.name;
    }

    public DefNavigationProperty setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isEntitySet() {
        return this.entitySet;
    }

    public DefNavigationProperty setEntitySet(boolean entitySet) {
        this.entitySet = entitySet;
        return this;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public DefNavigationProperty setEntityType(String entityType) {
        this.entityType = entityType;
        return this;
    }

    public boolean isRequired() {
        return this.required;
    }

    public DefNavigationProperty setRequired(boolean required) {
        this.required = required;
        return this;
    }

    public List<PropertyPersistenceMapper> getHandlers() {
        if (this.handlers == null) {
            this.handlers = new ArrayList<PropertyPersistenceMapper>();
        }
        return this.handlers;
    }

    public DefNavigationProperty setHandlers(List<PropertyPersistenceMapper> handlers) {
        this.handlers = handlers;
        return this;
    }

    public DefNavigationProperty addHandler(PropertyPersistenceMapper handler) {
        this.getHandlers().add(handler);
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean isSymmetrical() {
        return this.symmetrical;
    }

    public DefNavigationProperty setSymmetrical(boolean symmetrical) {
        this.symmetrical = symmetrical;
        return this;
    }

    public Inverse getInverse() {
        if (this.symmetrical) {
            return new Inverse().setName(this.name).setEntitySet(this.entitySet).setRequired(this.required).addAnnotations(this.annotations);
        }
        return this.inverse;
    }

    public DefNavigationProperty setInverse(Inverse inverse) {
        if (this.symmetrical && inverse != null) {
            LOGGER.error("NavigationProperty {} set to be symmetrical, inverse is ignored!", (Object)this.name);
        } else {
            this.inverse = inverse;
        }
        return this;
    }

    public EntityType getSourceEntityType() {
        return this.sourceEntityType;
    }

    public DefNavigationProperty setSourceEntityType(EntityType sourceEntityType) {
        this.sourceEntityType = sourceEntityType;
        return this;
    }

    public EntityType getTargetEntityType() {
        return this.targetEntityType;
    }

    public DefNavigationProperty setTargetEntityType(EntityType targetEntityType) {
        this.targetEntityType = targetEntityType;
        return this;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public DefNavigationProperty addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
        return this;
    }

    public DefNavigationProperty addAnnotations(List<Annotation> annotationsToAdd) {
        this.annotations.addAll(annotationsToAdd);
        return this;
    }

    public static class Inverse {
        @ConfigurableField(editor=EditorString.class, label="Name", description="The name of the Entity Type.")
        @EditorString.EdOptsString
        private String name;
        @ConfigurableField(editor=EditorBoolean.class, label="Is A Set", description="Flag indicating the NavigationProperty points to an EntitySet.")
        @EditorBoolean.EdOptsBool
        private boolean entitySet;
        @ConfigurableField(editor=EditorBoolean.class, label="Required", description="Flag indicating the property must be set.")
        @EditorBoolean.EdOptsBool
        private boolean required;
        @ConfigurableField(editor=EditorInt.class, label="Priority", description="The priority for ordering.")
        @EditorInt.EdOptsInt(min=-999, max=999)
        private int priority;
        @ConfigurableField(editor=EditorList.class, label="Annotations", description="The (OData)annotations for this Element.")
        @EditorList.EdOptsList(editor=EditorSubclass.class)
        @EditorSubclass.EdOptsSubclass(iface=Annotation.class, merge=true, nameField="@class", shortenClassNames=true)
        private final List<Annotation> annotations = new ArrayList<Annotation>();

        public String getName() {
            return this.name;
        }

        public Inverse setName(String name) {
            this.name = name;
            return this;
        }

        public boolean isEntitySet() {
            return this.entitySet;
        }

        public Inverse setEntitySet(boolean entitySet) {
            this.entitySet = entitySet;
            return this;
        }

        public boolean isRequired() {
            return this.required;
        }

        public Inverse setRequired(boolean required) {
            this.required = required;
            return this;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        public Inverse addAnnotation(Annotation annotation) {
            this.annotations.add(annotation);
            return this;
        }

        public Inverse addAnnotations(List<Annotation> annotationsToAdd) {
            this.annotations.addAll(annotationsToAdd);
            return this;
        }
    }
}

