/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.model.loader;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.fraunhofer.iosb.ilt.configurable.AnnotatedConfigurable;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableClass;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorBoolean;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorClass;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorList;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorSubclass;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.annotations.Annotation;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.DefEntityProperty;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.DefNavigationProperty;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.DefPmHook;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.DefValidator;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.query.OrderBy;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.Path;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigurableClass
public class DefEntityType
implements AnnotatedConfigurable<Void, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefEntityType.class.getName());
    @ConfigurableField(editor=EditorString.class, label="Name", description="The name of the Entity Type.")
    @EditorString.EdOptsString
    private String name;
    @ConfigurableField(editor=EditorString.class, label="Plural", description="The name to use for for sets of this entity type.")
    @EditorString.EdOptsString
    private String plural;
    @ConfigurableField(editor=EditorBoolean.class, label="Admin Only", description="Flag indicating only admin users are allowed to see the target entity type.")
    @EditorBoolean.EdOptsBool
    private boolean adminOnly;
    @ConfigurableField(editor=EditorString.class, label="Table", description="The 'table' that data for this EntityType is stored in. What this exactly means depends on the PersistenceManager.")
    @EditorString.EdOptsString
    private String table;
    @ConfigurableField(editor=EditorList.class, label="OrderBy", description="The default way to order this entity type.")
    @EditorList.EdOptsList(editor=EditorString.class)
    @EditorString.EdOptsString
    private List<String> orderByDflt;
    @ConfigurableField(editor=EditorList.class, label="EntityProps")
    @EditorList.EdOptsList(editor=EditorClass.class)
    @EditorClass.EdOptsClass(clazz=DefEntityProperty.class)
    private List<DefEntityProperty> entityProperties;
    @ConfigurableField(editor=EditorList.class, label="NavProps")
    @EditorList.EdOptsList(editor=EditorClass.class)
    @EditorClass.EdOptsClass(clazz=DefNavigationProperty.class)
    private List<DefNavigationProperty> navigationProperties;
    @ConfigurableField(editor=EditorClass.class, optional=true, label="Validators", description="Entity Validators")
    @EditorClass.EdOptsClass(clazz=DefValidator.class)
    private DefValidator validators;
    @ConfigurableField(editor=EditorList.class, optional=true, label="PM Hooks", description="Persistence Manager Hooks")
    @EditorList.EdOptsList(editor=EditorClass.class)
    @EditorClass.EdOptsClass(clazz=DefPmHook.class)
    private List<DefPmHook> hooks = new ArrayList<DefPmHook>();
    @ConfigurableField(editor=EditorList.class, label="Annotations", description="The (OData)annotations for this Element.")
    @EditorList.EdOptsList(editor=EditorSubclass.class)
    @EditorSubclass.EdOptsSubclass(iface=Annotation.class, merge=true, nameField="@class", shortenClassNames=true)
    private final List<Annotation> annotations = new ArrayList<Annotation>();
    @JsonIgnore
    private EntityType entityType;

    public void init() {
        int idx = 0;
        int keyIdx = -1;
        for (DefEntityProperty defEntityProperty : this.getEntityProperties()) {
            defEntityProperty.init();
            if ("id".equalsIgnoreCase(defEntityProperty.getType())) {
                keyIdx = idx;
            }
            ++idx;
        }
        if (keyIdx > 0) {
            LOGGER.debug("Moving Id column from {} to the front.", (Object)keyIdx);
            this.entityProperties.add(0, this.entityProperties.remove(keyIdx));
        }
        for (DefNavigationProperty defNavigationProperty : this.getNavigationProperties()) {
            defNavigationProperty.init();
        }
    }

    public EntityType getEntityType(ModelRegistry modelRegistry) {
        if (this.entityType == null) {
            this.entityType = modelRegistry.getEntityTypeForName(this.name, true);
            if (this.entityType == null) {
                this.entityType = new EntityType(this.name, this.plural, this.adminOnly);
            } else if (this.adminOnly && !this.entityType.isAdminOnly()) {
                this.entityType.setAdminOnly(this.adminOnly);
            }
            if (this.validators != null) {
                this.validators.createValidators(modelRegistry, this.entityType);
            }
            this.entityType.addAnnotations(this.annotations);
        }
        return this.entityType;
    }

    public List<DefPmHook> getHooks() {
        return this.hooks;
    }

    public void setHooks(List<DefPmHook> hooks) {
        this.hooks = hooks;
    }

    public void linkProperties(ModelRegistry modelRegistry) {
        LOGGER.debug("  {} ({})", (Object)this.name, (Object)this.plural);
        for (DefEntityProperty defEp : this.entityProperties) {
            defEp.setEntityType(this.entityType);
            defEp.registerProperties(modelRegistry);
        }
        for (DefNavigationProperty defNp : this.navigationProperties) {
            defNp.setSourceEntityType(this.entityType);
            defNp.registerProperties(modelRegistry);
        }
        if (!StringHelper.isNullOrEmpty(this.orderByDflt)) {
            for (String ob : this.orderByDflt) {
                Property property = this.entityType.getProperty(ob);
                this.entityType.addOrderByDefault(new OrderBy(new Path(property)));
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public DefEntityType setName(String name) {
        this.name = name;
        return this;
    }

    public String getPlural() {
        return this.plural;
    }

    public DefEntityType setPlural(String plural) {
        this.plural = plural;
        return this;
    }

    public List<DefEntityProperty> getEntityProperties() {
        if (this.entityProperties == null) {
            this.entityProperties = new ArrayList<DefEntityProperty>();
        }
        return this.entityProperties;
    }

    public DefEntityType setEntityProperties(List<DefEntityProperty> entityProperties) {
        this.entityProperties = entityProperties;
        return this;
    }

    public DefEntityType addEntityProperty(DefEntityProperty entityProperty) {
        if ("id".equalsIgnoreCase(entityProperty.getType())) {
            LOGGER.debug("Inserting ID column at position 0");
            this.getEntityProperties().add(0, entityProperty);
        } else {
            this.getEntityProperties().add(entityProperty);
        }
        return this;
    }

    public DefEntityProperty getPrimaryKey() {
        for (DefEntityProperty property : this.getEntityProperties()) {
            if (!"id".equalsIgnoreCase(property.getType())) continue;
            return property;
        }
        LOGGER.warn("No primary key defined for {}", (Object)this.getName());
        return null;
    }

    public List<DefNavigationProperty> getNavigationProperties() {
        if (this.navigationProperties == null) {
            this.navigationProperties = new ArrayList<DefNavigationProperty>();
        }
        return this.navigationProperties;
    }

    public DefEntityType setNavigationProperties(List<DefNavigationProperty> navigationProperties) {
        this.navigationProperties = navigationProperties;
        return this;
    }

    public DefEntityType addNavigationProperty(DefNavigationProperty navigationProperty) {
        this.getNavigationProperties().add(navigationProperty);
        return this;
    }

    public String getTable() {
        return this.table;
    }

    public DefEntityType setTable(String table) {
        this.table = table;
        return this;
    }

    public DefValidator getValidators() {
        return this.validators;
    }

    public DefEntityType setValidators(DefValidator validators) {
        this.validators = validators;
        return this;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public DefEntityType addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
        return this;
    }

    public DefEntityType addAnnotations(List<Annotation> annotations) {
        this.annotations.addAll(annotations);
        return this;
    }

    public boolean isAdminOnly() {
        return this.adminOnly;
    }

    public void setAdminOnly(boolean adminOnly) {
        this.adminOnly = adminOnly;
    }

    public List<String> getOrderByDflt() {
        return this.orderByDflt;
    }

    public void setOrderByDflt(List<String> orderByDflt) {
        this.orderByDflt = orderByDflt;
    }
}

