/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.model.loader;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.fraunhofer.iosb.ilt.configurable.AnnotatedConfigurable;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorBoolean;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorList;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorSubclass;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.annotations.Annotation;
import de.fraunhofer.iosb.ilt.frostserver.model.loader.PropertyPersistenceMapper;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.type.PropertyType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefEntityProperty
implements AnnotatedConfigurable<Void, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefEntityProperty.class.getName());
    @ConfigurableField(editor=EditorString.class, label="Name", description="The name of the EntityProperty.")
    @EditorString.EdOptsString
    private String name;
    @ConfigurableField(editor=EditorString.class, optional=true, label="Description", description="The description of the EntityProperty.")
    @EditorString.EdOptsString
    private String description;
    @ConfigurableField(editor=EditorList.class, optional=true, label="Aliases", description="Aliases for the name of the Property.")
    @EditorList.EdOptsList(editor=EditorString.class)
    @EditorString.EdOptsString
    private List<String> aliases;
    @ConfigurableField(editor=EditorString.class, label="Type", description="The java type (Class) of the Property.")
    @EditorString.EdOptsString(dflt="Edm.String")
    private String type;
    @ConfigurableField(editor=EditorBoolean.class, optional=true, label="Required", description="Flag indicating the property must be set.")
    @EditorBoolean.EdOptsBool
    private boolean required;
    @ConfigurableField(editor=EditorBoolean.class, optional=true, label="Nullable", description="Flag indicating the property may be set to null.")
    @EditorBoolean.EdOptsBool(dflt=true)
    private boolean nullable = true;
    @ConfigurableField(editor=EditorBoolean.class, optional=true, label="Serialise NULL", description="Flag indicating this property must always be serialised, even if it is null.")
    @EditorBoolean.EdOptsBool
    private boolean serialiseNull;
    @ConfigurableField(editor=EditorBoolean.class, optional=true, label="HasCustomProps", description="Flag indicating this property is a complex property with sub-properties that can be queried.")
    @EditorBoolean.EdOptsBool
    private boolean hasCustomProperties;
    @ConfigurableField(editor=EditorList.class, label="Handlers", description="The handler(s) defining the database access.")
    @EditorList.EdOptsList(editor=EditorSubclass.class)
    @EditorSubclass.EdOptsSubclass(iface=PropertyPersistenceMapper.class, merge=true, nameField="@class", shortenClassNames=true)
    private List<PropertyPersistenceMapper> handlers;
    @ConfigurableField(editor=EditorList.class, label="Annotations", description="The (OData)annotations for this Element.")
    @EditorList.EdOptsList(editor=EditorSubclass.class)
    @EditorSubclass.EdOptsSubclass(iface=Annotation.class, merge=true, nameField="@class", shortenClassNames=true)
    private final List<Annotation> annotations = new ArrayList<Annotation>();
    @JsonIgnore
    private EntityType entityType;
    @JsonIgnore
    private EntityPropertyMain entityProperty;

    public void init() {
        if (this.aliases == null) {
            this.aliases = Collections.emptyList();
        }
        if (this.handlers == null) {
            this.handlers = Collections.emptyList();
        }
        for (PropertyPersistenceMapper handler : this.handlers) {
            handler.setParent(this);
        }
    }

    public void registerProperties(ModelRegistry modelRegistry) {
        if (this.entityProperty == null) {
            PropertyType propType = modelRegistry.getPropertyType(this.type);
            this.entityProperty = new EntityPropertyMain(this.name, propType, this.required, this.isNullable(), this.hasCustomProperties, this.serialiseNull).setAliases((String[])this.aliases.toArray(String[]::new)).addAnnotations(this.annotations);
        }
        LOGGER.debug("    {} ({})", (Object)this.name, (Object)this.type);
        this.entityType.registerProperty(this.entityProperty);
    }

    public EntityPropertyMain getEntityProperty() {
        return this.entityProperty;
    }

    public String getName() {
        return this.name;
    }

    public DefEntityProperty setName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public DefEntityProperty setDescription(String description) {
        this.description = description;
        return this;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public DefEntityProperty setAliases(List<String> aliases) {
        this.aliases = aliases;
        return this;
    }

    public DefEntityProperty addAlias(String alias) {
        if (this.aliases == null) {
            this.aliases = new ArrayList<String>();
        }
        this.aliases.add(alias);
        return this;
    }

    public String getType() {
        return this.type;
    }

    public DefEntityProperty setType(String type) {
        this.type = type;
        return this;
    }

    public boolean isRequired() {
        return this.required;
    }

    public DefEntityProperty setRequired(boolean required) {
        this.required = required;
        return this;
    }

    public List<PropertyPersistenceMapper> getHandlers() {
        if (this.handlers == null) {
            this.handlers = new ArrayList<PropertyPersistenceMapper>();
        }
        return this.handlers;
    }

    public DefEntityProperty setHandlers(List<PropertyPersistenceMapper> handlers) {
        this.handlers = handlers;
        return this;
    }

    public DefEntityProperty addHandler(PropertyPersistenceMapper handler) {
        this.getHandlers().add(handler);
        return this;
    }

    public boolean getSerialiseNull() {
        return this.serialiseNull;
    }

    public DefEntityProperty setSerialiseNull(boolean serialiseNull) {
        this.serialiseNull = serialiseNull;
        return this;
    }

    public boolean getHasCustomProperties() {
        return this.hasCustomProperties;
    }

    public DefEntityProperty setHasCustomProperties(boolean hasCustomProperties) {
        this.hasCustomProperties = hasCustomProperties;
        return this;
    }

    public DefEntityProperty setEntityType(EntityType entityType) {
        this.entityType = entityType;
        return this;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public DefEntityProperty addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
        return this;
    }

    public DefEntityProperty addAnnotations(List<Annotation> annotationsToAdd) {
        this.annotations.addAll(annotationsToAdd);
        return this;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }
}

