/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.model.ext;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.fraunhofer.iosb.ilt.frostserver.model.ComplexValue;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeSimplePrimitive;
import de.fraunhofer.iosb.ilt.frostserver.util.SimpleJsonMapper;
import java.util.Objects;

public class UnitOfMeasurement
implements ComplexValue<UnitOfMeasurement> {
    public static final EntityPropertyMain<String> EP_NAME = new EntityPropertyMain("name", TypeSimplePrimitive.EDM_STRING);
    public static final EntityPropertyMain<String> EP_DEFINITION = new EntityPropertyMain("definition", TypeSimplePrimitive.EDM_STRING);
    public static final EntityPropertyMain<String> EP_SYMBOL = new EntityPropertyMain("symbol", TypeSimplePrimitive.EDM_STRING);
    private String name;
    private String symbol;
    private String definition;

    public UnitOfMeasurement() {
    }

    public UnitOfMeasurement(String name, String symbol, String definition) {
        this.name = name;
        this.symbol = symbol;
        this.definition = definition;
    }

    @Override
    public Object getProperty(String name) {
        switch (name) {
            case "name": {
                return this.getName();
            }
            case "symbol": {
                return this.getSymbol();
            }
            case "definition": {
                return this.getDefinition();
            }
        }
        return null;
    }

    @Override
    public UnitOfMeasurement setProperty(String name, Object value) {
        switch (name) {
            case "name": {
                return this.setName((String)value);
            }
            case "symbol": {
                return this.setSymbol((String)value);
            }
            case "definition": {
                return this.setDefinition((String)value);
            }
        }
        return this;
    }

    @Override
    public <P> P getProperty(Property<P> property) {
        if (property == EP_NAME) {
            return (P)this.name;
        }
        if (property == EP_DEFINITION) {
            return (P)this.definition;
        }
        if (property == EP_SYMBOL) {
            return (P)this.symbol;
        }
        throw new IllegalArgumentException("Unknown sub-property: " + property);
    }

    @Override
    public <P> UnitOfMeasurement setProperty(Property<P> property, P value) {
        if (property == EP_NAME) {
            return this.setName((String)value);
        }
        if (property == EP_DEFINITION) {
            return this.setDefinition((String)value);
        }
        if (property == EP_SYMBOL) {
            return this.setSymbol((String)value);
        }
        throw new IllegalArgumentException("Unknown sub-property: " + property);
    }

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getDefinition() {
        return this.definition;
    }

    public UnitOfMeasurement setName(String name) {
        this.name = name;
        return this;
    }

    public UnitOfMeasurement setSymbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    public UnitOfMeasurement setDefinition(String definition) {
        this.definition = definition;
        return this;
    }

    public String toString() {
        try {
            return SimpleJsonMapper.getSimpleObjectMapper().writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            return super.toString();
        }
    }

    public int hashCode() {
        return Objects.hash(this.name, this.symbol, this.definition);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnitOfMeasurement other = (UnitOfMeasurement)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.symbol, other.symbol)) {
            return false;
        }
        return Objects.equals(this.definition, other.definition);
    }
}

