/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.model.ext;

import de.fraunhofer.iosb.ilt.frostserver.model.ComplexValue;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeInstant;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeObject;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeComplex;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.text.ParseException;
import java.time.Instant;
import java.util.Objects;
import net.time4j.Moment;
import net.time4j.range.MomentInterval;

public class TimeInterval
implements TimeObject,
ComplexValue<TimeInterval> {
    public static EntityPropertyMain<TimeInstant> EP_START_TIME = TypeComplex.EP_START_TIME;
    public static EntityPropertyMain<TimeInstant> EP_END_TIME = TypeComplex.EP_INTERVAL_END_TIME;
    private MomentInterval interval;

    public TimeInterval() {
        this.interval = MomentInterval.between(Moment.nowInSystemTime(), Moment.nowInSystemTime());
    }

    public TimeInterval(MomentInterval interval) {
        if (interval == null) {
            throw new IllegalArgumentException("Interval must be non-null");
        }
        this.interval = interval;
    }

    public int hashCode() {
        return Objects.hash(this.interval);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeInterval other = (TimeInterval)obj;
        return Objects.equals(this.interval, other.interval);
    }

    public static TimeInterval create(Moment start, Moment end) {
        return new TimeInterval(MomentInterval.between(start, end));
    }

    public static TimeInterval parse(String value) {
        try {
            return new TimeInterval(MomentInterval.parseISO(value));
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Failed to parse TimeInterval " + StringHelper.cleanForLogging(value), ex);
        }
    }

    public MomentInterval getInterval() {
        return this.interval;
    }

    @Override
    public boolean isEmpty() {
        return this.interval == null;
    }

    @Override
    public String asISO8601() {
        return StringHelper.FORMAT_INTERVAL.print(this.interval);
    }

    public String toString() {
        return this.asISO8601();
    }

    public Moment getStart() {
        return this.interval.getStartAsMoment();
    }

    public Moment getEnd() {
        return this.interval.getEndAsMoment();
    }

    @Override
    public Object getProperty(String name) {
        switch (name) {
            case "start": {
                return this.interval.getStartAsMoment();
            }
            case "end": {
                return this.interval.getEndAsMoment();
            }
        }
        throw new IllegalArgumentException("Unknown sub-property: " + name);
    }

    @Override
    public TimeInterval setProperty(String name, Object value) {
        switch (name) {
            case "start": {
                return this.setProperty((Property)EP_START_TIME, value);
            }
            case "end": {
                return this.setProperty((Property)EP_END_TIME, value);
            }
        }
        throw new IllegalArgumentException("Unknown sub-property: " + name);
    }

    @Override
    public <P> P getProperty(Property<P> property) {
        if (property == EP_START_TIME) {
            return (P)this.interval.getStartAsMoment();
        }
        if (property == EP_END_TIME) {
            return (P)this.interval.getStartAsMoment();
        }
        throw new IllegalArgumentException("Unknown sub-property: " + property);
    }

    @Override
    public TimeInterval setProperty(Property property, Object value) {
        Moment moment;
        if (value == null) {
            return this;
        }
        if (value instanceof Moment) {
            Moment m4;
            moment = m4 = (Moment)value;
        } else if (value instanceof Instant) {
            Instant i = (Instant)value;
            moment = Moment.from(i);
        } else {
            throw new IllegalArgumentException("TimeInterval only accepts Moment or Instant, not " + value.getClass().getName());
        }
        if (property == EP_START_TIME) {
            this.interval = (MomentInterval)this.interval.withStart(moment);
            return this;
        }
        if (property == EP_END_TIME) {
            this.interval = (MomentInterval)((MomentInterval)this.interval.withEnd(moment)).withOpenEnd();
            return this;
        }
        throw new IllegalArgumentException("Unknown sub-property: " + property);
    }
}

