/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.model.core;

import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntityValidator;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeInstant;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncompleteEntityException;
import net.time4j.Moment;

public class TimeDefaultValidator
implements EntityValidator {
    @ConfigurableField(editor=EditorString.class, label="propertyName", description="Name of the property to auto fill")
    @EditorString.EdOptsString
    private String propertyName;
    private EntityPropertyMain epTime;

    @Override
    public void validate(Entity entity) throws IncompleteEntityException {
        if (this.epTime == null) {
            this.epTime = entity.getEntityType().getEntityProperty(this.propertyName);
        }
        if (entity.getProperty(this.epTime) == null) {
            entity.setProperty(this.epTime, new TimeInstant(Moment.nowInSystemTime()));
        }
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }
}

