/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.model.core;

import de.fraunhofer.iosb.ilt.frostserver.model.core.PrimaryKey;
import de.fraunhofer.iosb.ilt.frostserver.path.UrlHelper;
import java.util.Arrays;
import java.util.Iterator;

public class PkValue
implements Iterable<Object> {
    private final Object[] values;

    public PkValue(int size) {
        this.values = new Object[size];
    }

    public PkValue(Object[] value) {
        this.values = value;
    }

    public Object get(int idx) {
        return this.values[idx];
    }

    public PkValue set(int idx, Object value) {
        this.values[idx] = value;
        return this;
    }

    public String getUrl(PrimaryKey pk) {
        return UrlHelper.quoteForUrl(pk, this);
    }

    public boolean isFullySet() {
        for (Object value : this.values) {
            if (value != null) continue;
            return false;
        }
        return true;
    }

    public boolean isFullyUnSet() {
        for (Object value : this.values) {
            if (value == null) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PkValue other = (PkValue)obj;
        return Arrays.equals(this.values, other.values);
    }

    public int hashCode() {
        int hash = 5;
        return 41 * hash + Arrays.hashCode(this.values);
    }

    public int size() {
        return this.values.length;
    }

    @Override
    public Iterator<Object> iterator() {
        return Arrays.stream(this.values).iterator();
    }

    public static PkValue of(Object ... value) {
        for (Object item : value) {
            if (!(item instanceof PkValue)) continue;
            throw new IllegalArgumentException("Wrapping a PkValue in a PkValue!");
        }
        return new PkValue(value);
    }

    public String toString() {
        return Arrays.toString(this.values);
    }
}

