/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.model.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class EntitySetImpl
implements EntitySet {
    protected final List<Entity> data = new ArrayList<Entity>();
    protected long count = -1L;
    protected String nextLink;
    @JsonIgnore
    private final EntityType type;
    @JsonIgnore
    private NavigationPropertyMain.NavigationPropertyEntitySet navigationProperty;

    public EntitySetImpl(EntityType type) {
        this.type = type;
    }

    public EntitySetImpl(NavigationPropertyMain.NavigationPropertyEntitySet navigationProperty) {
        this.type = navigationProperty.getEntityType();
        this.navigationProperty = navigationProperty;
    }

    @Override
    public Entity first() {
        return this.data.get(0);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public Iterator<Entity> iterator() {
        return this.data.iterator();
    }

    @Override
    public void add(Entity e) {
        this.data.add(e);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntitySetImpl other = (EntitySetImpl)obj;
        return Objects.equals(this.data, other.data);
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public void setCount(long count) {
        this.count = count;
    }

    @Override
    public String getNextLink() {
        return this.nextLink;
    }

    @Override
    public void setNextLink(String nextLink) {
        this.nextLink = nextLink;
    }

    @Override
    public EntityType getEntityType() {
        return this.type;
    }

    @Override
    public NavigationPropertyMain.NavigationPropertyEntitySet getNavigationProperty() {
        return this.navigationProperty;
    }

    public EntitySetImpl setNavigationProperty(NavigationPropertyMain.NavigationPropertyEntitySet navigationProperty) {
        this.navigationProperty = navigationProperty;
        return this;
    }
}

