/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.model.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityChangedMessage;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.NavigableElement;
import de.fraunhofer.iosb.ilt.frostserver.model.core.PkValue;
import de.fraunhofer.iosb.ilt.frostserver.model.core.PrimaryKey;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntity;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.Path;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncompleteEntityException;

public interface Entity
extends NavigableElement {
    public PrimaryKey getPrimaryKey();

    public PkValue getPrimaryKeyValues();

    public boolean primaryKeyFullySet();

    public Entity setPrimaryKeyValues(PkValue var1);

    public String getSelfLink();

    public Entity setSelfLink(String var1);

    @JsonIgnore
    public EntityType getEntityType();

    public Entity setEntityType(EntityType var1);

    public boolean isSetProperty(Property var1);

    public <P> P getProperty(Property<P> var1);

    public Object getProperty(Path var1);

    public <P> Entity setProperty(Property<P> var1, P var2);

    public Entity unsetProperty(Property var1);

    public Entity addNavigationEntity(NavigationPropertyMain.NavigationPropertyEntitySet var1, Entity var2);

    default public void setEntityPropertiesSet() {
        this.setEntityPropertiesSet(true, false);
    }

    @JsonIgnore
    public void setEntityPropertiesSet(boolean var1, boolean var2);

    @JsonIgnore
    public void setEntityPropertiesSet(Entity var1, EntityChangedMessage var2);

    default public void validateCreate() throws IncompleteEntityException {
        this.getEntityType().validateCreate(this);
    }

    default public void validateUpdate() throws IncompleteEntityException {
        this.getEntityType().validateUpdate(this);
    }

    public Query getQuery();

    public Entity setQuery(Query var1);

    @JsonIgnore
    default public ResourcePath getPath() {
        EntityType type = this.getEntityType();
        PathElementEntity epe = new PathElementEntity(type, null);
        epe.setPkValues(this.getPrimaryKeyValues());
        ResourcePath resourcePath = new ResourcePath();
        resourcePath.addPathElement(epe, true, false);
        return resourcePath;
    }
}

