/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.model;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityChangedMessage;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.path.CustomLinksHelper;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.type.PropertyType;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeComplex;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeSimpleCustom;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeSimplePrimitive;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelRegistry.class.getName());
    public static final EntityPropertyMain<String> EP_SELFLINK = new EntityPropertyMain("@iot.selfLink", TypeSimplePrimitive.EDM_STRING).setAliases("selfLink");
    public static final EntityPropertyMain<Map<String, Object>> EP_PROPERTIES = new EntityPropertyMain("properties", TypeComplex.STA_MAP, false, true, true, false);
    public static final EntityPropertyMain<String> EP_ENCODINGTYPE = new EntityPropertyMain("encodingType", TypeSimplePrimitive.EDM_STRING, true, false);
    private final Map<String, EntityType> entityTypesByName = new TreeMap<String, EntityType>();
    private final Set<EntityType> entityTypesAll = new TreeSet<EntityType>();
    private final Set<EntityType> entityTypesNonAdmin = new TreeSet<EntityType>();
    private final Map<String, PropertyType> propertyTypes = new TreeMap<String, PropertyType>();
    private CustomLinksHelper customLinksHelper;
    private final EntityChangedMessage.QueryGenerator messageQueryGenerator = new EntityChangedMessage.QueryGenerator();

    public final ModelRegistry registerEntityType(EntityType type) {
        EntityType existing = this.entityTypesByName.get(type.entityName);
        if (existing == type) {
            LOGGER.info("Entity type {} already registered.", (Object)type.entityName);
            return this;
        }
        if (existing != null) {
            LOGGER.error("Duplicate entity type name: {}", (Object)type.entityName);
            throw new IllegalArgumentException("An entity type named " + type.entityName + " is already registered");
        }
        this.entityTypesByName.put(type.entityName, type);
        this.entityTypesByName.put(type.plural, type);
        this.entityTypesAll.add(type);
        if (!type.isAdminOnly()) {
            this.entityTypesNonAdmin.add(type);
        }
        type.setModelRegistry(this);
        return this;
    }

    public final EntityType getEntityTypeForName(String typeName) {
        return this.getEntityTypeForName(typeName, false);
    }

    public final EntityType getEntityTypeForName(String typeName, boolean isAdmin) {
        EntityType type = this.entityTypesByName.get(typeName);
        if (type == null) {
            return null;
        }
        if (!isAdmin && type.isAdminOnly()) {
            return null;
        }
        return type;
    }

    public final Set<EntityType> getEntityTypes() {
        return this.entityTypesNonAdmin;
    }

    public final Set<EntityType> getEntityTypes(boolean isAdmin) {
        if (isAdmin) {
            return this.entityTypesAll;
        }
        return this.entityTypesNonAdmin;
    }

    public ModelRegistry registerPropertyType(PropertyType type) {
        this.propertyTypes.put(type.getName(), type);
        return this;
    }

    public final PropertyType getPropertyType(String name) {
        PropertyType type = this.propertyTypes.get(name);
        if (type != null) {
            return type;
        }
        type = TypeSimplePrimitive.getType(name);
        if (type != null) {
            return type;
        }
        type = TypeSimpleCustom.getType(name);
        if (type != null) {
            this.registerPropertyType(type);
            return type;
        }
        type = TypeComplex.getType(name);
        if (type != null) {
            this.registerPropertyType(type);
            return type;
        }
        throw new IllegalArgumentException("unknown property type: " + name);
    }

    public Map<String, PropertyType> getPropertyTypes() {
        return this.propertyTypes;
    }

    public EntityChangedMessage.QueryGenerator getMessageQueryGenerator() {
        return this.messageQueryGenerator;
    }

    public synchronized void initFinalise() {
        LOGGER.info("Finalising {} EntityTypes.", (Object)this.entityTypesAll.size());
        for (EntityType type : this.entityTypesAll) {
            type.init();
        }
    }

    public CustomLinksHelper getCustomLinksHelper() {
        if (this.customLinksHelper == null) {
            this.customLinksHelper = new CustomLinksHelper(this, false, 0);
        }
        return this.customLinksHelper;
    }
}

