/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.model;

import de.fraunhofer.iosb.ilt.frostserver.model.DefaultEntity;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntityValidator;
import de.fraunhofer.iosb.ilt.frostserver.model.core.PkSingle;
import de.fraunhofer.iosb.ilt.frostserver.model.core.PkValue;
import de.fraunhofer.iosb.ilt.frostserver.model.core.PrimaryKey;
import de.fraunhofer.iosb.ilt.frostserver.model.core.annotations.Annotatable;
import de.fraunhofer.iosb.ilt.frostserver.model.core.annotations.Annotation;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntity;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.query.OrderBy;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.Path;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncompleteEntityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityType
implements Annotatable,
Comparable<EntityType> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityType.class.getName());
    public final String entityName;
    public final String plural;
    private boolean adminOnly;
    private Object idGenerationMode;
    private boolean initialised = false;
    private PrimaryKey primaryKey;
    private final Set<Property> properties = new LinkedHashSet<Property>();
    private final Map<String, Property> propertiesByName = new LinkedHashMap<String, Property>();
    private final Set<EntityPropertyMain> entityProperties = new LinkedHashSet<EntityPropertyMain>();
    private final Set<NavigationPropertyMain> navigationProperties = new TreeSet<NavigationPropertyMain>();
    private final Set<NavigationPropertyMain<Entity>> navigationEntities = new TreeSet<NavigationPropertyMain<Entity>>();
    private final Set<NavigationPropertyMain<EntitySet>> navigationSets = new TreeSet<NavigationPropertyMain<EntitySet>>();
    private final Map<String, EntityValidator> validatorsCreateEntity = new LinkedHashMap<String, EntityValidator>();
    private final Map<String, EntityValidator> validatorsUpdateEntity = new LinkedHashMap<String, EntityValidator>();
    private final List<Annotation> annotations = new ArrayList<Annotation>();
    private final List<OrderBy> orderbyDefaults = new ArrayList<OrderBy>();
    private ModelRegistry modelRegistry;

    public EntityType(String singular, String plural) {
        this(singular, plural, false);
    }

    public EntityType(String singular, String plural, boolean adminOnly) {
        this.entityName = singular;
        this.plural = plural;
        this.adminOnly = adminOnly;
    }

    public EntityType registerProperty(Property property) {
        this.properties.add(property);
        this.propertiesByName.put(property.getName(), property);
        if (property instanceof EntityPropertyMain) {
            EntityPropertyMain epm = (EntityPropertyMain)property;
            for (String alias : epm.getAliases()) {
                this.propertiesByName.put(alias, property);
            }
            if (this.primaryKey == null) {
                this.primaryKey = new PkSingle(epm);
            }
        }
        return this;
    }

    public boolean isAdminOnly() {
        return this.adminOnly;
    }

    public void setAdminOnly(boolean adminOnly) {
        this.adminOnly = adminOnly;
    }

    public void init() {
        if (this.initialised) {
            LOGGER.error("Re-Init of EntityType!");
        }
        this.initialised = true;
        for (Property property : this.properties) {
            if (property instanceof EntityPropertyMain) {
                EntityPropertyMain entityPropertyMain = (EntityPropertyMain)property;
                this.entityProperties.add(entityPropertyMain);
            }
            if (!(property instanceof NavigationPropertyMain)) continue;
            NavigationPropertyMain np = (NavigationPropertyMain)property;
            if (np.getEntityType() == null) {
                np.setEntityType(this.modelRegistry.getEntityTypeForName(np.getName(), true));
            }
            this.navigationProperties.add(np);
            if (np.isEntitySet()) {
                this.navigationSets.add(np);
                continue;
            }
            this.navigationEntities.add(np);
        }
        int pkCount = 0;
        for (EntityPropertyMain keyProp : this.primaryKey.getKeyProperties()) {
            String pkName = keyProp.getName();
            for (OrderBy order : this.orderbyDefaults) {
                if (!pkName.equals(order.getExpression().toUrl())) continue;
                ++pkCount;
            }
        }
        if (pkCount < this.primaryKey.getKeyProperties().size()) {
            for (EntityPropertyMain keyProp : this.primaryKey.getKeyProperties()) {
                this.orderbyDefaults.add(new OrderBy(new Path(keyProp), OrderBy.OrderType.ASCENDING));
            }
        }
    }

    public EntityType addCreateValidator(String name, EntityValidator validator) {
        EntityValidator value = this.validatorsCreateEntity.put(name, validator);
        if (value != null) {
            LOGGER.warn("Replaced CreateValidator {} on {}", (Object)name, (Object)this.entityName);
        }
        return this;
    }

    public Map<String, EntityValidator> getCreateValidators() {
        return Collections.unmodifiableMap(this.validatorsCreateEntity);
    }

    public EntityValidator removeCreateValidator(String name) {
        return this.validatorsCreateEntity.remove(name);
    }

    public EntityType addUpdateValidator(String name, EntityValidator validator) {
        EntityValidator value = this.validatorsUpdateEntity.put(name, validator);
        if (value != null) {
            LOGGER.warn("Replaced UpdateValidator {} on {}", (Object)name, (Object)this.entityName);
        }
        return this;
    }

    public Map<String, EntityValidator> getUpdateValidators() {
        return Collections.unmodifiableMap(this.validatorsUpdateEntity);
    }

    public EntityValidator removeUpdateValidator(String name) {
        return this.validatorsUpdateEntity.remove(name);
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public Property getProperty(String name) {
        return this.propertiesByName.get(name);
    }

    public EntityPropertyMain getEntityProperty(String name) {
        Property property = this.propertiesByName.get(name);
        if (property instanceof EntityPropertyMain) {
            EntityPropertyMain entityPropertyMain = (EntityPropertyMain)property;
            return entityPropertyMain;
        }
        return null;
    }

    public NavigationPropertyMain getNavigationProperty(String name) {
        Property property = this.propertiesByName.get(name);
        if (property instanceof NavigationPropertyMain) {
            NavigationPropertyMain navigationPropertyMain = (NavigationPropertyMain)property;
            return navigationPropertyMain;
        }
        return null;
    }

    public NavigationPropertyMain.NavigationPropertyEntity getNavigationPropertyEntity(String name) {
        Property property = this.propertiesByName.get(name);
        if (property instanceof NavigationPropertyMain.NavigationPropertyEntity) {
            NavigationPropertyMain.NavigationPropertyEntity npe = (NavigationPropertyMain.NavigationPropertyEntity)property;
            return npe;
        }
        return null;
    }

    public NavigationPropertyMain.NavigationPropertyEntitySet getNavigationPropertyEntitySet(String name) {
        Property property = this.propertiesByName.get(name);
        if (property instanceof NavigationPropertyMain.NavigationPropertyEntitySet) {
            NavigationPropertyMain.NavigationPropertyEntitySet npes = (NavigationPropertyMain.NavigationPropertyEntitySet)property;
            return npes;
        }
        return null;
    }

    public Set<Property> getPropertySet() {
        return this.properties;
    }

    public Set<EntityPropertyMain> getEntityProperties() {
        return this.entityProperties;
    }

    public Set<NavigationPropertyMain> getNavigationProperties() {
        return this.navigationProperties;
    }

    public Set<NavigationPropertyMain<Entity>> getNavigationEntities() {
        return this.navigationEntities;
    }

    public Set<NavigationPropertyMain<EntitySet>> getNavigationSets() {
        return this.navigationSets;
    }

    public void validateCreate(Entity entity) throws IncompleteEntityException {
        for (Property property : this.getPropertySet()) {
            if (entity.isSetProperty(property)) {
                if (property.isReadOnly()) {
                    entity.unsetProperty(property);
                    continue;
                }
                if (property.isNullable() || entity.getProperty(property) != null) continue;
                throw new IncompleteEntityException("Property '" + property.getJsonName() + "' must be non-NULL.");
            }
            if (!property.isRequired()) continue;
            throw new IncompleteEntityException("Missing required property '" + property.getJsonName() + "'");
        }
        for (EntityValidator validator : this.validatorsCreateEntity.values()) {
            validator.validate(entity);
        }
    }

    public void validateUpdate(Entity entity) throws IncompleteEntityException {
        for (Property property : this.getPropertySet()) {
            if (!(property instanceof EntityPropertyMain) || !entity.isSetProperty(property)) continue;
            if (property.isReadOnly()) {
                entity.unsetProperty(property);
                continue;
            }
            if (property.isNullable() || entity.getProperty(property) != null) continue;
            throw new IncompleteEntityException("Property '" + property.getJsonName() + "' must be non-NULL.");
        }
        for (EntityValidator validator : this.validatorsUpdateEntity.values()) {
            validator.validate(entity);
        }
    }

    public void setParent(PathElementEntitySet containingSet, Entity entity) throws IncompleteEntityException {
        EntityType setType = containingSet.getEntityType();
        if (setType != entity.getEntityType()) {
            throw new IllegalArgumentException("Set of type " + setType + " can not contain a " + entity.getEntityType());
        }
        PathElementEntity parent = containingSet.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("Set does not have a parent entity!");
        }
        if (parent instanceof PathElementEntity) {
            PathElementEntity parentEntity = parent;
            if (!parentEntity.primaryKeyFullySet()) {
                return;
            }
            PkValue parentKeyValues = parentEntity.getPkValues();
            this.setParent(entity, (NavigationPropertyMain)containingSet.getNavigationProperty().getInverse(), parentKeyValues);
        }
    }

    private void setParent(Entity entity, NavigationPropertyMain navPropToParent, PkValue parentPkValues) throws IncompleteEntityException {
        if (navPropToParent == null) {
            LOGGER.error("Incorrect 'parent' entity type for {}: {}", (Object)this.entityName, (Object)navPropToParent);
            throw new IncompleteEntityException("Incorrect 'parent' entity type for " + this.entityName + ": " + navPropToParent);
        }
        EntityType parentType = navPropToParent.getEntityType();
        if (navPropToParent instanceof NavigationPropertyMain.NavigationPropertyEntitySet) {
            NavigationPropertyMain.NavigationPropertyEntitySet navPropToParentSet = (NavigationPropertyMain.NavigationPropertyEntitySet)navPropToParent;
            entity.addNavigationEntity(navPropToParentSet, new DefaultEntity(parentType).setPrimaryKeyValues(parentPkValues));
        } else if (navPropToParent instanceof NavigationPropertyMain.NavigationPropertyEntity) {
            NavigationPropertyMain.NavigationPropertyEntity navPropToParentEntity = (NavigationPropertyMain.NavigationPropertyEntity)navPropToParent;
            Entity parent = entity.getProperty(navPropToParentEntity);
            if (parent != null && !Objects.equals(parentPkValues, parent.getPrimaryKeyValues())) {
                throw new IllegalArgumentException("Navigation property " + navPropToParent.getName() + " set in both JSON and URL.");
            }
            entity.setProperty(navPropToParent, new DefaultEntity(parentType).setPrimaryKeyValues(parentPkValues));
        } else {
            throw new IllegalStateException("Unknown navigation property type: " + navPropToParent);
        }
    }

    public ModelRegistry getModelRegistry() {
        return this.modelRegistry;
    }

    public void setModelRegistry(ModelRegistry modelRegistry) {
        if (this.modelRegistry != null && this.modelRegistry != modelRegistry) {
            throw new IllegalArgumentException("Changing the ModelRegistry on an EntityType is not allowed.");
        }
        this.modelRegistry = modelRegistry;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public EntityType addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
        return this;
    }

    public EntityType addAnnotations(List<Annotation> annotationsToAdd) {
        this.annotations.addAll(annotationsToAdd);
        return this;
    }

    public Object getIdGenerationMode() {
        return this.idGenerationMode;
    }

    public void setIdGenerationMode(Object idGenerationMode) {
        this.idGenerationMode = idGenerationMode;
    }

    public String toString() {
        return this.entityName;
    }

    @Override
    public int compareTo(EntityType o) {
        return this.entityName.compareTo(o.entityName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EntityType)) {
            return false;
        }
        EntityType other = (EntityType)obj;
        if (this.entityName.equals(other.entityName)) {
            LOGGER.error("Found other instance of {}", (Object)this.entityName);
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.entityName);
        return hash;
    }

    public PkValue parsePrimaryKey(String input) {
        PrimaryKey primaryKey = this.primaryKey;
        if (primaryKey instanceof PkSingle) {
            PkSingle pks = (PkSingle)primaryKey;
            EntityPropertyMain keyProp = pks.getKeyProperties().get(0);
            return new PkValue(1).set(0, keyProp.getType().parseFromUrl(input));
        }
        throw new NotImplementedException("Multi-valued primary keys are not implemented yet.");
    }

    public List<OrderBy> getOrderbyDefaults() {
        return this.orderbyDefaults;
    }

    public EntityType addOrderByDefault(OrderBy order) {
        this.orderbyDefaults.add(order);
        return this;
    }

    public EntityType clearOrderByDefaults() {
        this.orderbyDefaults.clear();
        return this;
    }
}

