/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.json.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.type.PropertyType;
import de.fraunhofer.iosb.ilt.frostserver.query.Expand;
import de.fraunhofer.iosb.ilt.frostserver.query.Metadata;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitySerializer
extends JsonSerializer<Entity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntitySerializer.class.getName());
    private final String countField;
    private final String navLinkField;
    private final String nextLinkField;
    private final boolean odata;
    private final Map<EntityPropertyMain, SimplePropertySerializer> propertySerializers = new HashMap<EntityPropertyMain, SimplePropertySerializer>();
    private final Map<PropertyType, SimplePropertySerializer> propertyTypeSerializers = new HashMap<PropertyType, SimplePropertySerializer>();

    public EntitySerializer() {
        this(false, "@iot.count", "@iot.navigationLink", "@iot.nextLink", "@iot.selfLink");
    }

    public EntitySerializer(boolean odata, String countField, String navLinkField, String nextLinkField, String selfLinkField) {
        this.countField = countField;
        this.navLinkField = navLinkField;
        this.nextLinkField = nextLinkField;
        this.odata = odata;
        this.propertySerializers.put(ModelRegistry.EP_SELFLINK, (ep, entity, gen) -> {
            String value;
            if (entity.getQuery().getMetadata() == Metadata.FULL && (value = entity.getSelfLink()) != null) {
                gen.writeStringField(selfLinkField, value);
            }
        });
    }

    @Override
    public void serialize(Entity entity, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        try {
            this.writeContent(entity, gen);
        }
        catch (IOException | RuntimeException exc) {
            LOGGER.error("Failed to serialise entity.", exc);
            throw new IOException("could not serialize Entity");
        }
        finally {
            gen.writeEndObject();
        }
    }

    public void writeContent(Entity entity, JsonGenerator gen) throws IOException {
        Query query = entity.getQuery();
        if (query == null) {
            LOGGER.error("Received entity without Query: {}", (Object)entity);
            throw new IllegalArgumentException("Entity without query.");
        }
        Metadata metadata = query.getMetadata();
        Set<NavigationPropertyMain> navigationProps = switch (metadata) {
            case Metadata.OFF, Metadata.NONE, Metadata.MINIMAL -> Collections.emptySet();
            case Metadata.INTERNAL_COMPARE -> query.getSelectNavProperties(query.hasParentExpand());
            default -> query.getSelectNavProperties(query.hasParentExpand());
        };
        Set<EntityPropertyMain> entityProps = query.getSelectMainEntityProperties(query.hasParentExpand());
        List<Expand> expand = query.getExpand();
        for (EntityPropertyMain ep : entityProps) {
            this.writeProperty(ep, entity, gen);
        }
        if (expand != null) {
            this.writeExpand(expand, entity, gen);
        }
        for (NavigationPropertyMain np : navigationProps) {
            String navigationLink = np.getNavigationLink(entity);
            if (!(navigationLink == null || !np.isEntitySet() && entity.getProperty(np) == null || np.isAdminOnly() && !query.getPrincipal().isAdmin())) {
                gen.writeStringField(np.getName() + this.navLinkField, navigationLink);
            }
            if (metadata != Metadata.INTERNAL_COMPARE) continue;
            this.writeExpand(null, entity, np, gen);
        }
    }

    public void writeProperty(EntityPropertyMain<?> ep, Entity entity, JsonGenerator gen) throws IOException {
        SimplePropertySerializer ser = this.propertySerializers.get(ep);
        if (ser != null) {
            ser.writeProperty(ep, entity, gen);
            return;
        }
        ser = this.propertyTypeSerializers.get(ep.getType());
        if (ser != null) {
            ser.writeProperty(ep, entity, gen);
            return;
        }
        Object value = entity.getProperty(ep);
        if (value != null || ep.serialiseNull) {
            String name = ep.getName();
            Collection<String> aliases = ep.getAliases();
            if (aliases.size() > 1) {
                if (this.odata) {
                    for (String alias : aliases) {
                        if (alias.startsWith("@")) continue;
                        gen.writeObjectField(alias, value);
                        return;
                    }
                } else {
                    for (String alias : aliases) {
                        if (!alias.startsWith("@")) continue;
                        gen.writeObjectField(alias, value);
                        return;
                    }
                }
            }
            gen.writeObjectField(name, value);
        }
    }

    private void writeExpand(List<Expand> expand, Entity entity, JsonGenerator gen) throws IOException {
        boolean adminUser = entity.getQuery().getPrincipal().isAdmin();
        for (Expand exp : expand) {
            NavigationProperty np = exp.getPath();
            if (!adminUser && np.isAdminOnly() || !(np instanceof NavigationPropertyMain)) continue;
            NavigationPropertyMain npm = (NavigationPropertyMain)np;
            this.writeExpand(exp, entity, npm, gen);
        }
    }

    private void writeExpand(Expand exp, Entity entity, NavigationPropertyMain np, JsonGenerator gen) throws IOException {
        Object entityOrSet = np.getFrom(entity);
        if (np.isEntitySet()) {
            EntitySet entitySet = (EntitySet)entityOrSet;
            this.writeEntitySet(np, entitySet, gen, exp.getSubQuery());
        } else {
            Entity expandedEntity = (Entity)entityOrSet;
            if (expandedEntity != null) {
                if (expandedEntity.getQuery() == null && exp != null) {
                    expandedEntity.setQuery(exp.getSubQuery());
                }
                gen.writeObjectField(np.getJsonName(), entityOrSet);
            }
        }
    }

    private void writeEntitySet(NavigationProperty np, EntitySet entitySet, JsonGenerator gen, Query query) throws IOException {
        String nextLink;
        String jsonName = np.getJsonName();
        if (entitySet == null) {
            gen.writeArrayFieldStart(jsonName);
            gen.writeEndArray();
            return;
        }
        long count = entitySet.getCount();
        if (count >= 0L) {
            gen.writeNumberField(jsonName + this.countField, count);
        }
        gen.writeArrayFieldStart(jsonName);
        for (Object child : entitySet) {
            gen.writeObject(child);
        }
        gen.writeEndArray();
        if (query.getMetadata() != Metadata.OFF && (nextLink = entitySet.getNextLink()) != null) {
            gen.writeStringField(jsonName + this.nextLinkField, nextLink);
        }
    }

    public <P> EntitySerializer addPropertySerializer(EntityPropertyMain<P> property, SimplePropertySerializer serializer) {
        this.propertySerializers.put(property, serializer);
        return this;
    }

    public EntitySerializer addPropertyTypeSerializer(PropertyType propertyType, SimplePropertySerializer serializer) {
        this.propertyTypeSerializers.put(propertyType, serializer);
        return this;
    }

    public static interface SimplePropertySerializer {
        public void writeProperty(EntityPropertyMain var1, Entity var2, JsonGenerator var3) throws IOException;
    }
}

