/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.json.deserialize.custom;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import de.fraunhofer.iosb.ilt.frostserver.model.DefaultEntity;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySetImpl;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomEntityDeserializer
extends JsonDeserializer<Entity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomEntityDeserializer.class.getName());
    private static final String BUT_FOUND = " but found: ";
    private static final Map<ModelRegistry, Map<EntityType, CustomEntityDeserializer>> instancePerModelAndType = new HashMap<ModelRegistry, Map<EntityType, CustomEntityDeserializer>>();
    private final EntityType entityType;
    private final ModelRegistry modelRegistry;

    public static CustomEntityDeserializer getInstance(ModelRegistry modelRegistry, EntityType entityType) {
        return instancePerModelAndType.computeIfAbsent(modelRegistry, t2 -> new HashMap()).computeIfAbsent(entityType, t2 -> new CustomEntityDeserializer(modelRegistry, (EntityType)t2));
    }

    public CustomEntityDeserializer(ModelRegistry modelRegistry, EntityType entityType) {
        this.modelRegistry = modelRegistry;
        this.entityType = entityType;
    }

    public Entity deserializeFull(JsonParser parser, DeserializationContext ctxt) throws IOException {
        parser.nextToken();
        Entity result = this.deserialize(parser, ctxt);
        parser.nextToken();
        return result;
    }

    @Override
    public Entity deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        DefaultEntity target = new DefaultEntity(this.entityType);
        boolean failOnUnknown = ctxt.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        JsonToken currentToken = parser.nextToken();
        while (currentToken == JsonToken.FIELD_NAME) {
            String fieldName = parser.getCurrentName();
            Property property = this.entityType.getProperty(fieldName);
            if (property == null) {
                if (failOnUnknown) {
                    String message = "Unknown field: " + fieldName + " on " + this.entityType.entityName + " expected one of: " + this.entityType.getPropertySet();
                    throw new UnrecognizedPropertyException(parser, message, parser.getCurrentLocation(), DefaultEntity.class, fieldName, null);
                }
                parser.nextValue();
                parser.readValueAsTree();
            } else {
                this.deserializeProperty(parser, ctxt, property, target);
            }
            currentToken = parser.nextToken();
        }
        return target;
    }

    private void deserializeProperty(JsonParser parser, DeserializationContext ctxt, Property property, Entity target) throws IOException {
        if (property instanceof EntityPropertyMain) {
            EntityPropertyMain epm = (EntityPropertyMain)property;
            this.deserializeEntityProperty(parser, ctxt, epm, target);
        } else if (property instanceof NavigationPropertyMain.NavigationPropertyEntity) {
            NavigationPropertyMain.NavigationPropertyEntity npe = (NavigationPropertyMain.NavigationPropertyEntity)property;
            this.deserializeNavigationProperty(parser, ctxt, npe, target);
        } else if (property instanceof NavigationPropertyMain.NavigationPropertyEntitySet) {
            NavigationPropertyMain.NavigationPropertyEntitySet npes = (NavigationPropertyMain.NavigationPropertyEntitySet)property;
            this.deserializeNavigationProperty(parser, ctxt, npes, target);
        }
    }

    private void deserializeNavigationProperty(JsonParser parser, DeserializationContext ctxt, NavigationPropertyMain.NavigationPropertyEntitySet npes, Entity result) throws IOException {
        EntityType setType = npes.getEntityType();
        EntitySetImpl entitySet = new EntitySetImpl(npes);
        CustomEntityDeserializer setEntityDeser = CustomEntityDeserializer.getInstance(this.modelRegistry, setType);
        result.setProperty(npes, entitySet);
        JsonToken curToken = parser.nextToken();
        if (curToken != JsonToken.START_ARRAY) {
            String message = "Expected start of array for: " + npes.getName() + " on " + this.entityType.entityName + BUT_FOUND + curToken;
            throw MismatchedInputException.from(parser, DefaultEntity.class, message);
        }
        curToken = parser.nextToken();
        if (curToken != JsonToken.START_OBJECT && curToken != JsonToken.END_ARRAY) {
            String message = "Expected object in array for: " + npes.getName() + " on " + this.entityType.entityName + BUT_FOUND + curToken;
            throw MismatchedInputException.from(parser, DefaultEntity.class, message);
        }
        while (curToken != null && curToken != JsonToken.END_ARRAY) {
            entitySet.add(setEntityDeser.deserialize(parser, ctxt));
            curToken = parser.nextToken();
        }
    }

    private void deserializeNavigationProperty(JsonParser parser, DeserializationContext ctxt, NavigationPropertyMain.NavigationPropertyEntity npe, Entity target) throws IOException {
        EntityType targetEntityType = npe.getEntityType();
        JsonToken nextToken = parser.nextToken();
        if (nextToken != JsonToken.START_OBJECT) {
            String message = "Expected start of object for: " + npe.getName() + " on " + this.entityType.entityName + BUT_FOUND + nextToken;
            throw MismatchedInputException.from(parser, DefaultEntity.class, message);
        }
        Entity value = CustomEntityDeserializer.getInstance(this.modelRegistry, targetEntityType).deserialize(parser, ctxt);
        ((NavigationPropertyMain)npe).setOn(target, value);
    }

    private void deserializeEntityProperty(JsonParser parser, DeserializationContext ctxt, EntityPropertyMain epm, Entity target) throws IOException {
        parser.nextValue();
        JsonDeserializer deserializer = epm.getType().getDeserializer();
        if (deserializer == null) {
            LOGGER.error("Missing deserialiser for {}/{}", (Object)this.entityType, (Object)epm);
            return;
        }
        Object value = deserializer.deserialize(parser, ctxt);
        epm.setOn(target, value);
    }
}

