/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.formatter;

import de.fraunhofer.iosb.ilt.frostserver.formatter.FormatWriter;
import de.fraunhofer.iosb.ilt.frostserver.formatter.ResultFormatter;
import de.fraunhofer.iosb.ilt.frostserver.json.serialize.JsonWriter;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import java.util.Map;
import java.util.Objects;
import org.geojson.GeoJsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultFormatterDefault
implements ResultFormatter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultFormatterDefault.class);

    public ResultFormatterDefault() {
        LOGGER.trace("Creating a new resultFormatter.");
    }

    @Override
    public FormatWriter format(ResourcePath path, Query query, Object result, boolean useAbsoluteNavigationLinks) {
        if (result instanceof Entity) {
            Entity entity = (Entity)result;
            LOGGER.trace("Formatting as Entity.");
            return target -> JsonWriter.writeEntity(target, entity);
        }
        if (result instanceof EntitySet) {
            EntitySet entitySet = (EntitySet)result;
            LOGGER.trace("Formatting as EntitySet.");
            return target -> JsonWriter.writeEntityCollection(target, entitySet, query);
        }
        if (path != null && path.isValue()) {
            LOGGER.trace("Formatting as $Value.");
            if (result instanceof Map || result instanceof GeoJsonObject) {
                return target -> JsonWriter.writeObject(target, result);
            }
            return target -> target.append(Objects.toString(result));
        }
        LOGGER.trace("Formatting as Object.");
        return target -> JsonWriter.writeObject(target, result);
    }

    @Override
    public String getContentType() {
        return "application/json";
    }
}

