/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor.swing;

import de.fraunhofer.iosb.ilt.configurable.GuiFactorySwing;
import de.fraunhofer.iosb.ilt.configurable.editor.AbstractEditorMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.MutableComboBoxModel;
import javax.swing.border.EtchedBorder;

public final class FactoryMapSwing
implements GuiFactorySwing {
    private final AbstractEditorMap<?, ?> parentEditor;
    private JPanel swComponent;
    private JPanel swListHolder;
    private JComboBox<AbstractEditorMap.Item> swNames;
    private MutableComboBoxModel<AbstractEditorMap.Item> swModel;
    private JPanel controls;

    public FactoryMapSwing(AbstractEditorMap<?, ?> parentEditor) {
        this.parentEditor = parentEditor;
    }

    @Override
    public JComponent getComponent() {
        if (this.swComponent == null) {
            this.createComponent();
        }
        return this.swComponent;
    }

    private void createComponent() {
        this.controls = new JPanel(new FlowLayout(2));
        if (!this.parentEditor.getOptionalOptions().isEmpty()) {
            this.controls.add(new JLabel("Options:"));
            ArrayList optionals = new ArrayList();
            for (String optionName : this.parentEditor.getOptionalOptions()) {
                if (this.parentEditor.getRawValue().contains(optionName)) continue;
                optionals.add(this.parentEditor.getOptions().get(optionName));
            }
            optionals.sort((o1, o2) -> o1.label.compareTo(o2.label));
            this.swModel = new DefaultComboBoxModel<AbstractEditorMap.Item>(optionals.toArray(new AbstractEditorMap.Item[optionals.size()]));
            this.swNames = new JComboBox<AbstractEditorMap.Item>(this.swModel);
            this.controls.add(this.swNames);
            JButton addButton = new JButton("+");
            addButton.addActionListener(event -> this.addItem());
            this.controls.add(addButton);
        }
        this.swListHolder = new JPanel(new GridBagLayout());
        this.swComponent = new JPanel(new BorderLayout());
        this.swComponent.setBorder(new EtchedBorder());
        this.swComponent.add((Component)this.controls, "North");
        this.swComponent.add((Component)this.swListHolder, "Center");
        this.fillComponent();
    }

    public void fillComponent() {
        boolean canEdit = this.parentEditor.canEdit();
        this.controls.setVisible(canEdit);
        this.swListHolder.removeAll();
        int row = 0;
        int endCol = -1;
        String profile = this.parentEditor.getProfile();
        while (this.swModel != null && this.swModel.getSize() > 0) {
            this.swModel.removeElementAt(0);
        }
        for (Map.Entry<String, AbstractEditorMap.Item<?>> entry : this.parentEditor.getOptions().entrySet()) {
            String key = entry.getKey();
            AbstractEditorMap.Item<?> item = entry.getValue();
            if (canEdit && !this.parentEditor.getRawValue().contains(key)) {
                if (!item.hasGuiProfile(profile) || this.swModel == null) continue;
                this.swModel.addElement(item);
                continue;
            }
            if (!item.hasGuiProfile(profile) || !item.editor.canEdit() && item.editor.isDefault()) continue;
            if (!canEdit && !this.parentEditor.getRawValue().contains(key)) {
                this.parentEditor.getRawValue().add(key);
            }
            if ((endCol += item.colwidth) >= this.parentEditor.getColumns()) {
                endCol = item.colwidth - 1;
                ++row;
            }
            int startCol = endCol - item.colwidth + 1;
            int width = 3 * item.colwidth - 2;
            int x0 = startCol * 3;
            int x1 = x0 + 1;
            int x2 = x0 + width + 1;
            String label = item.editor.getLabel();
            if (label.isEmpty()) {
                label = key;
            }
            this.addToGridSw(row, x0, label, x1, item, width, x2, key);
        }
        this.swListHolder.invalidate();
        this.swComponent.revalidate();
        this.swComponent.repaint();
    }

    private void addToGridSw(int row, int x0, String label, int x1, AbstractEditorMap.Item<?> item, int width, int x2, String key) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x0;
        gbc.gridy = row;
        gbc.weightx = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 3, 1, 1);
        JLabel jLabel = new JLabel(label);
        jLabel.setToolTipText(item.editor.getDescription());
        this.swListHolder.add((Component)jLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = x2;
        gbc.gridy = row;
        gbc.gridwidth = width;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.swListHolder.add((Component)item.editor.getGuiFactorySwing().getComponent(), gbc);
        if (!this.parentEditor.getOptionalOptions().isEmpty()) {
            JButton removeButton = new JButton("\u274c");
            removeButton.setMargin(new Insets(1, 1, 1, 1));
            removeButton.setEnabled(item.optional && this.parentEditor.canEdit());
            removeButton.addActionListener(event -> this.parentEditor.removeItem(key));
            gbc = new GridBagConstraints();
            gbc.anchor = 11;
            gbc.gridx = x1;
            gbc.gridy = row;
            this.swListHolder.add((Component)removeButton, gbc);
        }
    }

    private void addItem() {
        int idx = this.swNames.getSelectedIndex();
        if (idx >= 0) {
            String key = ((AbstractEditorMap.Item)this.swNames.getModel().getElementAt(idx)).getName();
            this.parentEditor.addItem(key);
        }
    }

    public void addItem(String key) {
        if (this.swModel != null) {
            this.swModel.removeElement(this.parentEditor.getOptions().get(key));
        }
        this.fillComponent();
    }

    public void removeItem(AbstractEditorMap.Item<?> item) {
        if (item.optional) {
            if (this.swModel != null) {
                this.swModel.addElement(item);
            }
            this.fillComponent();
        }
    }
}

