/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor.swing;

import de.fraunhofer.iosb.ilt.configurable.GuiFactorySwing;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorLong;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FactoryLongSwing
implements GuiFactorySwing {
    private static final Logger LOGGER = LoggerFactory.getLogger(FactoryLongSwing.class.getName());
    private final EditorLong parentEditor;
    private JTextField swComponent;

    public FactoryLongSwing(EditorLong parentEditor) {
        this.parentEditor = parentEditor;
    }

    @Override
    public JComponent getComponent() {
        if (this.swComponent == null) {
            this.createComponent();
        }
        return this.swComponent;
    }

    private void createComponent() {
        this.swComponent = new JTextField();
        this.swComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FactoryLongSwing.this.readComponent();
            }
        });
        this.fillComponent();
    }

    private long getRawValue() {
        Long rawValue = this.parentEditor.getRawValue();
        long min2 = this.parentEditor.getMin();
        long max = this.parentEditor.getMax();
        if (rawValue == null) {
            rawValue = 0L;
            this.parentEditor.setRawValue(rawValue);
        }
        if (rawValue < min2 || rawValue > max) {
            rawValue = Math.max(min2, Math.min(rawValue, max));
            this.parentEditor.setRawValue(rawValue);
        }
        return rawValue;
    }

    public void fillComponent() {
        this.swComponent.setText("" + this.getRawValue());
    }

    public void readComponent() {
        if (this.swComponent != null) {
            try {
                this.parentEditor.setRawValue(Long.parseLong(this.swComponent.getText()));
            }
            catch (NumberFormatException exc) {
                LOGGER.error("Failed to parse text to number: " + this.swComponent.getText());
            }
            this.fillComponent();
        }
    }
}

