/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor.swing;

import de.fraunhofer.iosb.ilt.configurable.GuiFactorySwing;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorInt;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public final class FactoryIntSwing
implements GuiFactorySwing {
    private final EditorInt parentEditor;
    private SpinnerNumberModel swModel;
    private JSpinner swComponent;
    private int min = 0;

    public FactoryIntSwing(EditorInt parentEditor) {
        this.parentEditor = parentEditor;
    }

    @Override
    public JComponent getComponent() {
        if (this.swComponent == null) {
            this.createComponent();
        }
        return this.swComponent;
    }

    private void createComponent() {
        this.min = this.parentEditor.getMin();
        int value = this.getRawValue();
        this.swModel = new SpinnerNumberModel(value, this.min, this.parentEditor.getMax(), this.parentEditor.getStep());
        this.swComponent = new JSpinner(this.swModel);
        this.fillComponent();
    }

    private int getRawValue() {
        Integer rawValue = this.parentEditor.getRawValue();
        if (rawValue == null) {
            return Math.max(0, this.min);
        }
        return rawValue;
    }

    public void fillComponent() {
        Integer rawValue = this.getRawValue();
        this.swComponent.setValue(rawValue);
    }

    public void readComponent() {
        if (this.swComponent != null) {
            this.parentEditor.setRawValue(this.swModel.getNumber().intValue());
        }
    }
}

