/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor.fx;

import de.fraunhofer.iosb.ilt.configurable.GuiFactoryFx;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorBigDecimal;
import java.math.BigDecimal;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TextInputControl;
import javafx.util.converter.BigDecimalStringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FactoryBigDecimalFx
implements GuiFactoryFx {
    private static final Logger LOGGER = LoggerFactory.getLogger(FactoryBigDecimalFx.class.getName());
    private final EditorBigDecimal parentEditor;
    private TextInputControl fxNode;

    public FactoryBigDecimalFx(EditorBigDecimal parentEditor) {
        this.parentEditor = parentEditor;
    }

    @Override
    public Node getNode() {
        if (this.fxNode == null) {
            this.createComponent();
        }
        return this.fxNode;
    }

    private void createComponent() {
        BigDecimal rawValue = this.parentEditor.getRawValue();
        if (rawValue == null) {
            rawValue = BigDecimal.ZERO;
        }
        BigDecimal min2 = this.parentEditor.getMin();
        BigDecimal max = this.parentEditor.getMax();
        if (min2 != null && min2.compareTo(rawValue) > 0) {
            this.parentEditor.setRawValue(min2);
        }
        if (max != null && max.compareTo(rawValue) < 0) {
            this.parentEditor.setRawValue(min2);
        }
        this.fxNode = new TextField();
        this.fxNode.setTextFormatter(new TextFormatter<BigDecimal>(new BigDecimalStringConverter()));
        this.fillComponent();
    }

    public void fillComponent() {
        BigDecimal rawValue = this.parentEditor.getRawValue();
        if (rawValue == null) {
            rawValue = BigDecimal.ZERO;
        }
        this.fxNode.setText("" + rawValue);
    }

    public void readComponent() {
        if (this.fxNode != null) {
            try {
                this.parentEditor.setRawValue(new BigDecimal(this.fxNode.getText()));
            }
            catch (NumberFormatException exc) {
                LOGGER.error("Failed to parse text to number: " + this.fxNode.getText());
            }
        }
    }
}

