/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import de.fraunhofer.iosb.ilt.configurable.ConfigEditor;
import de.fraunhofer.iosb.ilt.configurable.ConfigurationException;
import de.fraunhofer.iosb.ilt.configurable.EditorFactory;
import de.fraunhofer.iosb.ilt.configurable.GuiFactoryFx;
import de.fraunhofer.iosb.ilt.configurable.GuiFactorySwing;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.ItemArray;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.RootSchema;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.SchemaItem;
import de.fraunhofer.iosb.ilt.configurable.Utils;
import de.fraunhofer.iosb.ilt.configurable.annotations.AnnotationHelper;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorDefault;
import de.fraunhofer.iosb.ilt.configurable.editor.fx.FactoryListFx;
import de.fraunhofer.iosb.ilt.configurable.editor.swing.FactoryListSwing;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class EditorList<U, T extends ConfigEditor<U>>
extends EditorDefault<List<U>>
implements Iterable<T> {
    private Object context;
    private Object edtCtx;
    private EditorFactory<T> factory;
    private final List<T> value = new ArrayList<T>();
    private int minCount = 0;
    private int maxCount = Integer.MAX_VALUE;
    private boolean horizontal = false;
    private String labelText = "";
    public Set<String> profilesEdit = AnnotationHelper.csvToReadOnlySet("");
    private String profile = "default";
    private FactoryListSwing factorySwing;
    private FactoryListFx factoryFx;

    public EditorList() {
    }

    public EditorList(EditorFactory<T> factory) {
        this.factory = factory;
    }

    public EditorList(EditorFactory<T> factory, String label, String description) {
        this.factory = factory;
        this.setLabel(label);
        this.setDescription(description);
    }

    public final void setContexts(Object context, Object edtCtx) {
        this.context = context;
        this.edtCtx = edtCtx;
    }

    @Override
    public void initFor(Field field) {
        this.initFor(field, "list-1");
    }

    @Override
    public void initFor(Field field, String key) {
        EdOptsList[] annotations = (EdOptsList[])field.getAnnotationsByType(EdOptsList.class);
        EdOptsList annotation = null;
        for (EdOptsList a : annotations) {
            if (!a.myKey().equalsIgnoreCase(key)) continue;
            annotation = a;
            break;
        }
        if (annotation == null) {
            throw new IllegalArgumentException("Field must have an EdListOpts annotation to use this editor: " + field.getName());
        }
        this.minCount = annotation.minCount();
        this.maxCount = annotation.maxCount();
        this.horizontal = annotation.horizontal();
        this.labelText = annotation.labelText();
        this.profilesEdit = AnnotationHelper.csvToReadOnlySet(annotation.profilesEdit());
        String editorKey = annotation.editorKey();
        Class<? extends ConfigEditor> editorClass = annotation.editor();
        this.factory = () -> {
            try {
                Object editor = AnnotationHelper.createEditor(editorClass, field, this.context, this.edtCtx, editorKey);
                return editor;
            }
            catch (ReflectiveOperationException ex) {
                throw new IllegalArgumentException("Can not create new editor.", ex);
            }
        };
    }

    @Override
    public void setConfig(JsonElement config) {
        this.value.clear();
        if (config != null && config.isJsonArray()) {
            JsonArray asArray = config.getAsJsonArray();
            for (JsonElement subConf : asArray) {
                if (this.value.size() >= this.maxCount) break;
                T item = this.factory.createEditor();
                item.setConfig(subConf);
                item.setProfile(this.profile);
                this.value.add(item);
            }
        }
        this.fillComponent();
    }

    @Override
    public JsonElement getConfig() {
        JsonArray result = new JsonArray();
        for (ConfigEditor item : this.value) {
            result.add(item.getConfig());
        }
        return result;
    }

    @Override
    public SchemaItem getJsonSchema(RootSchema rootSchema) {
        ItemArray item;
        SchemaItem retval = item = (ItemArray)((ItemArray)new ItemArray().setMinItems(this.minCount).setMaxItems(this.maxCount).setTitle(this.getLabel())).setDescription(this.getDescription());
        if (rootSchema == null) {
            rootSchema = new RootSchema(item);
            retval = rootSchema;
        }
        item.setItems(this.factory.createEditor().getJsonSchema(rootSchema));
        return retval;
    }

    @Override
    public GuiFactorySwing getGuiFactorySwing() {
        if (this.factoryFx != null) {
            throw new IllegalArgumentException("Can not mix different types of editors.");
        }
        if (this.factorySwing == null) {
            this.factorySwing = new FactoryListSwing(this, !this.horizontal);
            if (!Utils.isNullOrEmpty(this.labelText)) {
                this.factorySwing.setText(this.labelText);
            }
        }
        this.fillComponent();
        return this.factorySwing;
    }

    @Override
    public GuiFactoryFx getGuiFactoryFx() {
        if (this.factorySwing != null) {
            throw new IllegalArgumentException("Can not mix different types of editors.");
        }
        if (this.factoryFx == null) {
            this.factoryFx = new FactoryListFx(this, !this.horizontal);
            if (!Utils.isNullOrEmpty(this.labelText)) {
                this.factoryFx.setText(this.labelText);
            }
        }
        this.fillComponent();
        return this.factoryFx;
    }

    private void fillComponent() {
        while (this.value.size() < this.minCount) {
            T item = this.factory.createEditor();
            item.setProfile(this.profile);
            this.value.add(item);
        }
        if (this.factorySwing != null) {
            this.factorySwing.fillComponent();
        }
        if (this.factoryFx != null) {
            this.factoryFx.fillComponent();
        }
    }

    public void addItem() {
        if (this.value.size() >= this.maxCount) {
            return;
        }
        T item = this.factory.createEditor();
        item.setProfile(this.profile);
        this.value.add(item);
        this.fillComponent();
    }

    public void removeItem(T item) {
        if (this.value.size() > this.minCount) {
            this.value.remove(item);
        }
        this.fillComponent();
    }

    public void upItem(int idx) {
        if (idx == 0 || idx >= this.value.size()) {
            return;
        }
        ConfigEditor item = (ConfigEditor)this.value.remove(idx);
        this.value.add(idx - 1, item);
        this.fillComponent();
    }

    @Override
    public Iterator<T> iterator() {
        return this.value.iterator();
    }

    public List<T> getRawValue() {
        return this.value;
    }

    @Override
    public List<U> getValue() throws ConfigurationException {
        ArrayList valList = new ArrayList();
        for (ConfigEditor val : this.value) {
            valList.add(val.getValue());
        }
        return valList;
    }

    @Override
    public void setValue(List<U> value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getMinCount() {
        return this.minCount;
    }

    public void setMinCount(int minCount) {
        this.minCount = minCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public void setProfilesEdit(String csv) {
        this.profilesEdit = AnnotationHelper.csvToReadOnlySet(csv);
    }

    @Override
    public void setProfile(String profile) {
        this.profile = profile.toLowerCase();
        for (ConfigEditor val : this.value) {
            val.setProfile(this.profile);
        }
    }

    @Override
    public boolean canEdit() {
        return this.profilesEdit.contains(this.profile) && this.minCount != this.maxCount;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    @Repeatable(value=EdOptsListList.class)
    public static @interface EdOptsList {
        public Class<? extends ConfigEditor> editor();

        public String editorKey() default "list-2";

        public String myKey() default "list-1";

        public int minCount() default 0;

        public int maxCount() default 0x7FFFFFFF;

        public boolean horizontal() default false;

        public String labelText() default "";

        public String profilesEdit() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface EdOptsListList {
        public EdOptsList[] value();
    }
}

