/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.fraunhofer.iosb.ilt.configurable.GuiFactoryFx;
import de.fraunhofer.iosb.ilt.configurable.GuiFactorySwing;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.ItemInteger;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.ItemObject;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.RootSchema;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.SchemaItem;
import de.fraunhofer.iosb.ilt.configurable.annotations.AnnotationHelper;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorDefault;
import de.fraunhofer.iosb.ilt.configurable.editor.fx.FactoryColorFx;
import de.fraunhofer.iosb.ilt.configurable.editor.swing.FactoryColorSwing;
import java.awt.Color;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Set;

public class EditorColor
extends EditorDefault<Color> {
    private Color dflt;
    private boolean editAlpla = true;
    private int red;
    private int green;
    private int blue;
    private int alpha = 255;
    public Set<String> profilesEdit = AnnotationHelper.csvToReadOnlySet("");
    private String profile = "default";
    private FactoryColorSwing factorySwing;
    private FactoryColorFx factoryFx;

    public EditorColor() {
        this.dflt = Color.BLACK;
        this.resetToDefault();
    }

    public EditorColor(Color dflt) {
        this.dflt = dflt;
        this.resetToDefault();
    }

    public EditorColor(Color deflt, boolean editAlpha) {
        this(deflt);
        this.editAlpla = editAlpha;
    }

    public EditorColor(Color deflt, boolean editAlpha, String label, String description) {
        this(deflt, editAlpha);
        this.setLabel(label);
        this.setDescription(description);
    }

    private void resetToDefault() {
        this.red = this.dflt.getRed();
        this.green = this.dflt.getGreen();
        this.blue = this.dflt.getBlue();
        this.alpha = this.dflt.getAlpha();
    }

    @Override
    public void initFor(Field field) {
        EdOptsColor annotation = field.getAnnotation(EdOptsColor.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Field must have an EdOptsColor annotation to use this editor: " + field.getName());
        }
        this.editAlpla = annotation.editAlpha();
        this.red = annotation.red();
        this.green = annotation.green();
        this.blue = annotation.blue();
        this.alpha = annotation.alpha();
        this.profilesEdit = AnnotationHelper.csvToReadOnlySet(annotation.profilesEdit());
    }

    private static int getInt(JsonObject confObj, int dflt, String ... names) {
        for (String name : names) {
            JsonElement element = confObj.get(name);
            if (element == null || !element.isJsonPrimitive()) continue;
            return element.getAsInt();
        }
        return dflt;
    }

    @Override
    public void setConfig(JsonElement config) {
        if (config == null) {
            this.resetToDefault();
        } else if (config.isJsonObject()) {
            JsonObject confObj = config.getAsJsonObject();
            this.red = EditorColor.getInt(confObj, this.red, "r", "red");
            this.green = EditorColor.getInt(confObj, this.green, "g", "green");
            this.blue = EditorColor.getInt(confObj, this.blue, "b", "blue");
            this.alpha = EditorColor.getInt(confObj, this.alpha, "a", "alpha");
        }
        this.fillComponent();
    }

    @Override
    public JsonElement getConfig() {
        this.readComponent();
        JsonObject config = new JsonObject();
        config.add("r", new JsonPrimitive(this.red));
        config.add("g", new JsonPrimitive(this.green));
        config.add("b", new JsonPrimitive(this.blue));
        if (this.editAlpla && this.alpha != 255) {
            config.add("a", new JsonPrimitive(this.alpha));
        }
        return config;
    }

    @Override
    public SchemaItem getJsonSchema(RootSchema rootSchema) {
        ItemObject myItem = new ItemObject().addProperty("red", false, ((ItemInteger)((ItemInteger)new ItemInteger().setMinimum(0L).setMaximum(255L).setDeflt(0L)).setTitle("Red")).setDescription("The red value")).addProperty("green", false, ((ItemInteger)((ItemInteger)new ItemInteger().setMinimum(0L).setMaximum(255L).setDeflt(0L)).setTitle("Green")).setDescription("The green value")).addProperty("blue", false, ((ItemInteger)((ItemInteger)new ItemInteger().setMinimum(0L).setMaximum(255L).setDeflt(0L)).setTitle("Blue")).setDescription("The blue value"));
        if (this.editAlpla) {
            myItem.addProperty("alpha", false, ((ItemInteger)((ItemInteger)new ItemInteger().setMinimum(0L).setMaximum(255L).setDeflt(255L)).setTitle("Alpha")).setDescription("The alpha value"));
        }
        if (rootSchema == null) {
            return new RootSchema(myItem);
        }
        return myItem;
    }

    @Override
    public GuiFactorySwing getGuiFactorySwing() {
        if (this.factoryFx != null) {
            throw new IllegalArgumentException("Can not mix different types of editors.");
        }
        if (this.factorySwing == null) {
            this.factorySwing = new FactoryColorSwing(this);
        }
        return this.factorySwing;
    }

    @Override
    public GuiFactoryFx getGuiFactoryFx() {
        if (this.factorySwing != null) {
            throw new IllegalArgumentException("Can not mix different types of editors.");
        }
        if (this.factoryFx == null) {
            this.factoryFx = new FactoryColorFx(this);
        }
        return this.factoryFx;
    }

    private void fillComponent() {
        if (this.factorySwing != null) {
            this.factorySwing.fillComponent();
        }
        if (this.factoryFx != null) {
            this.factoryFx.fillComponent();
        }
    }

    private void readComponent() {
        if (this.factorySwing != null) {
            this.factorySwing.readComponent();
        }
        if (this.factoryFx != null) {
            this.factoryFx.readComponent();
        }
    }

    public int getRed() {
        return this.red;
    }

    public void setRed(int red) {
        this.red = red;
    }

    public int getGreen() {
        return this.green;
    }

    public void setGreen(int green) {
        this.green = green;
    }

    public int getBlue() {
        return this.blue;
    }

    public void setBlue(int blue) {
        this.blue = blue;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public boolean isEditAlpla() {
        return this.editAlpla;
    }

    @Override
    public Color getValue() {
        this.readComponent();
        return new Color(this.red, this.green, this.blue, this.alpha);
    }

    @Override
    public void setValue(Color value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setProfile(String profile) {
        this.profile = profile;
        this.fillComponent();
    }

    public void setProfilesEdit(String csv) {
        this.profilesEdit = AnnotationHelper.csvToReadOnlySet(csv);
    }

    @Override
    public boolean canEdit() {
        return this.profilesEdit.contains(this.profile);
    }

    @Override
    public boolean isDefault() {
        this.readComponent();
        return this.dflt.getRed() == this.red && this.dflt.getGreen() == this.green && this.dflt.getBlue() == this.blue && this.dflt.getAlpha() == this.alpha;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface EdOptsColor {
        public int red() default 0;

        public int green() default 0;

        public int blue() default 0;

        public int alpha() default 255;

        public boolean editAlpha() default true;

        public String profilesEdit() default "";
    }
}

