/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import de.fraunhofer.iosb.ilt.configurable.GuiFactoryFx;
import de.fraunhofer.iosb.ilt.configurable.GuiFactorySwing;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.ItemBoolean;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.RootSchema;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.SchemaItem;
import de.fraunhofer.iosb.ilt.configurable.annotations.AnnotationHelper;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorDefault;
import de.fraunhofer.iosb.ilt.configurable.editor.fx.FactoryBooleanFx;
import de.fraunhofer.iosb.ilt.configurable.editor.swing.FactoryBooleanSwing;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EditorBoolean
extends EditorDefault<Boolean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditorBoolean.class.getName());
    private Boolean dflt;
    private Boolean value;
    public Set<String> profilesEdit = AnnotationHelper.csvToReadOnlySet("");
    private String profile = "default";
    private FactoryBooleanSwing factorySwing;
    private FactoryBooleanFx factoryFx;

    public EditorBoolean() {
    }

    public EditorBoolean(boolean deflt) {
        this.value = deflt;
        this.dflt = deflt;
    }

    public EditorBoolean(boolean deflt, String label, String description) {
        this.value = deflt;
        this.dflt = deflt;
        this.setLabel(label);
        this.setDescription(description);
    }

    @Override
    public void initFor(Field field) {
        EdOptsBool annotation = field.getAnnotation(EdOptsBool.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Field must have an EdOptsBool annotation to use this editor: " + field.getName());
        }
        boolean isPrimitive = field.getType().isPrimitive();
        boolean dfltIsNull = annotation.dfltIsNull();
        if (dfltIsNull) {
            if (isPrimitive) {
                LOGGER.error("Flag dfltIsNull set to true on a primitive field: {}", (Object)field);
                this.dflt = false;
            }
        } else {
            this.dflt = annotation.dflt();
        }
        this.value = this.dflt;
        this.profilesEdit = AnnotationHelper.csvToReadOnlySet(annotation.profilesEdit());
    }

    @Override
    public void setConfig(JsonElement config) {
        try {
            this.value = config == null ? this.dflt : Boolean.valueOf(config.getAsBoolean());
        }
        catch (ClassCastException | IllegalStateException e) {
            this.value = this.dflt;
            LOGGER.trace("", e);
            LOGGER.debug("Value is not a boolean: {}.", (Object)config.toString());
        }
        this.fillComponent();
    }

    @Override
    public SchemaItem getJsonSchema(RootSchema rootSchema) {
        ItemBoolean item = (ItemBoolean)((ItemBoolean)((ItemBoolean)new ItemBoolean().setDeflt(this.dflt)).setTitle(this.getLabel())).setDescription(this.getDescription());
        if (rootSchema == null) {
            return new RootSchema(item);
        }
        return item;
    }

    @Override
    public GuiFactorySwing getGuiFactorySwing() {
        if (this.factoryFx != null) {
            throw new IllegalArgumentException("Can not mix different types of editors.");
        }
        if (this.factorySwing == null) {
            this.factorySwing = new FactoryBooleanSwing(this);
        }
        return this.factorySwing;
    }

    @Override
    public GuiFactoryFx getGuiFactoryFx() {
        if (this.factorySwing != null) {
            throw new IllegalArgumentException("Can not mix different types of editors.");
        }
        if (this.factoryFx == null) {
            this.factoryFx = new FactoryBooleanFx(this);
        }
        return this.factoryFx;
    }

    private void fillComponent() {
        if (this.factorySwing != null) {
            this.factorySwing.fillComponent();
        }
        if (this.factoryFx != null) {
            this.factoryFx.fillComponent();
        }
    }

    private void readComponent() {
        if (this.factorySwing != null) {
            this.value = this.factorySwing.isSelected();
        }
        if (this.factoryFx != null) {
            this.value = this.factoryFx.isSelected();
        }
    }

    @Override
    public JsonElement getConfig() {
        this.readComponent();
        if (this.value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive(this.value);
    }

    public Boolean getRawValue() {
        return this.value;
    }

    public void setRawValue(Boolean value) {
        this.value = value;
    }

    @Override
    public Boolean getValue() {
        this.readComponent();
        return this.value;
    }

    @Override
    public void setValue(Boolean value) {
        this.value = value;
        this.fillComponent();
    }

    @Override
    public void setProfile(String profile) {
        this.profile = profile;
        this.fillComponent();
    }

    public void setProfilesEdit(String csv) {
        this.profilesEdit = AnnotationHelper.csvToReadOnlySet(csv);
    }

    @Override
    public boolean canEdit() {
        return this.profilesEdit.contains(this.profile);
    }

    @Override
    public boolean isDefault() {
        this.readComponent();
        return Objects.equals(this.dflt, this.value);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface EdOptsBool {
        public boolean dflt() default false;

        public boolean dfltIsNull() default false;

        public String profilesEdit() default "";
    }
}

