/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.fraunhofer.iosb.ilt.configurable.ConfigEditor;
import de.fraunhofer.iosb.ilt.configurable.ConfigurationException;
import de.fraunhofer.iosb.ilt.configurable.GuiFactoryFx;
import de.fraunhofer.iosb.ilt.configurable.GuiFactorySwing;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.ItemObject;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.RootSchema;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.SchemaItem;
import de.fraunhofer.iosb.ilt.configurable.annotations.AnnotationHelper;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorDefault;
import de.fraunhofer.iosb.ilt.configurable.editor.fx.FactoryMapFx;
import de.fraunhofer.iosb.ilt.configurable.editor.swing.FactoryMapSwing;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEditorMap<T, V>
extends EditorDefault<T>
implements Iterable<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEditorMap.class.getName());
    protected final Map<String, Item<V>> options = new LinkedHashMap<String, Item<V>>();
    protected final Set<String> value = new HashSet<String>();
    private final List<String> optionalOptions = new ArrayList<String>();
    private final int columns;
    private Set<String> profilesEdit = AnnotationHelper.csvToReadOnlySet("");
    private String profile = "default";
    private FactoryMapSwing factorySwing;
    private FactoryMapFx factoryFx;

    protected AbstractEditorMap() {
        this.columns = 1;
    }

    protected AbstractEditorMap(int columns) {
        this.columns = columns;
    }

    protected AbstractEditorMap(int columns, String label, String description) {
        this.columns = columns;
        this.setLabel(label);
        this.setDescription(description);
    }

    public void addOption(String name, ConfigEditor editor, boolean optional) {
        this.addOption(name, name, editor, optional, 1);
    }

    public void addOption(String name, ConfigEditor editor, boolean optional, int width) {
        this.addOption(name, name, editor, optional, width);
    }

    public void addOption(String fieldName, String jsonName, ConfigEditor editor, boolean optional, int width) {
        this.addOption(fieldName, jsonName, editor, optional, width, false);
    }

    public void addOption(String fieldName, String jsonName, ConfigEditor editor, boolean optional, int width, boolean merge) {
        this.addOption(fieldName, jsonName, editor, optional, width, merge, "", "");
    }

    public void addOption(String fieldName, String jsonName, ConfigEditor editor, boolean optional, int width, boolean merge, String profilesSave, String profilesGui) {
        if (this.options.containsKey(jsonName)) {
            throw new IllegalArgumentException("Map already contains an editor for " + jsonName);
        }
        editor.setProfile(this.profile);
        Item item = new Item(fieldName, jsonName, editor, optional, width, merge, profilesSave, profilesGui);
        this.options.put(jsonName, item);
        if (optional) {
            this.optionalOptions.add(jsonName);
        } else {
            this.addItem(jsonName);
        }
    }

    public void addOption(String fieldName, String jsonName, ConfigEditor editor, ConfigurableField annotation) {
        this.addOption(fieldName, jsonName, editor, annotation.optional(), 1, annotation.merge(), annotation.profilesSave(), annotation.profilesGui());
    }

    @Override
    public void setConfig(JsonElement config) {
        this.value.clear();
        if (config != null && config.isJsonObject()) {
            JsonObject configObj = config.getAsJsonObject();
            for (Map.Entry<String, Item<V>> entry : this.options.entrySet()) {
                String jsonName = entry.getKey();
                Item<V> item = entry.getValue();
                if (item.merge) {
                    item.editor.setConfig(config);
                    this.value.add(jsonName);
                    continue;
                }
                JsonElement itemConfig = configObj.get(item.jsonName);
                item.editor.setConfig(itemConfig);
                if (itemConfig == null && item.optional) continue;
                this.value.add(jsonName);
            }
        } else {
            for (Map.Entry<String, Item<V>> entry : this.options.entrySet()) {
                String key = entry.getKey();
                Item<V> val = entry.getValue();
                val.editor.setConfig(null);
                if (val.optional) continue;
                this.value.add(key);
            }
        }
        if (this.factorySwing != null) {
            this.factorySwing.fillComponent();
        }
        if (this.factoryFx != null) {
            this.factoryFx.fillComponent();
        }
    }

    @Override
    public JsonElement getConfig() {
        JsonObject result = new JsonObject();
        for (Map.Entry<String, Item<V>> entry : this.options.entrySet()) {
            String key = entry.getKey();
            if (!this.value.contains(key)) continue;
            Item<V> item = entry.getValue();
            JsonElement itemConfig = item.editor.getConfig();
            if (item.merge && itemConfig.isJsonObject()) {
                JsonObject itemObject = itemConfig.getAsJsonObject();
                for (Map.Entry<String, JsonElement> subEntry : itemObject.entrySet()) {
                    result.add(subEntry.getKey(), subEntry.getValue());
                }
                continue;
            }
            result.add(key, itemConfig);
        }
        return result;
    }

    @Override
    public SchemaItem getJsonSchema(RootSchema rootSchema) {
        ItemObject myItem;
        SchemaItem retval = myItem = (ItemObject)((ItemObject)new ItemObject().setTitle(this.getLabel())).setDescription(this.getDescription());
        if (rootSchema == null) {
            rootSchema = new RootSchema(myItem);
            retval = rootSchema;
        }
        for (Map.Entry<String, Item<V>> subItem : this.options.entrySet()) {
            String subItemName = subItem.getKey();
            Item<V> subItemValue = subItem.getValue();
            SchemaItem subItemSchema = subItemValue.editor.getJsonSchema(rootSchema);
            myItem.addProperty(subItemName, subItemValue.optional, subItemSchema);
        }
        return retval;
    }

    @Override
    public GuiFactorySwing getGuiFactorySwing() {
        if (this.factoryFx != null) {
            throw new IllegalArgumentException("Can not mix different types of editors.");
        }
        if (this.factorySwing == null) {
            this.factorySwing = new FactoryMapSwing(this);
        }
        return this.factorySwing;
    }

    @Override
    public GuiFactoryFx getGuiFactoryFx() {
        if (this.factorySwing != null) {
            throw new IllegalArgumentException("Can not mix different types of editors.");
        }
        if (this.factoryFx == null) {
            this.factoryFx = new FactoryMapFx(this);
        }
        return this.factoryFx;
    }

    public void fillComponent() {
        if (this.factorySwing != null) {
            this.factorySwing.fillComponent();
        }
        if (this.factoryFx != null) {
            this.factoryFx.fillComponent();
        }
    }

    public void addItem(String jsonName) {
        this.value.add(jsonName);
        if (this.factorySwing != null) {
            this.factorySwing.addItem(jsonName);
        }
        if (this.factoryFx != null) {
            this.factoryFx.addItem(jsonName);
        }
    }

    public void removeItem(String jsonName) {
        Item<V> item = this.options.get(jsonName);
        if (item.optional) {
            this.value.remove(jsonName);
            if (this.factorySwing != null) {
                this.factorySwing.removeItem(item);
            }
            if (this.factoryFx != null) {
                this.factoryFx.removeItem(item);
            }
        }
    }

    public void setContentsOn(Object target) throws ConfigurationException {
        for (Item<V> item : this.options.values()) {
            String fieldName;
            String methodName;
            Object val;
            if (AnnotationHelper.hasConfigurableConstructorParameter(target, item.fieldName) || (val = item.editor.getValue()) == null || AbstractEditorMap.callMethodOn(methodName = "set" + (fieldName = item.fieldName).substring(0, 1).toUpperCase(Locale.ROOT) + fieldName.substring(1), target, val)) continue;
            Field field = FieldUtils.getField(target.getClass(), fieldName, true);
            try {
                FieldUtils.writeField(field, target, val, true);
            }
            catch (IllegalAccessException ex) {
                LOGGER.trace("Exception:", ex);
                LOGGER.warn("Could not set field {}.", (Object)field);
            }
        }
    }

    private static boolean callMethodOn(String methodName, Object target, Object val) {
        try {
            MethodUtils.invokeMethod(target, methodName, val);
            return true;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exc) {
            LOGGER.debug("Failed call method {} on {}.", (Object)methodName, (Object)target.getClass().getName());
            return false;
        }
    }

    @Override
    public Iterator<String> iterator() {
        return this.value.iterator();
    }

    public Set<String> getRawValue() {
        return this.value;
    }

    public V getValue(String name) throws ConfigurationException {
        Item<V> item = this.options.get(name);
        return item.editor.getValue();
    }

    public boolean isOptionSet(String name) {
        return this.value.contains(name);
    }

    public final List<String> getOptionalOptions() {
        return this.optionalOptions;
    }

    public final int getColumns() {
        return this.columns;
    }

    public Map<String, Item<V>> getOptions() {
        return this.options;
    }

    public String getProfile() {
        return this.profile;
    }

    @Override
    public void setProfile(String profile) {
        this.profile = profile.toLowerCase();
        for (Item<V> item : this.options.values()) {
            item.editor.setProfile(this.profile);
        }
        this.fillComponent();
    }

    public void setProfilesEdit(String csv) {
        this.profilesEdit = AnnotationHelper.csvToReadOnlySet(csv);
        this.fillComponent();
    }

    @Override
    public boolean canEdit() {
        return this.profilesEdit.contains(this.profile);
    }

    public static final class Item<V> {
        public final ConfigEditor<V> editor;
        public final boolean optional;
        public final int colwidth;
        public final String jsonName;
        public final String fieldName;
        public final String label;
        public final boolean merge;
        public final Set<String> profilesSave;
        public final Set<String> profilesGui;

        public Item(String fieldName, String jsonName, ConfigEditor<V> editor, boolean optional, int colwidth, boolean merge, String profilesSave, String profilesGui) {
            this.fieldName = fieldName;
            this.jsonName = jsonName;
            String edLabel = editor.getLabel();
            this.label = edLabel == null || edLabel.isEmpty() ? jsonName : edLabel;
            this.editor = editor;
            this.optional = optional;
            this.colwidth = colwidth;
            this.merge = merge;
            this.profilesSave = AnnotationHelper.csvToReadOnlySet(profilesSave);
            this.profilesGui = AnnotationHelper.csvToReadOnlySet(profilesGui);
        }

        public String getName() {
            return this.jsonName;
        }

        public boolean hasGuiProfile(String profile) {
            return this.profilesGui.contains(profile);
        }

        public boolean hasSaveProfile(String profile) {
            return this.profilesSave.contains(profile);
        }

        public String toString() {
            return this.label;
        }
    }
}

