/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.sqlite;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jooq.Check;
import org.jooq.CommonTableExpression;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Meta;
import org.jooq.Query;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.SortOrder;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.exception.DataDefinitionException;
import org.jooq.impl.DSL;
import org.jooq.impl.ParserException;
import org.jooq.impl.SQLDataType;
import org.jooq.meta.AbstractDatabase;
import org.jooq.meta.AbstractIndexDefinition;
import org.jooq.meta.ArrayDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultCheckConstraintDefinition;
import org.jooq.meta.DefaultIndexColumnDefinition;
import org.jooq.meta.DefaultRelations;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.IndexColumnDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.jaxb.SchemaMappingType;
import org.jooq.meta.sqlite.SQLiteTableDefinition;
import org.jooq.meta.sqlite.sqlite_master.SQLiteMaster;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;

public class SQLiteDatabase
extends AbstractDatabase {
    private static final JooqLogger log = JooqLogger.getLogger(SQLiteDatabase.class);
    private Meta snapshot;

    public SQLiteDatabase() {
        SchemaMappingType schema = new SchemaMappingType();
        schema.setInputSchema("");
        schema.setOutputSchema("");
        ArrayList<SchemaMappingType> schemata = new ArrayList<SchemaMappingType>();
        schemata.add(schema);
        this.setConfiguredSchemata(schemata);
    }

    @Override
    protected DSLContext create0() {
        return DSL.using(this.getConnection(), SQLDialect.SQLITE);
    }

    @Override
    protected List<IndexDefinition> getIndexes0() throws SQLException {
        ArrayList<IndexDefinition> result = new ArrayList<IndexDefinition>();
        Field fIndexName = DSL.field("il.name", String.class).as("index_name");
        Field fUnique = DSL.field("il.\"unique\"", Boolean.TYPE).as("unique");
        final Field fSeqno = DSL.field("ii.seqno", Integer.TYPE).add(DSL.one()).as("seqno");
        final Field fColumnName = DSL.field("ii.name", String.class).as("column_name");
        Map<Record, Result<Record>> indexes = this.create().select(SQLiteMaster.NAME, fIndexName, fUnique, fSeqno, fColumnName).from(SQLiteMaster.SQLITE_MASTER, DSL.table("pragma_index_list({0})", new QueryPart[]{SQLiteMaster.NAME}).as("il"), DSL.table("pragma_index_info(il.name)").as("ii")).where(SQLiteMaster.TYPE.eq(DSL.inline("table"))).and(this.getIncludeSystemIndexes() ? DSL.noCondition() : DSL.field("il.origin", SQLDataType.VARCHAR).notIn(new Field[]{DSL.inline("pk"), DSL.inline("u")})).orderBy(1, 2, 4).fetchGroups(new Field[]{SQLiteMaster.NAME, fIndexName, fUnique}, new Field[]{fColumnName, fSeqno});
        block0: for (Map.Entry<Record, Result<Record>> entry : indexes.entrySet()) {
            Record index = entry.getKey();
            final Result<Record> columns = entry.getValue();
            SchemaDefinition tableSchema = this.getSchemata().get(0);
            if (tableSchema == null) continue;
            String indexName = (String)index.get(fIndexName);
            String tableName = (String)index.get(SQLiteMaster.NAME);
            final TableDefinition table = this.getTable(tableSchema, tableName);
            if (table == null) continue;
            boolean unique = (Boolean)index.get(fUnique);
            for (Record column : columns) {
                if (table.getColumn((String)column.get(fColumnName)) != null) continue;
                continue block0;
            }
            result.add(new AbstractIndexDefinition(tableSchema, indexName, table, unique){
                List<IndexColumnDefinition> indexColumns;
                {
                    super(schema, name, table2, unique);
                    this.indexColumns = new ArrayList<IndexColumnDefinition>();
                    for (Record column : columns) {
                        this.indexColumns.add(new DefaultIndexColumnDefinition(this, table.getColumn((String)column.get(fColumnName)), SortOrder.ASC, column.get(fSeqno, Integer.TYPE)));
                    }
                }

                @Override
                protected List<IndexColumnDefinition> getIndexColumns0() {
                    return this.indexColumns;
                }
            });
        }
        return result;
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
        for (Table<?> t2 : this.snapshot().getTables()) {
            TableDefinition table;
            UniqueKey<?> pk2 = t2.getPrimaryKey();
            if (pk2 == null || (table = this.getTable(this.getSchemata().get(0), pk2.getTable().getName())) == null) continue;
            for (Field field : pk2.getFields()) {
                relations2.addPrimaryKey(pk2.getName(), table, table.getColumn(field.getName()));
            }
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) throws SQLException {
        for (Table<?> t2 : this.snapshot().getTables()) {
            for (UniqueKey<?> uk : t2.getUniqueKeys()) {
                TableDefinition table = this.getTable(this.getSchemata().get(0), uk.getTable().getName());
                if (table == null) continue;
                for (Field field : uk.getFields()) {
                    relations2.addUniqueKey(uk.getName(), table, table.getColumn(field.getName()));
                }
            }
        }
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
        for (Table<?> t2 : this.snapshot().getTables()) {
            for (ForeignKey<?, ?> fk2 : t2.getReferences()) {
                UniqueKey<?> uk = fk2.getKey();
                if (uk == null) continue;
                TableDefinition fkTable = this.getTable(this.getSchemata().get(0), fk2.getTable().getName(), true);
                TableDefinition ukTable = this.getTable(this.getSchemata().get(0), uk.getTable().getName(), true);
                if (fkTable == null || ukTable == null) continue;
                Object ukName = StringUtils.isBlank(uk.getName()) ? "pk_" + ukTable.getName() : uk.getName();
                String fkName = StringUtils.isBlank(fk2.getName()) ? "fk_" + fkTable.getName() + "_" + (String)ukName : fk2.getName();
                TableField<R, ?>[] fkFields = fk2.getFieldsArray();
                TableField<?, ?>[] ukFields = fk2.getKeyFieldsArray();
                for (int i2 = 0; i2 < fkFields.length; ++i2) {
                    relations2.addForeignKey(fkName, fkTable, fkTable.getColumn(fkFields[i2].getName(), true), (String)ukName, ukTable, ukTable.getColumn(ukFields[i2].getName(), true), true);
                }
            }
        }
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations r2) throws SQLException {
        DSLContext ctx = this.create().configuration().deriveSettings(s2 -> s2.withInterpreterDelayForeignKeyDeclarations(true)).dsl();
        SchemaDefinition schema = this.getSchemata().get(0);
        for (Record record : ctx.select(SQLiteMaster.TBL_NAME, SQLiteMaster.SQL).from((TableLike<?>)SQLiteMaster.SQLITE_MASTER).where((Condition)SQLiteMaster.SQL.likeIgnoreCase("%CHECK%")).orderBy(SQLiteMaster.TBL_NAME)) {
            TableDefinition table = this.getTable(schema, (String)record.get(SQLiteMaster.TBL_NAME));
            if (table == null) continue;
            String sql = (String)record.get(SQLiteMaster.SQL);
            try {
                Query query = ctx.parser().parseQuery(sql);
                for (Table<?> t2 : ctx.meta(query).getTables(table.getName())) {
                    for (Check<?> check : t2.getChecks()) {
                        r2.addCheckConstraint(table, new DefaultCheckConstraintDefinition(schema, table, check.getName(), ctx.renderInlined(check.condition()), check.enforced()));
                    }
                }
            }
            catch (ParserException e2) {
                log.info((Object)("Cannot parse SQL: " + sql), e2);
            }
            catch (DataDefinitionException e3) {
                log.info((Object)("Cannot interpret SQL: " + sql), e3);
            }
        }
    }

    @Override
    protected List<CatalogDefinition> getCatalogs0() throws SQLException {
        ArrayList<CatalogDefinition> result = new ArrayList<CatalogDefinition>();
        result.add(new CatalogDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        result.add(new SchemaDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        CommonTableExpression virtualTables = DSL.name("virtual_tables").fields("name").as(DSL.select(DSL.coalesce(SQLiteMaster.NAME, new Field[]{DSL.inline("")})).from((TableLike<?>)SQLiteMaster.SQLITE_MASTER).where((Condition)SQLiteMaster.SQL.likeIgnoreCase(DSL.inline("%create virtual table%"))));
        for (Record record : this.create().with(virtualTables).select(SQLiteMaster.NAME, DSL.when(SQLiteMaster.TYPE.eq(DSL.inline("view")), DSL.inline(TableOptions.TableType.VIEW.name())).else_(DSL.inline(TableOptions.TableType.TABLE.name())).as("table_type"), SQLiteMaster.SQL).from((TableLike<?>)SQLiteMaster.SQLITE_MASTER).where(SQLiteMaster.TYPE.in("table", "view")).and(this.getIncludeSystemTables() ? DSL.noCondition() : SQLiteMaster.NAME.notLike(DSL.all(new Field[]{DSL.inline("%!_content"), DSL.inline("%!_segments"), DSL.inline("%!_segdir"), DSL.inline("%!_docsize"), DSL.inline("%!_stat")})).escape('!').or(SQLiteMaster.NAME.like(DSL.inline("%!_content")).escape('!').and(DSL.replace(SQLiteMaster.NAME, DSL.inline("_content")).notIn(DSL.selectFrom(virtualTables)))).or(SQLiteMaster.NAME.like(DSL.inline("%!_segments")).escape('!').and(DSL.replace(SQLiteMaster.NAME, DSL.inline("_segments")).notIn(DSL.selectFrom(virtualTables)))).or(SQLiteMaster.NAME.like(DSL.inline("%!_segdir")).escape('!').and(DSL.replace(SQLiteMaster.NAME, DSL.inline("_segdir")).notIn(DSL.selectFrom(virtualTables)))).or(SQLiteMaster.NAME.like(DSL.inline("%!_docsize")).escape('!').and(DSL.replace(SQLiteMaster.NAME, DSL.inline("_docsize")).notIn(DSL.selectFrom(virtualTables)))).or(SQLiteMaster.NAME.like(DSL.inline("%!_stat")).escape('!').and(DSL.replace(SQLiteMaster.NAME, DSL.inline("_stat")).notIn(DSL.selectFrom(virtualTables))))).orderBy(SQLiteMaster.NAME)) {
            String name = (String)record.get(SQLiteMaster.NAME);
            TableOptions.TableType tableType = record.get("table_type", TableOptions.TableType.class);
            String source = (String)record.get(SQLiteMaster.SQL);
            result.add(new SQLiteTableDefinition(this.getSchemata().get(0), name, "", tableType, source));
        }
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<DomainDefinition> getDomains0() throws SQLException {
        ArrayList<DomainDefinition> result = new ArrayList<DomainDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    Meta snapshot() {
        if (this.snapshot == null) {
            this.snapshot = this.create().meta().snapshot();
        }
        return this.snapshot;
    }
}

