/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import java.util.ArrayList;
import java.util.List;
import org.jooq.meta.AbstractConstraintDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.ForeignKeyDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UniqueKeyDefinition;
import org.jooq.tools.JooqLogger;

public class DefaultUniqueKeyDefinition
extends AbstractConstraintDefinition
implements UniqueKeyDefinition {
    private static final JooqLogger log = JooqLogger.getLogger(DefaultUniqueKeyDefinition.class);
    private final List<ForeignKeyDefinition> foreignKeys = new ArrayList<ForeignKeyDefinition>();
    private final List<ColumnDefinition> keyColumns = new ArrayList<ColumnDefinition>();
    private final boolean isPrimaryKey;
    private transient boolean resolvedUKCalculated;
    private transient UniqueKeyDefinition resolvedUK;

    public DefaultUniqueKeyDefinition(SchemaDefinition schema, String name, TableDefinition table, boolean isPrimaryKey) {
        this(schema, name, table, isPrimaryKey, true);
    }

    public DefaultUniqueKeyDefinition(SchemaDefinition schema, String name, TableDefinition table, boolean isPrimaryKey, boolean enforced) {
        super(schema, table, name, enforced);
        this.isPrimaryKey = isPrimaryKey;
    }

    @Override
    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    @Override
    public List<ColumnDefinition> getKeyColumns() {
        return this.keyColumns;
    }

    @Override
    public List<ForeignKeyDefinition> getForeignKeys() {
        return this.foreignKeys;
    }

    @Override
    public final UniqueKeyDefinition resolveReferencedKey() {
        if (!this.resolvedUKCalculated) {
            this.resolvedUKCalculated = true;
            ForeignKeyDefinition candidate = null;
            for (ForeignKeyDefinition fk2 : this.getTable().getForeignKeys()) {
                if (!this.keyColumns.equals(fk2.getKeyColumns())) continue;
                if (candidate == null) {
                    candidate = fk2;
                    continue;
                }
                log.info((Object)"Cannot resolve key", (this.isPrimaryKey ? "Primary" : "Unique") + " key coincides with at least two foreign keys: " + candidate + " and " + fk2);
                return null;
            }
            this.resolvedUK = candidate == null ? this : candidate.resolveReferencedKey();
        }
        return this.resolvedUK;
    }
}

