/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jooq.Converter;
import org.jooq.DataType;
import org.jooq.Name;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.DateAsTimestampBinding;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.EnumConverter;
import org.jooq.impl.LocalDateAsLocalDateTimeBinding;
import org.jooq.impl.SQLDataType;
import org.jooq.meta.AbstractDefinition;
import org.jooq.meta.DataTypeDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultJavaTypeResolver;
import org.jooq.meta.Definition;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.JavaTypeResolver;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.TypedElementDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.jaxb.CustomType;
import org.jooq.meta.jaxb.ForcedType;
import org.jooq.meta.jaxb.LambdaConverter;
import org.jooq.tools.Convert;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;

public abstract class AbstractTypedElementDefinition<T extends Definition>
extends AbstractDefinition
implements TypedElementDefinition<T> {
    private static final JooqLogger log = JooqLogger.getLogger(AbstractTypedElementDefinition.class);
    private static final Pattern LENGTH_PRECISION_SCALE_PATTERN = Pattern.compile("[\\w\\s]+(?:\\(\\s*?(\\d+)\\s*?\\)|\\(\\s*?(\\d+)\\s*?,\\s*?(\\d+)\\s*?\\))");
    private final T container;
    private final DataTypeDefinition definedType;
    private transient DataTypeDefinition type;
    private transient DataTypeDefinition resolvedType;

    public AbstractTypedElementDefinition(T container, String name, int position, DataTypeDefinition definedType, String comment) {
        this(container, name, position, definedType, comment, null);
    }

    public AbstractTypedElementDefinition(T container, String name, int position, DataTypeDefinition definedType, String comment, String overload) {
        super(container.getDatabase(), container.getSchema(), AbstractTypedElementDefinition.protectName(container, name, position), comment, overload);
        this.container = container;
        this.definedType = definedType;
    }

    private static final String protectName(Definition container, String name, int position) {
        if (name == null) {
            if (container instanceof TableDefinition) {
                log.info((Object)"Missing name", "Table " + container + " holds a column without a name at position " + position);
            } else if (container instanceof UDTDefinition) {
                log.info((Object)"Missing name", "UDT " + container + " holds an attribute without a name at position " + position);
            } else if (container instanceof IndexDefinition) {
                log.info((Object)"Missing name", "Index " + container + " holds a column without a name at position " + position);
            } else if (container instanceof RoutineDefinition) {
                log.info((Object)"Missing name", "Routine " + container + " holds a parameter without a name at position " + position);
            } else {
                log.info((Object)"Missing name", "Object " + container + " holds an element without a name at position " + position);
            }
            return "_" + position;
        }
        return name;
    }

    @Override
    public final T getContainer() {
        return this.container;
    }

    @Override
    public List<Definition> getDefinitionPath() {
        ArrayList<Definition> result = new ArrayList<Definition>();
        result.addAll(this.getContainer().getDefinitionPath());
        result.add(this);
        return result;
    }

    @Override
    public DataTypeDefinition getType() {
        if (this.type == null) {
            this.type = AbstractTypedElementDefinition.mapDefinedType(this.container, this, this.definedType, new DefaultJavaTypeResolver());
        }
        return this.type;
    }

    @Override
    public DataTypeDefinition getType(JavaTypeResolver resolver) {
        if (this.resolvedType == null) {
            this.resolvedType = AbstractTypedElementDefinition.mapDefinedType(this.container, this, this.definedType, resolver);
        }
        return this.resolvedType;
    }

    @Override
    public DataTypeDefinition getDefinedType() {
        return this.definedType;
    }

    public static final DataType<?> getDataType(Database db2, String t2, int p2, int s2) {
        if ("OFFSETDATETIME".equalsIgnoreCase(t2)) {
            return SQLDataType.OFFSETDATETIME.precision(p2);
        }
        if ("OFFSETTIME".equalsIgnoreCase(t2)) {
            return SQLDataType.OFFSETTIME.precision(p2);
        }
        if ("LOCALDATE".equalsIgnoreCase(t2)) {
            return SQLDataType.LOCALDATE;
        }
        if ("LOCALDATETIME".equalsIgnoreCase(t2)) {
            return SQLDataType.LOCALDATETIME.precision(p2);
        }
        if ("LOCALTIME".equalsIgnoreCase(t2)) {
            return SQLDataType.LOCALTIME.precision(p2);
        }
        if (db2.getForceIntegerTypesOnZeroScaleDecimals()) {
            return DefaultDataType.getDataType(db2.getDialect(), t2, p2, s2);
        }
        DataType<?> result = DefaultDataType.getDataType(db2.getDialect(), t2);
        if (result.getType() == BigDecimal.class && s2 == 0) {
            DefaultDataType.getDataType(db2.getDialect(), BigInteger.class);
        }
        return result;
    }

    public static final DataTypeDefinition mapDefinedType(Definition container, Definition child, DataTypeDefinition definedType, JavaTypeResolver resolver) {
        ForcedType forcedType;
        DataTypeDefinition result = definedType;
        Database db2 = container.getDatabase();
        log.debug((Object)"Type mapping", child + " with type " + definedType.getType());
        if (db2.dateAsTimestamp()) {
            DataType<?> dataType = null;
            try {
                dataType = AbstractTypedElementDefinition.getDataType(db2, result.getType(), 0, 0);
            }
            catch (SQLDialectNotSupportedException sQLDialectNotSupportedException) {
                // empty catch block
            }
            if (dataType != null && SQLDataType.DATE.equals(dataType.getSQLDataType())) {
                DataType<?> forcedDataType = AbstractTypedElementDefinition.getDataType(db2, SQLDataType.TIMESTAMP.getTypeName(), 0, 0);
                String binding = DateAsTimestampBinding.class.getName();
                if (db2.javaTimeTypes()) {
                    binding = LocalDateAsLocalDateTimeBinding.class.getName();
                }
                result = new DefaultDataTypeDefinition(db2, child.getSchema(), forcedDataType.getTypeName(), 0, 0, 0, result.isNullable(), result.getDefaultValue(), result.isIdentity(), null, null, binding, null);
            }
        }
        if ((forcedType = db2.getConfiguredForcedType(child, definedType)) != null) {
            String uType = forcedType.getName();
            Object converter = null;
            String binding = result.getBinding();
            CustomType customType = AbstractTypedElementDefinition.customType(db2, forcedType);
            if (customType != null) {
                String string = uType = !StringUtils.isBlank(customType.getType()) ? customType.getType() : customType.getName();
                if (Boolean.TRUE.equals(customType.isEnumConverter()) || EnumConverter.class.getName().equals(customType.getConverter())) {
                    String tType = AbstractTypedElementDefinition.tType(db2, resolver, definedType);
                    converter = resolver.constructorCall(EnumConverter.class.getName() + "<" + resolver.ref(tType) + ", " + resolver.ref(uType) + ">") + "(" + resolver.classLiteral(tType) + ", " + resolver.classLiteral(uType) + ")";
                } else if (customType.getLambdaConverter() != null) {
                    LambdaConverter c2 = customType.getLambdaConverter();
                    String tType = AbstractTypedElementDefinition.tType(db2, resolver, definedType);
                    converter = resolver.ref(Converter.class) + ".of" + (!Boolean.FALSE.equals(c2.isNullable()) ? "Nullable" : "") + "(" + resolver.classLiteral(tType) + ", " + resolver.classLiteral(uType) + ", " + c2.getFrom() + ", " + c2.getTo() + ")";
                } else if (!StringUtils.isBlank(customType.getConverter())) {
                    converter = customType.getConverter();
                }
                if (!StringUtils.isBlank(customType.getBinding())) {
                    binding = customType.getBinding();
                }
            }
            if (uType != null) {
                db2.markUsed(forcedType);
                log.info((Object)"Forcing type", child + " to " + forcedType);
                DataType<?> forcedDataType = null;
                boolean n2 = result.isNullable();
                String d2 = result.getDefaultValue();
                boolean i2 = result.isIdentity();
                boolean r2 = result.isReadonly();
                String g2 = result.getGeneratedAlwaysAs();
                int l2 = 0;
                int p2 = 0;
                int s2 = 0;
                Matcher matcher = LENGTH_PRECISION_SCALE_PATTERN.matcher(uType);
                if (matcher.find()) {
                    if (!StringUtils.isEmpty(matcher.group(1))) {
                        l2 = p2 = Convert.convert((Object)matcher.group(1), Integer.TYPE).intValue();
                    } else {
                        p2 = Convert.convert((Object)matcher.group(2), Integer.TYPE);
                        s2 = Convert.convert((Object)matcher.group(3), Integer.TYPE);
                    }
                }
                try {
                    forcedDataType = AbstractTypedElementDefinition.getDataType(db2, uType, p2, s2);
                }
                catch (SQLDialectNotSupportedException sQLDialectNotSupportedException) {
                    // empty catch block
                }
                if (forcedDataType != null) {
                    if (customType != null) {
                        log.warn((Object)"Custom type conflict", child + " has custom type " + customType + " forced by " + forcedType + " but a data type rewrite applies");
                    }
                    result = new DefaultDataTypeDefinition(db2, child.getSchema(), uType, l2, p2, s2, n2, r2, g2, d2, i2, null, (String)converter, binding, null);
                } else if (customType != null) {
                    l2 = result.getLength();
                    p2 = result.getPrecision();
                    s2 = result.getScale();
                    String t2 = result.getType();
                    Name u2 = result.getQualifiedUserType();
                    result = new DefaultDataTypeDefinition(db2, definedType.getSchema(), t2, l2, p2, s2, n2, r2, g2, d2, i2, u2, (String)converter, binding, uType);
                } else if (db2.getConfiguredCustomTypes().isEmpty()) {
                    log.warn("Bad configuration for <forcedType/> " + forcedType.getName() + ". No matching SQLDataType found: " + forcedType);
                } else {
                    log.warn("Bad configuration for <forcedType/> " + forcedType.getName() + ". No matching <customType/> found, and no matching SQLDataType found: " + forcedType);
                }
            }
        }
        return result;
    }

    private static final String tType(Database db2, JavaTypeResolver resolver, DataTypeDefinition definedType) {
        if (resolver != null) {
            return resolver.resolve(definedType);
        }
        try {
            return AbstractTypedElementDefinition.getDataType(db2, definedType.getType(), definedType.getPrecision(), definedType.getScale()).getType().getName();
        }
        catch (SQLDialectNotSupportedException ignore) {
            return Object.class.getName();
        }
    }

    public static final CustomType customType(Database db2, ForcedType forcedType) {
        String name = forcedType.getName();
        if (StringUtils.isBlank(forcedType.getUserType())) {
            if (name != null) {
                for (CustomType type : db2.getConfiguredCustomTypes()) {
                    if (!name.equals(type.getName())) continue;
                    return type;
                }
            }
        } else {
            return new CustomType().withBinding(forcedType.getBinding()).withEnumConverter(forcedType.isEnumConverter()).withLambdaConverter(forcedType.getLambdaConverter()).withConverter(forcedType.getConverter()).withName(name).withType(forcedType.getUserType());
        }
        return null;
    }

    @Override
    public final DomainDefinition getDomain() {
        return this.getDatabase().getDomain(this.getSchema(), this.getDefinedType().getQualifiedUserType());
    }
}

