/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jooq.Catalog;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Meta;
import org.jooq.Schema;
import org.jooq.Sequence;
import org.jooq.Table;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractDatabase;
import org.jooq.meta.ArrayDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultMetaTableDefinition;
import org.jooq.meta.DefaultRelations;
import org.jooq.meta.DefaultSequenceDefinition;
import org.jooq.meta.Definition;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UDTDefinition;

public abstract class AbstractMetaDatabase
extends AbstractDatabase {
    private List<Catalog> catalogs;
    private List<Schema> schemas;
    private static final Comparator<Definition> COMP = Comparator.comparing(Definition::getQualifiedInputName);

    @Override
    protected DSLContext create0() {
        return DSL.using(this.getConnection());
    }

    protected abstract Meta getMeta0();

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) throws SQLException {
        for (Schema schema : this.getSchemasFromMeta()) {
            SchemaDefinition s2 = this.getSchema(schema.getName());
            if (s2 == null) continue;
            for (Table<?> table : schema.getTables()) {
                UniqueKey<?> key;
                TableDefinition t2 = this.getTable(s2, table.getName());
                if (t2 == null || (key = table.getPrimaryKey()) == null) continue;
                for (Field field : key.getFields()) {
                    relations2.addPrimaryKey("PK_" + key.getTable().getName(), t2, t2.getColumn(field.getName()));
                }
            }
        }
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
        for (Schema referencingS : this.getSchemasFromMeta()) {
            SchemaDefinition referencingSD = this.getSchema(referencingS.getName());
            if (referencingSD == null) continue;
            for (Table<?> referencingT : referencingS.getTables()) {
                TableDefinition referencingTD = this.getTable(referencingSD, referencingT.getName());
                if (referencingTD == null) continue;
                block2: for (ForeignKey<?, ?> fk2 : referencingT.getReferences()) {
                    SchemaDefinition referencedSD;
                    TableDefinition referencedTD;
                    Table referencedT;
                    UniqueKey<?> uk = fk2.getKey();
                    if (uk == null || (referencedT = uk.getTable()) == null) continue;
                    Schema referencedS = referencedT.getSchema();
                    if (referencedS == null) {
                        referencedS = referencingS;
                    }
                    if ((referencedTD = this.getTable(referencedSD = this.getSchema(referencedS.getName()), referencedT.getName())) == null) continue;
                    for (Field field : fk2.getFields()) {
                        if (referencingTD.getColumn(field.getName()) != null) continue;
                        continue block2;
                    }
                    for (Field field : fk2.getFields()) {
                        relations2.addForeignKey(fk2.getName(), referencingTD, referencingTD.getColumn(field.getName()), uk.getName(), referencedTD);
                    }
                }
            }
        }
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations r2) throws SQLException {
    }

    @Override
    protected List<CatalogDefinition> getCatalogs0() throws SQLException {
        ArrayList<CatalogDefinition> result = new ArrayList<CatalogDefinition>();
        for (Catalog catalog : this.getCatalogsFromMeta()) {
            result.add(new CatalogDefinition((Database)this, catalog.getName(), ""));
        }
        result.sort(COMP);
        return result;
    }

    private List<Catalog> getCatalogsFromMeta() {
        if (this.catalogs == null) {
            this.catalogs = new ArrayList<Catalog>(this.getMeta0().getCatalogs());
        }
        return this.catalogs;
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        for (Schema schema : this.getSchemasFromMeta()) {
            if (schema.getCatalog() != null) {
                CatalogDefinition catalog = this.getCatalog(schema.getCatalog().getName());
                if (catalog == null) continue;
                result.add(new SchemaDefinition((Database)this, schema.getName(), "", catalog));
                continue;
            }
            result.add(new SchemaDefinition((Database)this, schema.getName(), ""));
        }
        result.sort(COMP);
        return result;
    }

    private List<Schema> getSchemasFromMeta() {
        if (this.schemas == null) {
            this.schemas = new ArrayList<Schema>(this.getMeta0().getSchemas());
        }
        return this.schemas;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Schema schema : this.getSchemasFromMeta()) {
            for (Sequence<?> sequence : schema.getSequences()) {
                SchemaDefinition sd = this.getSchema(schema.getName());
                DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this, sd, sequence.getDataType().getTypeName());
                result.add(new DefaultSequenceDefinition(sd, sequence.getName(), type));
            }
        }
        result.sort(COMP);
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Schema schema : this.getSchemasFromMeta()) {
            SchemaDefinition sd = this.getSchema(schema.getName());
            if (sd == null) continue;
            for (Table<?> table : schema.getTables()) {
                result.add(new DefaultMetaTableDefinition(sd, table));
            }
        }
        result.sort(COMP);
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<DomainDefinition> getDomains0() throws SQLException {
        ArrayList<DomainDefinition> result = new ArrayList<DomainDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }
}

