/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Param;
import org.jooq.SQLDialect;
import org.jooq.SortField;
import org.jooq.SortOrder;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.QOM;
import org.jooq.impl.SimpleQueryPart;
import org.jooq.impl.Tools;

final class SortFieldImpl<T>
extends AbstractQueryPart
implements SortField<T>,
SimpleQueryPart {
    private static final Set<SQLDialect> NO_SUPPORT_NULLS = SQLDialect.supportedUntil(SQLDialect.CUBRID, SQLDialect.MARIADB, SQLDialect.MYSQL);
    final Field<T> field;
    final SortOrder order;
    QOM.NullOrdering nullOrdering;

    SortFieldImpl(Field<T> field, SortOrder order) {
        this.field = field;
        this.order = order;
    }

    @Override
    public boolean isSimple(Context<?> ctx) {
        return this.nullOrdering == null && Tools.isSimple(ctx, this.field);
    }

    @Override
    public final String getName() {
        return this.field.getName();
    }

    @Override
    public final SortOrder getOrder() {
        return this.order;
    }

    final Field<T> getField() {
        return this.field;
    }

    final <U> SortField<U> transform(Field<U> newField) {
        if (newField == this.field) {
            return this;
        }
        SortField<U> r2 = newField.sort(this.order);
        return this.nullOrdering == QOM.NullOrdering.NULLS_FIRST ? r2.nullsFirst() : (this.nullOrdering == QOM.NullOrdering.NULLS_LAST ? r2.nullsLast() : r2);
    }

    @Override
    public final SortField<T> nullsFirst() {
        this.nullOrdering = QOM.NullOrdering.NULLS_FIRST;
        return this;
    }

    @Override
    public final SortField<T> nullsLast() {
        this.nullOrdering = QOM.NullOrdering.NULLS_LAST;
        return this;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.nullOrdering != null) {
            if (NO_SUPPORT_NULLS.contains((Object)ctx.dialect())) {
                Param<Integer> ifNull = this.nullOrdering == QOM.NullOrdering.NULLS_FIRST ? DSL.zero() : DSL.one();
                Param<Integer> ifNotNull = this.nullOrdering == QOM.NullOrdering.NULLS_FIRST ? DSL.one() : DSL.zero();
                ctx.visit(DSL.nvl2(this.field, ifNotNull, ifNull)).sql(", ");
                this.acceptFieldAndOrder(ctx, false);
            } else {
                this.acceptFieldAndOrder(ctx, true);
            }
        } else {
            this.acceptFieldAndOrder(ctx, false);
        }
    }

    private final void acceptFieldAndOrder(Context<?> ctx, boolean includeNulls) {
        String separator = "";
        for (Field<T> f2 : Tools.flatten(this.field)) {
            ctx.sql(separator).visit(f2);
            if (this.order != SortOrder.DEFAULT) {
                ctx.sql(' ').visit(this.order.toKeyword());
            }
            if (includeNulls) {
                if (this.nullOrdering == QOM.NullOrdering.NULLS_FIRST) {
                    ctx.sql(' ').visit(Keywords.K_NULLS_FIRST);
                } else {
                    ctx.sql(' ').visit(Keywords.K_NULLS_LAST);
                }
            }
            separator = ", ";
        }
    }

    @Override
    public final Field<T> $field() {
        return this.field;
    }

    @Override
    public final SortOrder $sortOrder() {
        return this.order;
    }

    @Override
    public final QOM.NullOrdering $nullOrdering() {
        return this.nullOrdering;
    }
}

