/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.jooq.Clause;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.GroupField;
import org.jooq.JoinType;
import org.jooq.Name;
import org.jooq.Operator;
import org.jooq.OrderField;
import org.jooq.Param;
import org.jooq.QualifiedAsterisk;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Row;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectLimitPercentStep;
import org.jooq.SelectOffsetStep;
import org.jooq.SelectQuery;
import org.jooq.SelectSeekStepN;
import org.jooq.SelectWithTiesStep;
import org.jooq.SortField;
import org.jooq.SortOrder;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableOnConditionStep;
import org.jooq.TableOptionalOnStep;
import org.jooq.TablePartitionByStep;
import org.jooq.WindowDefinition;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.AbstractContext;
import org.jooq.impl.AbstractField;
import org.jooq.impl.AbstractResultQuery;
import org.jooq.impl.AsteriskImpl;
import org.jooq.impl.CombineOperator;
import org.jooq.impl.CommonTableExpressionList;
import org.jooq.impl.ConditionProviderImpl;
import org.jooq.impl.Convert;
import org.jooq.impl.CustomField;
import org.jooq.impl.DSL;
import org.jooq.impl.DerivedTable;
import org.jooq.impl.FieldsImpl;
import org.jooq.impl.ForLock;
import org.jooq.impl.GroupFieldList;
import org.jooq.impl.InlineDerivedTable;
import org.jooq.impl.JoinTable;
import org.jooq.impl.Keywords;
import org.jooq.impl.LazyName;
import org.jooq.impl.Limit;
import org.jooq.impl.MetaDataFieldProvider;
import org.jooq.impl.QOM;
import org.jooq.impl.QualifiedAsteriskImpl;
import org.jooq.impl.QualifiedSelectFieldList;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.QueryPartListView;
import org.jooq.impl.RowField;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.ScalarSubquery;
import org.jooq.impl.SelectFieldList;
import org.jooq.impl.SelectImpl;
import org.jooq.impl.SortFieldImpl;
import org.jooq.impl.SortFieldList;
import org.jooq.impl.TableImpl;
import org.jooq.impl.TableList;
import org.jooq.impl.Tools;
import org.jooq.impl.TopLevelCte;
import org.jooq.impl.Transformations;
import org.jooq.impl.Val;
import org.jooq.impl.WindowList;
import org.jooq.impl.WithImpl;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;

final class SelectQueryImpl<R extends Record>
extends AbstractResultQuery<R>
implements SelectQuery<R> {
    private static final JooqLogger log = JooqLogger.getLogger(SelectQueryImpl.class);
    private static final Clause[] CLAUSES = new Clause[]{Clause.SELECT};
    static final Set<SQLDialect> EMULATE_SELECT_INTO_AS_CTAS = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.YUGABYTEDB);
    private static final Set<SQLDialect> SUPPORT_SELECT_INTO_TABLE = SQLDialect.supportedBy(SQLDialect.HSQLDB, SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> NO_SUPPORT_WINDOW_CLAUSE = SQLDialect.supportedUntil(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.HSQLDB, SQLDialect.IGNITE, SQLDialect.MARIADB);
    private static final Set<SQLDialect> OPTIONAL_FROM_CLAUSE = SQLDialect.supportedBy(SQLDialect.DEFAULT, SQLDialect.H2, SQLDialect.IGNITE, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.YUGABYTEDB);
    private static final Set<SQLDialect> REQUIRES_DERIVED_TABLE_DML = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private static final Set<SQLDialect> NO_IMPLICIT_GROUP_BY_ON_HAVING = SQLDialect.supportedBy(SQLDialect.SQLITE);
    private static final Set<SQLDialect> SUPPORT_FULL_WITH_TIES = SQLDialect.supportedBy(SQLDialect.H2, SQLDialect.MARIADB, SQLDialect.POSTGRES);
    private static final Set<SQLDialect> EMULATE_DISTINCT_ON = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE);
    static final Set<SQLDialect> NO_SUPPORT_FOR_UPDATE_OF_FIELDS = SQLDialect.supportedBy(SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    final WithImpl with;
    private final SelectFieldList<SelectFieldOrAsterisk> select;
    private Table<?> intoTable;
    private String hint;
    private String option;
    private boolean distinct;
    private QueryPartList<SelectFieldOrAsterisk> distinctOn;
    private ForLock forLock;
    private final TableList from;
    private final ConditionProviderImpl condition;
    private boolean grouping;
    private GroupFieldList groupBy;
    private boolean groupByDistinct;
    private final ConditionProviderImpl having;
    private WindowList window;
    private final ConditionProviderImpl qualify;
    private final SortFieldList orderBy;
    private final QueryPartList<Field<?>> seek;
    private boolean seekBefore;
    private final Limit limit;
    private final List<CombineOperator> unionOp;
    private final List<QueryPartList<Select<?>>> union;
    private final SortFieldList unionOrderBy;
    private final QueryPartList<Field<?>> unionSeek;
    private boolean unionSeekBefore;
    private final Limit unionLimit;
    private final Map<QueryPart, QueryPart> localQueryPartMapping;
    private static final Set<SQLDialect> NO_SUPPORT_UNION_PARENTHESES = SQLDialect.supportedBy(SQLDialect.SQLITE);
    private static final Set<SQLDialect> NO_SUPPORT_CTE_IN_UNION = SQLDialect.supportedBy(SQLDialect.HSQLDB, SQLDialect.MARIADB);
    private static final Set<SQLDialect> UNION_PARENTHESIS = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.MARIADB, SQLDialect.MYSQL);

    SelectQueryImpl(Configuration configuration, WithImpl with) {
        this(configuration, with, null);
    }

    SelectQueryImpl(Configuration configuration, WithImpl with, boolean distinct) {
        this(configuration, with, null, distinct);
    }

    SelectQueryImpl(Configuration configuration, WithImpl with, TableLike<? extends R> from) {
        this(configuration, with, from, false);
    }

    SelectQueryImpl(Configuration configuration, WithImpl with, TableLike<? extends R> from, boolean distinct) {
        super(configuration);
        this.with = with;
        this.distinct = distinct;
        this.select = new SelectFieldList();
        this.from = new TableList();
        this.condition = new ConditionProviderImpl();
        this.having = new ConditionProviderImpl();
        this.qualify = new ConditionProviderImpl();
        this.orderBy = new SortFieldList();
        this.seek = new QueryPartList();
        this.limit = new Limit();
        this.unionOp = new ArrayList<CombineOperator>();
        this.union = new ArrayList();
        this.unionOrderBy = new SortFieldList();
        this.unionSeek = new QueryPartList();
        this.unionLimit = new Limit();
        if (from != null) {
            this.from.add(from.asTable());
        }
        this.localQueryPartMapping = new LinkedHashMap<QueryPart, QueryPart>();
    }

    private final SelectQueryImpl<R> copyTo(CopyClause clause, boolean scalarSelect, SelectQueryImpl<R> result) {
        return this.copyBetween(CopyClause.START, clause, scalarSelect, result);
    }

    private final SelectQueryImpl<R> copyAfter(CopyClause clause, boolean scalarSelect, SelectQueryImpl<R> result) {
        return this.copyBetween(clause, CopyClause.END, scalarSelect, result);
    }

    private final SelectQueryImpl<R> copyBetween(CopyClause start, CopyClause end, boolean scalarSelect, SelectQueryImpl<R> result) {
        if (CopyClause.START.between(start, end)) {
            result.from.addAll(this.from);
            result.condition.setWhere(this.condition.getWhere());
            if (scalarSelect) {
                result.select.addAll(this.select);
            }
        }
        if (CopyClause.WHERE.between(start, end)) {
            result.grouping = this.grouping;
            result.groupBy = this.groupBy;
            result.groupByDistinct = this.groupByDistinct;
            result.having.setWhere(this.having.getWhere());
            if (this.window != null) {
                result.addWindow(this.window);
            }
            result.qualify.setWhere(this.qualify.getWhere());
        }
        if (CopyClause.QUALIFY.between(start, end)) {
            if (!scalarSelect) {
                result.select.addAll(this.select);
            }
            result.hint = this.hint;
            result.distinct = this.distinct;
            result.distinctOn = this.distinctOn;
            result.orderBy.addAll(this.orderBy);
            result.seek.addAll((Collection<Field<?>>)this.seek);
            result.limit.from(this.limit);
            result.forLock = this.forLock;
            result.option = this.option;
            result.intoTable = this.intoTable;
            result.union.addAll(this.union);
            result.unionOp.addAll(this.unionOp);
            result.unionOrderBy.addAll(this.unionOrderBy);
            result.unionSeek.addAll((Collection<Field<?>>)this.unionSeek);
            result.unionSeekBefore = this.unionSeekBefore;
            result.unionLimit.from(this.unionLimit);
        }
        return result;
    }

    private final SelectQueryImpl<R> copy(Consumer<? super SelectQueryImpl<R>> finisher) {
        SelectQueryImpl<R> result = this.copyTo(CopyClause.END, false, new SelectQueryImpl<R>(this.configuration(), this.with));
        finisher.accept(result);
        return result;
    }

    @Override
    public final <T> Field<T> asField() {
        return new ScalarSubquery(this, Tools.scalarType(this));
    }

    @Override
    public final <T> Field<T> asField(String alias) {
        return this.asField().as(alias);
    }

    @Override
    public <T> Field<T> asField(Function<? super Field<T>, ? extends String> aliasFunction) {
        return this.asField().as(aliasFunction);
    }

    @Override
    public final Row fieldsRow() {
        return this.asTable().fieldsRow();
    }

    @Override
    public final Table<R> asTable() {
        return new DerivedTable(this).as(new LazyName(() -> DSL.name(Tools.autoAlias(this))));
    }

    @Override
    public final Table<R> asTable(String alias) {
        return new DerivedTable(this).as(alias);
    }

    @Override
    public final Table<R> asTable(String alias, String ... fieldAliases) {
        return new DerivedTable(this).as(alias, fieldAliases);
    }

    @Override
    public final Table<R> asTable(Name alias) {
        return new DerivedTable(this).as(alias);
    }

    @Override
    public final Table<R> asTable(Name alias, Name ... fieldAliases) {
        return new DerivedTable(this).as(alias, fieldAliases);
    }

    @Override
    public final Table<R> asTable(Table<?> alias) {
        return new DerivedTable(this).as(alias);
    }

    @Override
    public final Table<R> asTable(Table<?> alias, Field<?> ... fieldAliases) {
        return new DerivedTable(this).as(alias, fieldAliases);
    }

    @Override
    public final Table<R> asTable(String alias, Function<? super Field<?>, ? extends String> aliasFunction) {
        return new DerivedTable(this).as(alias, aliasFunction);
    }

    @Override
    public final Table<R> asTable(String alias, BiFunction<? super Field<?>, ? super Integer, ? extends String> aliasFunction) {
        return new DerivedTable(this).as(alias, aliasFunction);
    }

    @Override
    public final Field<?>[] getFields(ResultSetMetaData meta) {
        Field<?>[] fields2 = this.getFields();
        if (fields2.length == 0) {
            return new MetaDataFieldProvider(this.configuration(), meta).getFields();
        }
        return fields2;
    }

    @Override
    public final Field<?>[] getFields() {
        Collection<Field<?>> fields2 = this.coerce();
        if (fields2 == null || fields2.isEmpty()) {
            fields2 = this.getSelect();
        }
        return Tools.fieldArray(fields2);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    private final Select<?> distinctOnEmulation() {
        ArrayList<Field> partitionBy = new ArrayList<Field>(this.distinctOn.size());
        for (SelectFieldOrAsterisk s2 : this.distinctOn) {
            if (!(s2 instanceof Field)) continue;
            partitionBy.add((Field)s2);
        }
        Field<Integer> rn = DSL.rowNumber().over(DSL.partitionBy(partitionBy).orderBy(this.orderBy)).as("rn");
        SelectQueryImpl<R> copy = this.copy(x2 -> {});
        copy.distinctOn = null;
        copy.select.add(rn);
        copy.orderBy.clear();
        copy.limit.clear();
        SelectSeekStepN s1 = DSL.select(new QualifiedSelectFieldList(DSL.table(DSL.name("t")), (Iterable<SelectFieldOrAsterisk>)this.select)).from((TableLike<?>)copy.asTable("t")).where(rn.eq(DSL.one())).orderBy(Tools.map(this.orderBy, o2 -> Tools.unqualified(o2)));
        if (this.limit.numberOfRows != null) {
            SelectLimitPercentStep s2 = s1.limit(this.limit.numberOfRows);
            SelectWithTiesStep s3 = this.limit.percent ? s2.percent() : s2;
            SelectOffsetStep s4 = this.limit.withTies ? s3.withTies() : s3;
            return this.limit.offset != null ? s4.offset(this.limit.offset) : s4;
        }
        return this.limit.offset != null ? s1.offset(this.limit.offset) : s1;
    }

    @Override
    public final void accept(Context<?> ctx) {
        Table dmlTable;
        if (ctx.subqueryLevel() == 1 && REQUIRES_DERIVED_TABLE_DML.contains((Object)ctx.dialect()) && !Boolean.TRUE.equals(ctx.data((Object)Tools.BooleanDataKey.DATA_INSERT_SELECT)) && (dmlTable = (Table)ctx.data((Object)Tools.DataKey.DATA_DML_TARGET_TABLE)) != null && Tools.containsUnaliasedTable(this.getFrom(), dmlTable)) {
            ctx.visit(DSL.select(DSL.asterisk()).from((TableLike<?>)this.asTable("t")));
        } else if (Tools.isNotEmpty(this.distinctOn) && EMULATE_DISTINCT_ON.contains((Object)ctx.dialect())) {
            ctx.visit(this.distinctOnEmulation());
        } else if (!this.qualify.hasWhere() || !Transformations.transformQualify(ctx.configuration())) {
            this.accept0(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void accept0(Context<?> context) {
        boolean topLevelCte = false;
        if (context.subqueryLevel() == 0) {
            context.scopeStart();
            if (topLevelCte |= context.data((Object)Tools.DataKey.DATA_TOP_LEVEL_CTE) == null) {
                context.data((Object)Tools.DataKey.DATA_TOP_LEVEL_CTE, new TopLevelCte());
            }
        }
        SQLDialect dialect = context.dialect();
        Object renderTrailingLimit = context.data((Object)Tools.BooleanDataKey.DATA_RENDER_TRAILING_LIMIT_IF_APPLICABLE);
        Object localWindowDefinitions = context.data((Object)Tools.DataKey.DATA_WINDOW_DEFINITIONS);
        Name[] selectAliases = (Name[])context.data((Object)Tools.DataKey.DATA_SELECT_ALIASES);
        try {
            List<Field<?>> originalFields = null;
            List<Field<?>> alternativeFields = null;
            if (selectAliases != null) {
                context.data().remove((Object)Tools.DataKey.DATA_SELECT_ALIASES);
                originalFields = this.getSelect();
                alternativeFields = Tools.map(originalFields, (f2, i2) -> i2 < selectAliases.length ? f2.as(selectAliases[i2]) : f2);
            }
            if (Boolean.TRUE.equals(renderTrailingLimit)) {
                context.data().remove((Object)Tools.BooleanDataKey.DATA_RENDER_TRAILING_LIMIT_IF_APPLICABLE);
            }
            if (localWindowDefinitions != null) {
                context.data((Object)Tools.DataKey.DATA_WINDOW_DEFINITIONS, null);
            }
            if (this.intoTable != null && !Boolean.TRUE.equals(context.data((Object)Tools.BooleanDataKey.DATA_OMIT_INTO_CLAUSE)) && EMULATE_SELECT_INTO_AS_CTAS.contains((Object)dialect)) {
                context.data((Object)Tools.BooleanDataKey.DATA_OMIT_INTO_CLAUSE, true, c2 -> c2.visit(DSL.createTable(this.intoTable).as(this)));
                return;
            }
            if (this.with != null) {
                context.visit(this.with);
            } else if (topLevelCte) {
                CommonTableExpressionList.markTopLevelCteAndAccept(context, c2 -> {});
            }
            this.pushWindow(context);
            Boolean wrapDerivedTables = (Boolean)context.data((Object)Tools.BooleanDataKey.DATA_WRAP_DERIVED_TABLES_IN_PARENTHESES);
            if (Boolean.TRUE.equals(wrapDerivedTables)) {
                context.sqlIndentStart('(').data().remove((Object)Tools.BooleanDataKey.DATA_WRAP_DERIVED_TABLES_IN_PARENTHESES);
            }
            switch (dialect) {
                case CUBRID: 
                case FIREBIRD: 
                case MYSQL: 
                case YUGABYTEDB: {
                    if (this.getLimit().isApplicable() && this.getLimit().withTies()) {
                        this.toSQLReferenceLimitWithWindowFunctions(context);
                        break;
                    }
                    this.toSQLReferenceLimitDefault(context, originalFields, alternativeFields);
                    break;
                }
                default: {
                    this.toSQLReferenceLimitDefault(context, originalFields, alternativeFields);
                }
            }
            if (this.forLock != null) {
                context.visit(this.forLock);
            }
            if (!StringUtils.isBlank(this.option)) {
                context.formatSeparator().sql(this.option);
            }
            if (Boolean.TRUE.equals(wrapDerivedTables)) {
                context.sqlIndentEnd(')').data((Object)Tools.BooleanDataKey.DATA_WRAP_DERIVED_TABLES_IN_PARENTHESES, true);
            }
        }
        finally {
            context.data((Object)Tools.DataKey.DATA_WINDOW_DEFINITIONS, localWindowDefinitions);
            if (renderTrailingLimit != null) {
                context.data((Object)Tools.BooleanDataKey.DATA_RENDER_TRAILING_LIMIT_IF_APPLICABLE, renderTrailingLimit);
            }
            if (selectAliases != null) {
                context.data((Object)Tools.DataKey.DATA_SELECT_ALIASES, selectAliases);
            }
        }
        if (context.subqueryLevel() == 0) {
            context.scopeEnd();
        }
    }

    private final void pushWindow(Context<?> context) {
        if (Tools.isNotEmpty(this.window)) {
            context.data((Object)Tools.DataKey.DATA_WINDOW_DEFINITIONS, this.window);
        }
    }

    private final void toSQLReferenceLimitDefault(Context<?> context, List<Field<?>> originalFields, List<Field<?>> alternativeFields) {
        context.data((Object)Tools.BooleanDataKey.DATA_RENDER_TRAILING_LIMIT_IF_APPLICABLE, true, c2 -> this.toSQLReference0(context, originalFields, alternativeFields));
    }

    private final void toSQLReferenceLimitWithWindowFunctions(Context<?> ctx) {
        List<Field<?>> originalFields = this.getSelect();
        ArrayList alternativeFields = new ArrayList(originalFields.size());
        if (originalFields.isEmpty()) {
            alternativeFields.add(DSL.field("*"));
        } else {
            alternativeFields.addAll(Tools.aliasedFields(originalFields));
        }
        alternativeFields.add(CustomField.of("rn", SQLDataType.INTEGER, c2 -> {
            boolean wrapQueryExpressionBodyInDerivedTable = this.wrapQueryExpressionBodyInDerivedTable((Context<?>)c2);
            c2.data((Object)Tools.BooleanDataKey.DATA_UNALIAS_ALIASED_EXPRESSIONS, !wrapQueryExpressionBodyInDerivedTable);
            boolean q2 = c2.qualify();
            c2.data((Object)Tools.DataKey.DATA_OVERRIDE_ALIASES_IN_ORDER_BY, new Object[]{originalFields, alternativeFields});
            if (wrapQueryExpressionBodyInDerivedTable) {
                c2.qualify(false);
            }
            c2.visit(this.distinct ? DSL.denseRank().over(DSL.orderBy(this.getNonEmptyOrderByForDistinct(c2.configuration()))) : (this.getLimit().withTies() ? DSL.rank().over(DSL.orderBy(this.getNonEmptyOrderBy(c2.configuration()))) : DSL.rowNumber().over(DSL.orderBy(this.getNonEmptyOrderBy(c2.configuration())))));
            c2.data().remove((Object)Tools.BooleanDataKey.DATA_UNALIAS_ALIASED_EXPRESSIONS);
            c2.data().remove((Object)Tools.DataKey.DATA_OVERRIDE_ALIASES_IN_ORDER_BY);
            if (wrapQueryExpressionBodyInDerivedTable) {
                c2.qualify(q2);
            }
        }).as("rn"));
        List<Field<?>> unaliasedFields = Tools.unaliasedFields(originalFields);
        ctx.visit(Keywords.K_SELECT).separatorRequired(true).declareFields(true, c2 -> c2.visit(new SelectFieldList(unaliasedFields))).formatSeparator().visit(Keywords.K_FROM).sqlIndentStart(" (").subquery(true);
        this.toSQLReference0(ctx, originalFields, alternativeFields);
        ctx.subquery(false).sqlIndentEnd(") ").visit(DSL.name("x")).formatSeparator().visit(Keywords.K_WHERE).sql(' ').visit(DSL.name("rn")).sql(" > ").visit(this.getLimit().getLowerRownum());
        if (!this.getLimit().limitZero()) {
            ctx.formatSeparator().visit(Keywords.K_AND).sql(' ').visit(DSL.name("rn")).sql(" <= ").visit(this.getLimit().getUpperRownum());
        }
        if (!(ctx.subquery() || this.getOrderBy().isEmpty() || Boolean.FALSE.equals(ctx.settings().isRenderOrderByRownumberForEmulatedPagination()))) {
            ctx.formatSeparator().visit(Keywords.K_ORDER_BY).sql(' ').visit(DSL.name("rn"));
        }
    }

    private final void toSQLReference0(Context<?> context, List<Field<?>> originalFields, List<Field<?>> alternativeFields) {
        boolean wrapQueryExpressionBodyInDerivedTable;
        SQLDialect family = context.family();
        boolean qualify = context.qualify();
        int unionOpSize = this.unionOp.size();
        boolean unionParensRequired = false;
        boolean unionOpNesting = false;
        boolean applySeekOnDerivedTable = this.applySeekOnDerivedTable();
        boolean wrapQueryExpressionInDerivedTable = false;
        if (wrapQueryExpressionInDerivedTable) {
            context.visit(Keywords.K_SELECT).sql(" *").formatSeparator().visit(Keywords.K_FROM).sql(" (").formatIndentStart().formatNewLine();
        }
        if (wrapQueryExpressionBodyInDerivedTable = applySeekOnDerivedTable) {
            context.visit(Keywords.K_SELECT).sql(' ');
            context.formatIndentStart().formatNewLine().sql("t.*");
            if (alternativeFields != null && originalFields.size() < alternativeFields.size()) {
                context.sql(", ").formatSeparator().declareFields(true, c2 -> c2.visit((QueryPart)alternativeFields.get(alternativeFields.size() - 1)));
            }
            context.formatIndentEnd().formatSeparator().visit(Keywords.K_FROM).sql(" (").formatIndentStart().formatNewLine();
        }
        if (unionOpSize > 0) {
            if (!Boolean.TRUE.equals(context.data((Object)Tools.BooleanDataKey.DATA_NESTED_SET_OPERATIONS))) {
                unionOpNesting = this.unionOpNesting();
                context.data((Object)Tools.BooleanDataKey.DATA_NESTED_SET_OPERATIONS, unionOpNesting);
            }
            for (int i2 = unionOpSize - 1; i2 >= 0; --i2) {
                switch (this.unionOp.get(i2)) {
                    case EXCEPT: {
                        context.start(Clause.SELECT_EXCEPT);
                        break;
                    }
                    case EXCEPT_ALL: {
                        context.start(Clause.SELECT_EXCEPT_ALL);
                        break;
                    }
                    case INTERSECT: {
                        context.start(Clause.SELECT_INTERSECT);
                        break;
                    }
                    case INTERSECT_ALL: {
                        context.start(Clause.SELECT_INTERSECT_ALL);
                        break;
                    }
                    case UNION: {
                        context.start(Clause.SELECT_UNION);
                        break;
                    }
                    case UNION_ALL: {
                        context.start(Clause.SELECT_UNION_ALL);
                    }
                }
                unionParensRequired = unionOpNesting || this.unionParensRequired(context);
                this.unionParenthesis(context, '(', alternativeFields != null ? alternativeFields : this.getSelect(), this.derivedTableRequired(context, this), unionParensRequired);
            }
        }
        Tools.traverseJoins(this.getFrom(), t2 -> {
            if (t2 instanceof TableImpl) {
                context.scopeRegister((QueryPart)t2, true);
            }
        });
        for (Map.Entry<QueryPart, QueryPart> entry : this.localQueryPartMapping.entrySet()) {
            context.scopeRegister(entry.getKey(), true, entry.getValue());
        }
        context.start(Clause.SELECT_SELECT).visit(Keywords.K_SELECT).separatorRequired(true);
        if (!StringUtils.isBlank(this.hint)) {
            context.sql(' ').sql(this.hint).separatorRequired(true);
        }
        if (Tools.isNotEmpty(this.distinctOn)) {
            context.visit(Keywords.K_DISTINCT_ON).sql(" (").visit(this.distinctOn).sql(')').separatorRequired(true);
        } else if (this.distinct) {
            context.visit(Keywords.K_DISTINCT).separatorRequired(true);
        }
        if (Boolean.TRUE.equals(context.data((Object)Tools.BooleanDataKey.DATA_RENDERING_DATA_CHANGE_DELTA_TABLE))) {
            context.qualify(false);
        }
        context.declareFields(true);
        if (alternativeFields != null) {
            if (wrapQueryExpressionBodyInDerivedTable && originalFields.size() < alternativeFields.size()) {
                context.visit(new SelectFieldList((Iterable<Field<?>>)alternativeFields.subList(0, originalFields.size())));
            } else {
                context.visit(new SelectFieldList((Iterable<Field<?>>)alternativeFields));
            }
        } else {
            context.visit(this.getSelectResolveUnsupportedAsterisks(context.configuration()));
        }
        if (Boolean.TRUE.equals(context.data((Object)Tools.BooleanDataKey.DATA_RENDERING_DATA_CHANGE_DELTA_TABLE))) {
            context.qualify(qualify);
        }
        context.declareFields(false).end(Clause.SELECT_SELECT);
        if (!context.subquery()) {
            context.start(Clause.SELECT_INTO);
            Table<?> actualIntoTable = (Table<?>)context.data((Object)Tools.DataKey.DATA_SELECT_INTO_TABLE);
            if (actualIntoTable == null) {
                actualIntoTable = this.intoTable;
            }
            if (!(actualIntoTable == null || Boolean.TRUE.equals(context.data((Object)Tools.BooleanDataKey.DATA_OMIT_INTO_CLAUSE)) || !SUPPORT_SELECT_INTO_TABLE.contains((Object)context.dialect()) && actualIntoTable instanceof Table)) {
                context.formatSeparator().visit(Keywords.K_INTO).sql(' ').visit(actualIntoTable);
            }
            context.end(Clause.SELECT_INTO);
        }
        context.start(Clause.SELECT_FROM).declareTables(true);
        boolean hasFrom = !this.getFrom().isEmpty() || !OPTIONAL_FROM_CLAUSE.contains((Object)context.dialect());
        List semiAntiJoinPredicates = null;
        ConditionProviderImpl where = this.getWhere(context);
        if (hasFrom) {
            Object previousCollect = context.data((Object)Tools.BooleanDataKey.DATA_COLLECT_SEMI_ANTI_JOIN, true);
            Object previousCollected = context.data((Object)Tools.DataKey.DATA_COLLECTED_SEMI_ANTI_JOIN, null);
            TableList tablelist = this.getFrom();
            tablelist = this.transformInlineDerivedTables(tablelist, where);
            context.formatSeparator().visit(Keywords.K_FROM).separatorRequired(true).visit(tablelist);
            semiAntiJoinPredicates = (List)context.data((Object)Tools.DataKey.DATA_COLLECTED_SEMI_ANTI_JOIN, previousCollected);
            context.data((Object)Tools.BooleanDataKey.DATA_COLLECT_SEMI_ANTI_JOIN, previousCollect);
        }
        context.declareTables(false).end(Clause.SELECT_FROM);
        context.start(Clause.SELECT_WHERE);
        if (Boolean.TRUE.equals(context.data().get((Object)Tools.BooleanDataKey.DATA_SELECT_NO_DATA))) {
            context.formatSeparator().visit(Keywords.K_WHERE).sql(' ').visit(DSL.falseCondition());
        } else if (where.hasWhere() || semiAntiJoinPredicates != null || Boolean.TRUE.equals(context.data().get((Object)Tools.BooleanDataKey.DATA_MANDATORY_WHERE_CLAUSE))) {
            ConditionProviderImpl actual = new ConditionProviderImpl();
            if (semiAntiJoinPredicates != null) {
                actual.addConditions(semiAntiJoinPredicates);
            }
            if (where.hasWhere()) {
                actual.addConditions(where.getWhere());
            }
            context.formatSeparator().visit(Keywords.K_WHERE).sql(' ').visit(actual);
        }
        context.end(Clause.SELECT_WHERE);
        context.start(Clause.SELECT_GROUP_BY);
        if (this.grouping || this.getHaving().hasWhere() && NO_IMPLICIT_GROUP_BY_ON_HAVING.contains((Object)context.dialect())) {
            context.formatSeparator().visit(Keywords.K_GROUP_BY);
            if (this.groupByDistinct) {
                context.sql(' ').visit(Keywords.K_DISTINCT);
            }
            context.separatorRequired(true);
            context.visit(this.groupBy != null ? this.groupBy : new GroupFieldList());
        }
        context.end(Clause.SELECT_GROUP_BY);
        context.start(Clause.SELECT_HAVING);
        if (this.getHaving().hasWhere()) {
            context.formatSeparator().visit(Keywords.K_HAVING).sql(' ').visit(this.getHaving());
        }
        context.end(Clause.SELECT_HAVING);
        context.start(Clause.SELECT_WINDOW);
        if (Tools.isNotEmpty(this.window) && !NO_SUPPORT_WINDOW_CLAUSE.contains((Object)context.dialect())) {
            context.formatSeparator().visit(Keywords.K_WINDOW).separatorRequired(true).declareWindows(true, c2 -> c2.visit(this.window));
        }
        context.end(Clause.SELECT_WINDOW);
        if (this.getQualify().hasWhere()) {
            context.formatSeparator().visit(Keywords.K_QUALIFY).sql(' ').visit(this.getQualify());
        }
        this.toSQLOrderBy(context, originalFields, alternativeFields, false, wrapQueryExpressionBodyInDerivedTable, this.orderBy, this.limit);
        if (unionOpSize > 0) {
            this.unionParenthesis(context, ')', null, this.derivedTableRequired(context, this), unionParensRequired);
            block18: for (int i3 = 0; i3 < unionOpSize; ++i3) {
                CombineOperator op2 = this.unionOp.get(i3);
                for (Select select : this.union.get(i3)) {
                    boolean derivedTableRequired = this.derivedTableRequired(context, select);
                    boolean otherUnionParensRequired = unionParensRequired || this.unionOpNesting();
                    context.formatSeparator().visit(op2.toKeyword(family));
                    if (otherUnionParensRequired) {
                        context.sql(' ');
                    } else {
                        context.formatSeparator();
                    }
                    this.unionParenthesis(context, '(', select.getSelect(), derivedTableRequired, otherUnionParensRequired);
                    context.visit(select);
                    this.unionParenthesis(context, ')', null, derivedTableRequired, otherUnionParensRequired);
                }
                if (i3 < unionOpSize - 1) {
                    this.unionParenthesis(context, ')', null, this.derivedTableRequired(context, this), unionParensRequired);
                }
                switch (this.unionOp.get(i3)) {
                    case EXCEPT: {
                        context.end(Clause.SELECT_EXCEPT);
                        continue block18;
                    }
                    case EXCEPT_ALL: {
                        context.end(Clause.SELECT_EXCEPT_ALL);
                        continue block18;
                    }
                    case INTERSECT: {
                        context.end(Clause.SELECT_INTERSECT);
                        continue block18;
                    }
                    case INTERSECT_ALL: {
                        context.end(Clause.SELECT_INTERSECT_ALL);
                        continue block18;
                    }
                    case UNION: {
                        context.end(Clause.SELECT_UNION);
                        continue block18;
                    }
                    case UNION_ALL: {
                        context.end(Clause.SELECT_UNION_ALL);
                    }
                }
            }
            if (unionOpNesting) {
                context.data().remove((Object)Tools.BooleanDataKey.DATA_NESTED_SET_OPERATIONS);
            }
        }
        if (wrapQueryExpressionBodyInDerivedTable) {
            context.formatIndentEnd().formatNewLine().sql(") t");
            if (applySeekOnDerivedTable) {
                context.formatSeparator().visit(Keywords.K_WHERE).sql(' ').qualify(false, c2 -> c2.visit(this.getSeekCondition()));
            }
        }
        context.qualify(false, c2 -> this.toSQLOrderBy(context, originalFields, alternativeFields, wrapQueryExpressionInDerivedTable, wrapQueryExpressionBodyInDerivedTable, this.unionOrderBy, this.unionLimit));
    }

    private final boolean hasInlineDerivedTables(TableList tablelist) {
        return Tools.anyMatch(tablelist, t2 -> t2 instanceof InlineDerivedTable || t2 instanceof JoinTable && this.hasInlineDerivedTables((JoinTable)t2));
    }

    private final boolean hasInlineDerivedTables(JoinTable join) {
        return join.lhs instanceof InlineDerivedTable || join.rhs instanceof InlineDerivedTable || join.lhs instanceof JoinTable && this.hasInlineDerivedTables((JoinTable)join.lhs) || join.rhs instanceof JoinTable && this.hasInlineDerivedTables((JoinTable)join.rhs);
    }

    private final TableList transformInlineDerivedTables(TableList tablelist, ConditionProviderImpl where) {
        if (!this.hasInlineDerivedTables(tablelist)) {
            return tablelist;
        }
        TableList result = new TableList();
        for (Table table : tablelist) {
            this.transformInlineDerivedTable0(table, result, where);
        }
        return result;
    }

    private final void transformInlineDerivedTable0(Table<?> table, TableList result, ConditionProviderImpl where) {
        if (table instanceof InlineDerivedTable) {
            InlineDerivedTable t2 = (InlineDerivedTable)table;
            result.add(t2.table());
            where.addConditions(t2.condition());
        } else if (table instanceof JoinTable) {
            result.add(this.transformInlineDerivedTables0(table, where, false));
        } else {
            result.add(table);
        }
    }

    private final Table<?> transformInlineDerivedTables0(Table<?> table, ConditionProviderImpl where, boolean keepDerivedTable) {
        if (table instanceof InlineDerivedTable) {
            InlineDerivedTable t2 = (InlineDerivedTable)table;
            if (keepDerivedTable) {
                return t2.query().asTable(t2.table());
            }
            where.addConditions(t2.condition());
            return t2.table();
        }
        if (table instanceof JoinTable) {
            Table<?> rhs;
            Table<?> lhs;
            JoinTable j2 = (JoinTable)table;
            switch (j2.type) {
                case LEFT_OUTER_JOIN: 
                case LEFT_ANTI_JOIN: 
                case LEFT_SEMI_JOIN: 
                case STRAIGHT_JOIN: 
                case CROSS_APPLY: 
                case OUTER_APPLY: 
                case NATURAL_LEFT_OUTER_JOIN: {
                    lhs = this.transformInlineDerivedTables0(j2.lhs, where, keepDerivedTable);
                    rhs = this.transformInlineDerivedTables0(j2.rhs, where, true);
                    break;
                }
                case RIGHT_OUTER_JOIN: 
                case NATURAL_RIGHT_OUTER_JOIN: {
                    lhs = this.transformInlineDerivedTables0(j2.lhs, where, true);
                    rhs = this.transformInlineDerivedTables0(j2.rhs, where, keepDerivedTable);
                    break;
                }
                case FULL_OUTER_JOIN: 
                case NATURAL_FULL_OUTER_JOIN: {
                    lhs = this.transformInlineDerivedTables0(j2.lhs, where, true);
                    rhs = this.transformInlineDerivedTables0(j2.rhs, where, true);
                    break;
                }
                default: {
                    lhs = this.transformInlineDerivedTables0(j2.lhs, where, keepDerivedTable);
                    rhs = this.transformInlineDerivedTables0(j2.rhs, where, keepDerivedTable);
                }
            }
            return j2.transform(lhs, rhs);
        }
        return table;
    }

    private final void toSQLOrderBy(Context<?> ctx, List<Field<?>> originalFields, List<Field<?>> alternativeFields, boolean wrapQueryExpressionInDerivedTable, boolean wrapQueryExpressionBodyInDerivedTable, QueryPartListView<SortField<?>> actualOrderBy, Limit actualLimit) {
        ctx.start(Clause.SELECT_ORDER_BY);
        if (!(this.getLimit().withTies() && !SUPPORT_FULL_WITH_TIES.contains((Object)ctx.dialect()) || actualOrderBy.isEmpty())) {
            ctx.formatSeparator().visit(Keywords.K_ORDER);
            ctx.sql(' ').visit(Keywords.K_BY).separatorRequired(true);
            if (RowField.NO_NATIVE_SUPPORT.contains((Object)ctx.dialect()) && Tools.findAny(actualOrderBy, s2 -> ((SortFieldImpl)s2).getField() instanceof Val) != null) {
                SelectFieldIndexes s3 = this.getSelectFieldIndexes(ctx);
                if (s3.mapped) {
                    actualOrderBy = new QueryPartListView((List<SortField<?>>)((Object)actualOrderBy)).map(t1 -> {
                        Field in2 = ((SortFieldImpl)t1).getField();
                        if (in2 instanceof Val && in2.getDataType().isNumeric()) {
                            Val val = (Val)in2;
                            int x2 = Convert.convert(val.getValue(), Integer.TYPE) - 1;
                            int mapped = s2.mapping[x2];
                            Val out = s2.projectionSizes[x2] == 1 ? val.copy(mapped + 1) : DSL.field("{0}", DSL.list((QueryPart[])IntStream.range(mapped, mapped + s2.projectionSizes[mapped]).mapToObj(i2 -> val.copy(i2 + 1)).toArray(SelectField[]::new)));
                            return ((SortFieldImpl)t1).transform(out);
                        }
                        return t1;
                    });
                }
            }
            ctx.visit(actualOrderBy);
        }
        ctx.end(Clause.SELECT_ORDER_BY);
        if (wrapQueryExpressionInDerivedTable) {
            ctx.formatIndentEnd().formatNewLine().sql(") x");
        }
        if (Boolean.TRUE.equals(ctx.data((Object)Tools.BooleanDataKey.DATA_RENDER_TRAILING_LIMIT_IF_APPLICABLE))) {
            if (actualLimit.isApplicable()) {
                ctx.visit(actualLimit);
            } else if (!actualOrderBy.isEmpty() && Boolean.TRUE.equals(ctx.data((Object)Tools.BooleanDataKey.DATA_FORCE_LIMIT_WITH_ORDER_BY))) {
                Limit l2 = new Limit();
                l2.setNumberOfRows(Long.MAX_VALUE);
                ctx.visit(l2);
            }
        }
    }

    private final boolean applySeekOnDerivedTable() {
        return !this.getSeek().isEmpty() && !this.getOrderBy().isEmpty() && !this.unionOp.isEmpty();
    }

    private final boolean wrapQueryExpressionBodyInDerivedTable(Context<?> ctx) {
        return true;
    }

    final boolean hasUnions() {
        return !this.unionOp.isEmpty();
    }

    private final boolean unionOpNesting() {
        if (this.unionOp.size() > 1) {
            return true;
        }
        for (QueryPartList<Select<?>> s1 : this.union) {
            for (Select select : s1) {
                SelectQueryImpl s3 = Tools.selectQueryImpl(select);
                if (s3 == null || s3.unionOp.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean derivedTableRequired(Context<?> context, Select<?> s1) {
        SelectQueryImpl s2;
        return NO_SUPPORT_CTE_IN_UNION.contains((Object)context.dialect()) && (s2 = Tools.selectQueryImpl(s1)) != null && s2.with != null;
    }

    private final boolean unionParensRequired(Context<?> context) {
        if (this.unionOp.isEmpty()) {
            return false;
        }
        if (this.unionParensRequired(this) || context.settings().isRenderParenthesisAroundSetOperationQueries().booleanValue()) {
            return true;
        }
        CombineOperator op2 = this.unionOp.get(0);
        if ((op2 == CombineOperator.EXCEPT || op2 == CombineOperator.EXCEPT_ALL) && this.union.get(0).size() > 1) {
            return true;
        }
        for (QueryPartList<Select<?>> s1 : this.union) {
            for (Select select : s1) {
                SelectQueryImpl s3 = Tools.selectQueryImpl(select);
                if (s3 == null || !this.unionParensRequired(s3)) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean unionParensRequired(SelectQueryImpl<?> s2) {
        return s2.orderBy.size() > 0 || s2.limit.isApplicable() || s2.with != null;
    }

    private final void unionParenthesis(Context<?> ctx, char parenthesis, List<Field<?>> fields2, boolean derivedTableRequired, boolean parensRequired) {
        if ('(' == parenthesis) {
            ((AbstractContext)ctx).subquery0(true, true);
        } else if (')' == parenthesis) {
            ((AbstractContext)ctx).subquery0(false, true);
        }
        if ((parensRequired |= (derivedTableRequired |= derivedTableRequired || parensRequired && NO_SUPPORT_UNION_PARENTHESES.contains((Object)ctx.dialect()) || Boolean.TRUE.equals(ctx.data((Object)Tools.BooleanDataKey.DATA_NESTED_SET_OPERATIONS)) && UNION_PARENTHESIS.contains((Object)ctx.dialect()) || Boolean.TRUE.equals(ctx.data((Object)Tools.BooleanDataKey.DATA_INSERT_SELECT_WITHOUT_INSERT_COLUMN_LIST)))) && ')' == parenthesis) {
            ctx.formatIndentEnd().formatNewLine();
        } else if (parensRequired && '(' == parenthesis && derivedTableRequired) {
            ctx.formatNewLine().visit(Keywords.K_SELECT).sql(' ');
            if (ctx.family() == SQLDialect.DERBY) {
                ctx.visit(new SelectFieldList<Field>((Iterable<Field>)Tools.map(fields2, f2 -> Tools.unqualified(f2))));
            } else {
                ctx.sql('*');
            }
            ctx.formatSeparator().visit(Keywords.K_FROM).sql(' ');
        }
        switch (ctx.family()) {
            case FIREBIRD: {
                break;
            }
            default: {
                if (!parensRequired) break;
                ctx.sql(parenthesis);
            }
        }
        if (parensRequired && '(' == parenthesis) {
            ctx.formatIndentStart().formatNewLine();
        } else if (parensRequired && ')' == parenthesis && derivedTableRequired) {
            ctx.sql(" x");
        }
    }

    @Override
    public final void addSelect(Collection<? extends SelectFieldOrAsterisk> fields2) {
        this.getSelectAsSpecified().addAll(fields2);
    }

    @Override
    public final void addSelect(SelectFieldOrAsterisk ... fields2) {
        this.addSelect(Arrays.asList(fields2));
    }

    @Override
    public final void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    @Override
    public final void addDistinctOn(SelectFieldOrAsterisk ... fields2) {
        this.addDistinctOn(Arrays.asList(fields2));
    }

    @Override
    public final void addDistinctOn(Collection<? extends SelectFieldOrAsterisk> fields2) {
        if (this.distinctOn == null) {
            this.distinctOn = new QueryPartList();
        }
        this.distinctOn.addAll((Collection<SelectFieldOrAsterisk>)fields2);
    }

    @Override
    public final void setInto(Table<?> table) {
        this.intoTable = table;
    }

    @Override
    public final void addOffset(int offset) {
        this.addOffset((Number)offset);
    }

    @Override
    public final void addOffset(Number offset) {
        this.getLimit().setOffset(offset);
    }

    @Override
    public final void addOffset(Param<? extends Number> offset) {
        this.getLimit().setOffset(offset);
    }

    @Override
    public final void addLimit(int numberOfRows) {
        this.addLimit((Number)numberOfRows);
    }

    @Override
    public final void addLimit(Number numberOfRows) {
        this.getLimit().setNumberOfRows(numberOfRows);
    }

    @Override
    public final void addLimit(Param<? extends Number> numberOfRows) {
        this.getLimit().setNumberOfRows(numberOfRows);
    }

    @Override
    public final void addLimit(int offset, int numberOfRows) {
        this.addLimit((Number)offset, (Number)numberOfRows);
    }

    @Override
    public final void addLimit(Number offset, Number numberOfRows) {
        this.getLimit().setOffset(offset);
        this.getLimit().setNumberOfRows(numberOfRows);
    }

    @Override
    public final void addLimit(int offset, Param<Integer> numberOfRows) {
        this.addLimit((Number)offset, numberOfRows);
    }

    @Override
    public final void addLimit(Number offset, Param<? extends Number> numberOfRows) {
        this.getLimit().setOffset(offset);
        this.getLimit().setNumberOfRows(numberOfRows);
    }

    @Override
    public final void addLimit(Param<Integer> offset, int numberOfRows) {
        this.addLimit(offset, (Number)numberOfRows);
    }

    @Override
    public final void addLimit(Param<? extends Number> offset, Number numberOfRows) {
        this.getLimit().setOffset(offset);
        this.getLimit().setNumberOfRows(numberOfRows);
    }

    @Override
    public final void addLimit(Param<? extends Number> offset, Param<? extends Number> numberOfRows) {
        this.getLimit().setOffset(offset);
        this.getLimit().setNumberOfRows(numberOfRows);
    }

    @Override
    public final void setLimitPercent(boolean percent) {
        this.getLimit().setPercent(percent);
    }

    @Override
    public final void setWithTies(boolean withTies) {
        this.getLimit().setWithTies(withTies);
    }

    final ForLock forLock() {
        if (this.forLock == null) {
            this.forLock = new ForLock();
        }
        return this.forLock;
    }

    @Override
    public final void setForUpdate(boolean forUpdate) {
        if (forUpdate) {
            this.forLock().forLockMode = ForLock.ForLockMode.UPDATE;
        } else {
            this.forLock = null;
        }
    }

    @Override
    public final void setForNoKeyUpdate(boolean forNoKeyUpdate) {
        if (forNoKeyUpdate) {
            this.forLock().forLockMode = ForLock.ForLockMode.NO_KEY_UPDATE;
        } else {
            this.forLock = null;
        }
    }

    @Override
    public final void setForKeyShare(boolean forKeyShare) {
        if (forKeyShare) {
            this.forLock().forLockMode = ForLock.ForLockMode.KEY_SHARE;
        } else {
            this.forLock = null;
        }
    }

    @Override
    public final void setForUpdateOf(Field<?> ... fields2) {
        this.setForLockModeOf(fields2);
    }

    @Override
    public final void setForUpdateOf(Collection<? extends Field<?>> fields2) {
        this.setForLockModeOf(fields2);
    }

    @Override
    public final void setForUpdateOf(Table<?> ... tables) {
        this.setForLockModeOf(tables);
    }

    @Override
    public final void setForUpdateWait(int seconds) {
        this.setForLockModeWait(seconds);
    }

    @Override
    public final void setForUpdateNoWait() {
        this.setForLockModeNoWait();
    }

    @Override
    public final void setForUpdateSkipLocked() {
        this.setForLockModeSkipLocked();
    }

    @Override
    public final void setForShare(boolean forShare) {
        if (forShare) {
            this.forLock().forLockMode = ForLock.ForLockMode.SHARE;
        } else {
            this.forLock = null;
        }
    }

    @Override
    public final void setForLockModeOf(Field<?> ... fields2) {
        this.setForLockModeOf(Arrays.asList(fields2));
    }

    @Override
    public final void setForLockModeOf(Collection<? extends Field<?>> fields2) {
        this.initLockMode();
        this.forLock().forLockOf = new QueryPartList((Iterable<Field<?>>)fields2);
        this.forLock().forLockOfTables = null;
    }

    @Override
    public final void setForLockModeOf(Table<?> ... tables) {
        this.initLockMode();
        this.forLock().forLockOf = null;
        this.forLock().forLockOfTables = new TableList((List<? extends Table<?>>)Arrays.asList(tables));
    }

    @Override
    public final void setForLockModeWait(int seconds) {
        this.initLockMode();
        this.forLock().forLockWaitMode = ForLock.ForLockWaitMode.WAIT;
        this.forLock().forLockWait = seconds;
    }

    @Override
    public final void setForLockModeNoWait() {
        this.initLockMode();
        this.forLock().forLockWaitMode = ForLock.ForLockWaitMode.NOWAIT;
        this.forLock().forLockWait = 0;
    }

    @Override
    public final void setForLockModeSkipLocked() {
        this.initLockMode();
        this.forLock().forLockWaitMode = ForLock.ForLockWaitMode.SKIP_LOCKED;
        this.forLock().forLockWait = 0;
    }

    private final void initLockMode() {
        this.forLock().forLockMode = this.forLock().forLockMode == null ? ForLock.ForLockMode.UPDATE : this.forLock().forLockMode;
    }

    @Override
    public final List<Field<?>> getSelect() {
        return this.getSelectResolveAllAsterisks(Tools.configuration(this.configuration()));
    }

    private final Collection<? extends Field<?>> subtract(List<Field<?>> left, List<Field<?>> right) {
        FieldsImpl e2 = new FieldsImpl(right);
        ArrayList result = new ArrayList();
        for (Field<?> f2 : left) {
            if (e2.field(f2) != null) continue;
            result.add(f2);
        }
        return result;
    }

    final SelectFieldList<SelectFieldOrAsterisk> getSelectAsSpecified() {
        return this.select;
    }

    final SelectFieldList<SelectFieldOrAsterisk> getSelectResolveImplicitAsterisks() {
        if (this.getSelectAsSpecified().isEmpty()) {
            return this.resolveAsterisk(new SelectFieldList());
        }
        return this.getSelectAsSpecified();
    }

    final SelectFieldList<SelectFieldOrAsterisk> getSelectResolveUnsupportedAsterisks(Configuration c2) {
        return this.getSelectResolveSomeAsterisks0(c2, false);
    }

    final SelectFieldList<Field<?>> getSelectResolveAllAsterisks(Configuration c2) {
        return this.getSelectResolveSomeAsterisks0(c2, true);
    }

    private final SelectFieldList<SelectFieldOrAsterisk> getSelectResolveSomeAsterisks0(Configuration c2, boolean resolveSupported) {
        SelectFieldList<SelectFieldOrAsterisk> result = new SelectFieldList<SelectFieldOrAsterisk>();
        boolean resolveExcept = resolveSupported || !AsteriskImpl.SUPPORT_NATIVE_EXCEPT.contains((Object)c2.dialect());
        boolean resolveUnqualifiedCombined = resolveSupported || AsteriskImpl.NO_SUPPORT_UNQUALIFIED_COMBINED.contains((Object)c2.dialect());
        SelectFieldList<SelectFieldOrAsterisk> list = this.getSelectResolveImplicitAsterisks();
        for (SelectFieldOrAsterisk s2 : list) {
            if (s2 instanceof Field) {
                result.add(this.getResolveProjection(c2, (Field)s2));
                continue;
            }
            if (s2 instanceof QualifiedAsteriskImpl) {
                QualifiedAsteriskImpl q2 = (QualifiedAsteriskImpl)s2;
                if (q2.fields.isEmpty()) {
                    if (resolveSupported) {
                        result.addAll(Arrays.asList(q2.qualifier().fields()));
                        continue;
                    }
                    result.add(s2);
                    continue;
                }
                if (resolveExcept) {
                    result.addAll(this.subtract(Arrays.asList(((QualifiedAsterisk)s2).qualifier().fields()), ((QualifiedAsteriskImpl)s2).fields));
                    continue;
                }
                result.add(s2);
                continue;
            }
            if (s2 instanceof AsteriskImpl) {
                AsteriskImpl a2 = (AsteriskImpl)s2;
                if (a2.fields.isEmpty()) {
                    if (resolveSupported || resolveUnqualifiedCombined && list.size() > 1) {
                        result.addAll(this.resolveAsterisk(new QueryPartList()));
                        continue;
                    }
                    result.add(s2);
                    continue;
                }
                if (resolveExcept) {
                    result.addAll(this.resolveAsterisk(new QueryPartList(), a2.fields));
                    continue;
                }
                result.add(s2);
                continue;
            }
            if (s2 instanceof Row) {
                result.add(this.getResolveProjection(c2, new RowField((Row)((Object)s2))));
                continue;
            }
            throw new AssertionError((Object)("Type not supported: " + s2));
        }
        return result;
    }

    private final Field<?> getResolveProjection(Configuration c2, Field<?> f2) {
        return f2;
    }

    private final <Q extends QueryPartList<? super Field<?>>> Q resolveAsterisk(Q result) {
        return this.resolveAsterisk(result, null);
    }

    private final <Q extends QueryPartList<? super Field<?>>> Q resolveAsterisk(Q result, QueryPartList<Field<?>> except) {
        FieldsImpl e2;
        FieldsImpl fieldsImpl = e2 = except == null ? null : new FieldsImpl(except);
        if (this.knownTableSource()) {
            if (e2 == null) {
                for (TableLike table : this.getFrom()) {
                    for (Field<?> field : table.asTable().fields()) {
                        result.add(field);
                    }
                }
            } else {
                for (TableLike table : this.getFrom()) {
                    for (Field<?> field : table.asTable().fields()) {
                        if (e2.field(field) != null) continue;
                        result.add(field);
                    }
                }
            }
        }
        if (this.getFrom().isEmpty()) {
            result.add(DSL.one());
        }
        return result;
    }

    private final SelectFieldIndexes getSelectFieldIndexes(Context<?> ctx) {
        List<Field<?>> s2 = this.getSelect();
        boolean mapped = false;
        int[] mapping = new int[s2.size()];
        int[] projectionSizes = new int[s2.size()];
        if (RowField.NO_NATIVE_SUPPORT.contains((Object)ctx.dialect())) {
            for (int i2 = 0; i2 < mapping.length; ++i2) {
                projectionSizes[i2] = ((AbstractField)s2.get(i2)).projectionSize();
                mapped |= projectionSizes[i2] > 1;
                if (i2 >= mapping.length - 1) continue;
                mapping[i2 + 1] = mapping[i2] + projectionSizes[i2];
            }
        } else {
            for (int i3 = 0; i3 < mapping.length; ++i3) {
                mapping[i3] = i3;
            }
        }
        return new SelectFieldIndexes(mapped, mapping, projectionSizes);
    }

    private final boolean knownTableSource() {
        return Tools.traverseJoins(this.getFrom(), Boolean.valueOf(true), r2 -> r2 == false, null, j2 -> j2.type != JoinType.LEFT_ANTI_JOIN && j2.type != JoinType.LEFT_SEMI_JOIN, null, (r2, t2) -> r2 != false && t2.fieldsRow().size() > 0);
    }

    @Override
    final Class<? extends R> getRecordType0() {
        if (this.getFrom().size() == 1 && this.getSelectAsSpecified().isEmpty()) {
            return ((Table)this.getFrom().get(0)).asTable().getRecordType();
        }
        return Tools.recordType(this.getSelect().size());
    }

    final TableList getFrom() {
        return this.from;
    }

    final void setGrouping() {
        this.grouping = true;
        if (this.groupBy == null) {
            this.groupBy = new GroupFieldList();
        }
    }

    final ConditionProviderImpl getWhere(Context<?> ctx) {
        ConditionProviderImpl result = new ConditionProviderImpl();
        if (this.condition.hasWhere()) {
            result.addConditions(this.condition.getWhere());
        }
        if (!this.getOrderBy().isEmpty() && !this.getSeek().isEmpty() && this.unionOp.isEmpty()) {
            result.addConditions(this.getSeekCondition());
        }
        return result;
    }

    final Condition getSeekCondition() {
        SortFieldList o2 = this.getOrderBy();
        Condition c2 = null;
        if (o2.nulls()) {
            // empty if block
        }
        if (o2.size() > 1 && o2.uniform()) {
            c2 = ((SortField)o2.get(0)).getOrder() != SortOrder.DESC ^ this.seekBefore ? DSL.row(o2.fields()).gt(DSL.row(this.getSeek())) : DSL.row(o2.fields()).lt(DSL.row(this.getSeek()));
        } else {
            ConditionProviderImpl or2 = new ConditionProviderImpl();
            for (int i2 = 0; i2 < o2.size(); ++i2) {
                ConditionProviderImpl and = new ConditionProviderImpl();
                for (int j2 = 0; j2 < i2; ++j2) {
                    and.addConditions(((SortFieldImpl)o2.get(j2)).getField().eq((Field)this.getSeek().get(j2)));
                }
                SortFieldImpl s2 = (SortFieldImpl)o2.get(i2);
                if (s2.getOrder() != SortOrder.DESC ^ this.seekBefore) {
                    and.addConditions(s2.getField().gt((Field)this.getSeek().get(i2)));
                } else {
                    and.addConditions(s2.getField().lt((Field)this.getSeek().get(i2)));
                }
                or2.addConditions(Operator.OR, (Condition)and);
            }
            c2 = or2;
        }
        return c2;
    }

    final ConditionProviderImpl getHaving() {
        return this.having;
    }

    final ConditionProviderImpl getQualify() {
        return this.qualify;
    }

    final SortFieldList getOrderBy() {
        return this.unionOp.size() == 0 ? this.orderBy : this.unionOrderBy;
    }

    final QueryPartList<Field<?>> getSeek() {
        return this.unionOp.size() == 0 ? this.seek : this.unionSeek;
    }

    final Limit getLimit() {
        return this.unionOp.size() == 0 ? this.limit : this.unionLimit;
    }

    final SortFieldList getNonEmptyOrderBy(Configuration configuration) {
        if (this.getOrderBy().isEmpty()) {
            SortFieldList result = new SortFieldList();
            switch (configuration.family()) {
                default: 
            }
            result.add(DSL.field("({select} 0)").asc());
            return result;
        }
        return this.getOrderBy();
    }

    final SortFieldList getNonEmptyOrderByForDistinct(Configuration configuration) {
        SortFieldList order = new SortFieldList();
        order.addAll(this.getNonEmptyOrderBy(configuration));
        for (Field<?> field : this.getSelect()) {
            order.add(field.asc());
        }
        return order;
    }

    @Override
    public final void addOrderBy(Collection<? extends OrderField<?>> fields2) {
        this.getOrderBy().addAll(Tools.sortFields(fields2));
    }

    @Override
    public final void addOrderBy(OrderField<?> ... fields2) {
        this.addOrderBy(Arrays.asList(fields2));
    }

    @Override
    public final void addOrderBy(int ... fieldIndexes) {
        this.addOrderBy(Tools.map(fieldIndexes, v2 -> DSL.inline(v2)));
    }

    @Override
    public final void addSeekAfter(Field<?> ... fields2) {
        this.addSeekAfter(Arrays.asList(fields2));
    }

    @Override
    public final void addSeekAfter(Collection<? extends Field<?>> fields2) {
        if (this.unionOp.size() == 0) {
            this.seekBefore = false;
        } else {
            this.unionSeekBefore = false;
        }
        this.getSeek().addAll((Collection<Field<?>>)fields2);
    }

    @Override
    @Deprecated
    public final void addSeekBefore(Field<?> ... fields2) {
        this.addSeekBefore(Arrays.asList(fields2));
    }

    @Override
    @Deprecated
    public final void addSeekBefore(Collection<? extends Field<?>> fields2) {
        if (this.unionOp.size() == 0) {
            this.seekBefore = true;
        } else {
            this.unionSeekBefore = true;
        }
        this.getSeek().addAll((Collection<Field<?>>)fields2);
    }

    @Override
    public final void addConditions(Condition conditions) {
        this.condition.addConditions(conditions);
    }

    @Override
    public final void addConditions(Condition ... conditions) {
        this.condition.addConditions(conditions);
    }

    @Override
    public final void addConditions(Collection<? extends Condition> conditions) {
        this.condition.addConditions(conditions);
    }

    @Override
    public final void addConditions(Operator operator, Condition conditions) {
        this.condition.addConditions(operator, conditions);
    }

    @Override
    public final void addConditions(Operator operator, Condition ... conditions) {
        this.condition.addConditions(operator, conditions);
    }

    @Override
    public final void addConditions(Operator operator, Collection<? extends Condition> conditions) {
        this.condition.addConditions(operator, conditions);
    }

    final void setHint(String hint) {
        this.hint = hint;
    }

    final void setOption(String option) {
        this.option = option;
    }

    @Override
    public final void addFrom(Collection<? extends TableLike<?>> f2) {
        for (TableLike<?> provider : f2) {
            this.getFrom().add(provider.asTable());
        }
    }

    @Override
    public final void addFrom(TableLike<?> f2) {
        this.getFrom().add(f2.asTable());
    }

    @Override
    public final void addFrom(TableLike<?> ... f2) {
        for (TableLike<?> provider : f2) {
            this.getFrom().add(provider.asTable());
        }
    }

    @Override
    public final void addGroupBy(Collection<? extends GroupField> fields2) {
        this.setGrouping();
        this.groupBy.addAll(fields2);
    }

    @Override
    public final void setGroupByDistinct(boolean groupByDistinct) {
        this.setGrouping();
        this.groupByDistinct = groupByDistinct;
    }

    @Override
    public final void addGroupBy(GroupField ... fields2) {
        this.addGroupBy(Arrays.asList(fields2));
    }

    @Override
    public final void addHaving(Condition conditions) {
        this.getHaving().addConditions(conditions);
    }

    @Override
    public final void addHaving(Condition ... conditions) {
        this.getHaving().addConditions(conditions);
    }

    @Override
    public final void addHaving(Collection<? extends Condition> conditions) {
        this.getHaving().addConditions(conditions);
    }

    @Override
    public final void addHaving(Operator operator, Condition conditions) {
        this.getHaving().addConditions(operator, conditions);
    }

    @Override
    public final void addHaving(Operator operator, Condition ... conditions) {
        this.getHaving().addConditions(operator, conditions);
    }

    @Override
    public final void addHaving(Operator operator, Collection<? extends Condition> conditions) {
        this.getHaving().addConditions(operator, conditions);
    }

    @Override
    public final void addWindow(WindowDefinition ... definitions) {
        this.addWindow(Arrays.asList(definitions));
    }

    @Override
    public final void addWindow(Collection<? extends WindowDefinition> definitions) {
        if (this.window == null) {
            this.window = new WindowList();
        }
        this.window.addAll(definitions);
    }

    @Override
    public final void addQualify(Condition conditions) {
        this.getQualify().addConditions(conditions);
    }

    @Override
    public final void addQualify(Condition ... conditions) {
        this.getQualify().addConditions(conditions);
    }

    @Override
    public final void addQualify(Collection<? extends Condition> conditions) {
        this.getQualify().addConditions(conditions);
    }

    @Override
    public final void addQualify(Operator operator, Condition conditions) {
        this.getQualify().addConditions(operator, conditions);
    }

    @Override
    public final void addQualify(Operator operator, Condition ... conditions) {
        this.getQualify().addConditions(operator, conditions);
    }

    @Override
    public final void addQualify(Operator operator, Collection<? extends Condition> conditions) {
        this.getQualify().addConditions(operator, conditions);
    }

    private final SelectQueryImpl<R> combine(CombineOperator op2, Select<? extends R> other) {
        if (this == other || other instanceof SelectImpl && this == ((SelectImpl)other).getDelegate()) {
            throw new IllegalArgumentException("In jOOQ 3.x's mutable DSL API, it is not possible to use the same instance of a Select query on both sides of a set operation like s.union(s)");
        }
        int index = this.unionOp.size() - 1;
        if (index == -1 || this.unionOp.get(index) != op2 || op2 == CombineOperator.EXCEPT || op2 == CombineOperator.EXCEPT_ALL) {
            this.unionOp.add(op2);
            this.union.add(new QueryPartList());
            ++index;
        }
        this.union.get(index).add(other);
        return this;
    }

    @Override
    public final SelectQueryImpl<R> union(Select<? extends R> other) {
        return this.combine(CombineOperator.UNION, other);
    }

    @Override
    public final SelectQueryImpl<R> unionAll(Select<? extends R> other) {
        return this.combine(CombineOperator.UNION_ALL, other);
    }

    @Override
    public final SelectQueryImpl<R> except(Select<? extends R> other) {
        return this.combine(CombineOperator.EXCEPT, other);
    }

    @Override
    public final SelectQueryImpl<R> exceptAll(Select<? extends R> other) {
        return this.combine(CombineOperator.EXCEPT_ALL, other);
    }

    @Override
    public final SelectQueryImpl<R> intersect(Select<? extends R> other) {
        return this.combine(CombineOperator.INTERSECT, other);
    }

    @Override
    public final SelectQueryImpl<R> intersectAll(Select<? extends R> other) {
        return this.combine(CombineOperator.INTERSECT_ALL, other);
    }

    @Override
    public final void addJoin(TableLike<?> table, Condition conditions) {
        this.addJoin(table, JoinType.JOIN, conditions);
    }

    @Override
    public final void addJoin(TableLike<?> table, Condition ... conditions) {
        this.addJoin(table, JoinType.JOIN, conditions);
    }

    @Override
    public final void addJoin(TableLike<?> table, JoinType type, Condition conditions) {
        this.addJoin0(table, type, conditions, null);
    }

    @Override
    public final void addJoin(TableLike<?> table, JoinType type, Condition ... conditions) {
        this.addJoin0(table, type, conditions, null);
    }

    private final void addJoin0(TableLike<?> table, JoinType type, Object conditions, Field<?>[] partitionBy) {
        int index = this.getFrom().size() - 1;
        Table<Record> joined = null;
        switch (type) {
            case LEFT_ANTI_JOIN: 
            case LEFT_SEMI_JOIN: 
            case STRAIGHT_JOIN: 
            case FULL_OUTER_JOIN: 
            case JOIN: {
                TableOptionalOnStep<Record> o2 = ((Table)this.getFrom().get(index)).join(table, type);
                if (conditions instanceof Condition) {
                    joined = o2.on((Condition)conditions);
                    break;
                }
                joined = o2.on((Condition[])conditions);
                break;
            }
            case LEFT_OUTER_JOIN: 
            case RIGHT_OUTER_JOIN: {
                TablePartitionByStep p2;
                TablePartitionByStep o3 = p2 = (TablePartitionByStep)((Object)((Table)this.getFrom().get(index)).join(table, type));
                if (conditions instanceof Condition) {
                    joined = o3.on((Condition)conditions);
                    break;
                }
                joined = o3.on((Condition[])conditions);
                break;
            }
            case CROSS_APPLY: 
            case OUTER_APPLY: 
            case NATURAL_LEFT_OUTER_JOIN: 
            case NATURAL_RIGHT_OUTER_JOIN: 
            case NATURAL_FULL_OUTER_JOIN: 
            case CROSS_JOIN: 
            case NATURAL_JOIN: {
                joined = ((Table)this.getFrom().get(index)).join(table, type);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad join type: " + type);
            }
        }
        this.getFrom().set(index, joined);
    }

    @Override
    public final void addJoinOnKey(TableLike<?> table, JoinType type) throws DataAccessException {
        int index = this.getFrom().size() - 1;
        TableOnConditionStep joined = null;
        switch (type) {
            case LEFT_OUTER_JOIN: 
            case LEFT_ANTI_JOIN: 
            case LEFT_SEMI_JOIN: 
            case RIGHT_OUTER_JOIN: 
            case FULL_OUTER_JOIN: 
            case JOIN: {
                joined = ((Table)this.getFrom().get(index)).join(table, type).onKey();
                break;
            }
            default: {
                throw new IllegalArgumentException("JoinType " + type + " is not supported with the addJoinOnKey() method. Use INNER or OUTER JOINs only");
            }
        }
        this.getFrom().set(index, joined);
    }

    @Override
    public final void addJoinOnKey(TableLike<?> table, JoinType type, TableField<?, ?> ... keyFields) throws DataAccessException {
        int index = this.getFrom().size() - 1;
        TableOnConditionStep joined = null;
        switch (type) {
            case LEFT_OUTER_JOIN: 
            case LEFT_ANTI_JOIN: 
            case LEFT_SEMI_JOIN: 
            case RIGHT_OUTER_JOIN: 
            case FULL_OUTER_JOIN: 
            case JOIN: {
                joined = ((Table)this.getFrom().get(index)).join(table, type).onKey(keyFields);
                break;
            }
            default: {
                throw new IllegalArgumentException("JoinType " + type + " is not supported with the addJoinOnKey() method. Use INNER or OUTER JOINs only");
            }
        }
        this.getFrom().set(index, joined);
    }

    @Override
    public final void addJoinOnKey(TableLike<?> table, JoinType type, ForeignKey<?, ?> key) {
        int index = this.getFrom().size() - 1;
        TableOnConditionStep joined = null;
        switch (type) {
            case LEFT_OUTER_JOIN: 
            case LEFT_ANTI_JOIN: 
            case LEFT_SEMI_JOIN: 
            case RIGHT_OUTER_JOIN: 
            case FULL_OUTER_JOIN: 
            case JOIN: {
                joined = ((Table)this.getFrom().get(index)).join(table, type).onKey(key);
                break;
            }
            default: {
                throw new IllegalArgumentException("JoinType " + type + " is not supported with the addJoinOnKey() method. Use INNER or OUTER JOINs only");
            }
        }
        this.getFrom().set(index, joined);
    }

    @Override
    public final void addJoinUsing(TableLike<?> table, Collection<? extends Field<?>> fields2) {
        this.addJoinUsing(table, JoinType.JOIN, fields2);
    }

    @Override
    public final void addJoinUsing(TableLike<?> table, JoinType type, Collection<? extends Field<?>> fields2) {
        int index = this.getFrom().size() - 1;
        Table<Record> joined = null;
        switch (type) {
            case LEFT_OUTER_JOIN: 
            case LEFT_ANTI_JOIN: 
            case LEFT_SEMI_JOIN: 
            case RIGHT_OUTER_JOIN: 
            case FULL_OUTER_JOIN: 
            case JOIN: {
                joined = ((Table)this.getFrom().get(index)).join(table, type).using(fields2);
                break;
            }
            default: {
                throw new IllegalArgumentException("JoinType " + type + " is not supported with the addJoinUsing() method. Use INNER or OUTER JOINs only");
            }
        }
        this.getFrom().set(index, joined);
    }

    @Override
    public final void addHint(String h2) {
        this.setHint(h2);
    }

    @Override
    public final void addOption(String o2) {
        this.setOption(o2);
    }

    @Override
    public final WithImpl $with() {
        return this.with;
    }

    @Override
    public final QOM.UnmodifiableList<SelectFieldOrAsterisk> $select() {
        return QOM.unmodifiable(this.select);
    }

    @Override
    public final SelectQueryImpl<?> $select(QOM.UnmodifiableList<? extends SelectFieldOrAsterisk> newSelect) {
        if (this.$select() == newSelect) {
            return this;
        }
        return this.copy(s2 -> {
            s2.select.clear();
            s2.select.addAll(newSelect);
        });
    }

    @Override
    public final boolean $distinct() {
        return this.distinct;
    }

    @Override
    public final Select<R> $distinct(boolean newDistinct) {
        if (this.$distinct() == newDistinct) {
            return this;
        }
        return this.copy(s2 -> {
            s2.distinct = newDistinct;
        });
    }

    @Override
    public final QOM.UnmodifiableList<Table<?>> $from() {
        return QOM.unmodifiable(this.from);
    }

    @Override
    public final SelectQueryImpl<R> $from(QOM.UnmodifiableList<? extends Table<?>> newFrom) {
        if (this.$from() == newFrom) {
            return this;
        }
        return this.copy(s2 -> {
            s2.from.clear();
            s2.from.addAll(newFrom);
        });
    }

    @Override
    public final Condition $where() {
        return this.condition.getWhereOrNull();
    }

    @Override
    public final Select<R> $where(Condition newWhere) {
        if (this.$where() == newWhere) {
            return this;
        }
        return this.copy(s2 -> s2.condition.setWhere(newWhere));
    }

    @Override
    public final QOM.UnmodifiableList<GroupField> $groupBy() {
        return QOM.unmodifiable(this.groupBy == null ? new GroupFieldList() : this.groupBy);
    }

    @Override
    public final boolean $groupByDistinct() {
        return this.groupByDistinct;
    }

    @Override
    public final Select<R> $groupByDistinct(boolean newGroupByDistinct) {
        if (this.$groupByDistinct() == newGroupByDistinct) {
            return this;
        }
        return this.copy(s2 -> {
            s2.groupByDistinct = newGroupByDistinct;
        });
    }

    @Override
    public final Condition $having() {
        return this.having.getWhereOrNull();
    }

    @Override
    public final Select<R> $having(Condition newHaving) {
        if (this.$having() == newHaving) {
            return this;
        }
        return this.copy(s2 -> s2.having.setWhere(newHaving));
    }

    @Override
    public final QOM.UnmodifiableList<? extends WindowDefinition> $window() {
        return QOM.unmodifiable(this.window == null ? QueryPartList.emptyList() : this.window);
    }

    @Override
    public final Condition $qualify() {
        return this.qualify.getWhereOrNull();
    }

    @Override
    public final Select<R> $qualify(Condition newQualify) {
        if (this.$qualify() == newQualify) {
            return this;
        }
        return this.copy(s2 -> s2.qualify.setWhere(newQualify));
    }

    @Override
    public final QOM.UnmodifiableList<SortField<?>> $orderBy() {
        return QOM.unmodifiable(this.orderBy);
    }

    private static final class SelectFieldIndexes {
        private final boolean mapped;
        private final int[] mapping;
        private final int[] projectionSizes;

        public SelectFieldIndexes(boolean mapped, int[] mapping, int[] projectionSizes) {
            this.mapped = mapped;
            this.mapping = mapping;
            this.projectionSizes = projectionSizes;
        }

        public boolean mapped() {
            return this.mapped;
        }

        public int[] mapping() {
            return this.mapping;
        }

        public int[] projectionSizes() {
            return this.projectionSizes;
        }

        public boolean equals(Object o2) {
            if (!(o2 instanceof SelectFieldIndexes)) {
                return false;
            }
            SelectFieldIndexes other = (SelectFieldIndexes)o2;
            if (!Objects.equals(this.mapped, other.mapped)) {
                return false;
            }
            if (!Objects.equals(this.mapping, other.mapping)) {
                return false;
            }
            return Objects.equals(this.projectionSizes, other.projectionSizes);
        }

        public int hashCode() {
            return Objects.hash(this.mapped, this.mapping, this.projectionSizes);
        }

        public String toString() {
            return "SelectFieldIndexes[" + "mapped=" + this.mapped + ", mapping=" + this.mapping + ", projectionSizes=" + this.projectionSizes + "]";
        }
    }

    private static enum CopyClause {
        START,
        WHERE,
        QUALIFY,
        END;


        final boolean between(CopyClause startInclusive, CopyClause endExclusive) {
            return this.compareTo(startInclusive) >= 0 && this.compareTo(endExclusive) < 0;
        }
    }
}

