/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.SQLWarning;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Converter;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Fields;
import org.jooq.Name;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.RecordMapper;
import org.jooq.RecordType;
import org.jooq.Row;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.AbstractRecord;
import org.jooq.impl.AbstractRow;
import org.jooq.impl.DSL;
import org.jooq.impl.FieldsTrait;
import org.jooq.impl.Mappable;
import org.jooq.impl.QOM;
import org.jooq.impl.QueryPartListView;
import org.jooq.impl.RowField;
import org.jooq.impl.RowImplN;
import org.jooq.impl.ThrowingFunction;
import org.jooq.impl.Tools;
import org.jooq.tools.JooqLogger;

final class FieldsImpl<R extends Record>
extends AbstractQueryPart
implements RecordType<R>,
Mappable<R>,
QOM.UTransient {
    private static final JooqLogger log = JooqLogger.getLogger(FieldsImpl.class);
    Field<?>[] fields;
    private static final FieldOrIndex<Field<?>> RETURN_FIELD = new FieldOrIndex<Field<?>>(){

        @Override
        public Field<?> result(Field<?> field, int index) {
            return field;
        }

        @Override
        public Field<?> resultNull() {
            return null;
        }
    };
    private static final FieldOrIndex<Integer> RETURN_INDEX = new FieldOrIndex<Integer>(){

        @Override
        public Integer result(Field<?> field, int index) {
            return index;
        }

        @Override
        public Integer resultNull() {
            return -1;
        }
    };

    FieldsImpl(SelectField<?> ... fields2) {
        this.fields = Tools.map(fields2, FieldsImpl.toField(), Field[]::new);
    }

    FieldsImpl(Collection<? extends SelectField<?>> fields2) {
        this.fields = Tools.map(fields2, FieldsImpl.toField(), Field[]::new);
    }

    @Override
    public final RecordMapper<R, ?> mapper(int fieldIndex) {
        return r2 -> r2.get(fieldIndex);
    }

    @Override
    public final <U> RecordMapper<R, U> mapper(int fieldIndex, Configuration configuration, Class<? extends U> type) {
        return this.mapper(fieldIndex, Tools.converterOrFail(configuration, null, this.fields[this.safeIndex(fieldIndex)].getType(), type));
    }

    @Override
    public final <U> RecordMapper<R, U> mapper(int fieldIndex, Converter<?, ? extends U> converter) {
        return r2 -> r2.get(fieldIndex, converter);
    }

    @Override
    public final RecordMapper<R, Record> mapper(int[] fieldIndexes) {
        return this.mapper(this.fields(fieldIndexes));
    }

    @Override
    public final RecordMapper<R, ?> mapper(String fieldName) {
        return this.mapper(Tools.indexOrFail((Fields)this, fieldName));
    }

    @Override
    public final <U> RecordMapper<R, U> mapper(String fieldName, Configuration configuration, Class<? extends U> type) {
        return this.mapper(fieldName, Tools.converterOrFail(configuration, null, this.field(Tools.indexOrFail((Fields)this, fieldName)).getType(), type));
    }

    @Override
    public final <U> RecordMapper<R, U> mapper(String fieldName, Converter<?, ? extends U> converter) {
        return r2 -> r2.get(fieldName, converter);
    }

    @Override
    public final RecordMapper<R, Record> mapper(String[] fieldNames) {
        return this.mapper(this.fields(fieldNames));
    }

    @Override
    public final RecordMapper<R, ?> mapper(Name fieldName) {
        return this.mapper(Tools.indexOrFail((Fields)this, fieldName));
    }

    @Override
    public final <U> RecordMapper<R, U> mapper(Name fieldName, Configuration configuration, Class<? extends U> type) {
        return this.mapper(fieldName, Tools.converterOrFail(configuration, null, this.field(Tools.indexOrFail((Fields)this, fieldName)).getType(), type));
    }

    @Override
    public final <U> RecordMapper<R, U> mapper(Name fieldName, Converter<?, ? extends U> converter) {
        return r2 -> r2.get(fieldName, converter);
    }

    @Override
    public final RecordMapper<R, Record> mapper(Name[] fieldNames) {
        return this.mapper(this.fields(fieldNames));
    }

    @Override
    public final <T> RecordMapper<R, T> mapper(Field<T> field) {
        return this.mapper(Tools.indexOrFail((Fields)this, field));
    }

    @Override
    public final <U> RecordMapper<R, U> mapper(Field<?> field, Configuration configuration, Class<? extends U> type) {
        return this.mapper(field, Tools.converterOrFail(configuration, null, field.getType(), type));
    }

    @Override
    public final <T, U> RecordMapper<R, U> mapper(Field<T> field, Converter<? super T, ? extends U> converter) {
        return this.mapper(Tools.indexOrFail((Fields)this, field), converter);
    }

    @Override
    public final RecordMapper<R, Record> mapper(Field<?>[] f2) {
        AbstractRow<?> row = Tools.row0(f2 == null ? Tools.EMPTY_FIELD : f2);
        return r2 -> Tools.newRecord(false, AbstractRecord.class, row, r2.configuration()).operate(x2 -> {
            for (Field<?> field : row.fields.fields) {
                Tools.copyValue((AbstractRecord)x2, field, r2, field);
            }
            return x2;
        });
    }

    @Override
    public final <S extends Record> RecordMapper<R, S> mapper(Table<S> table) {
        return r2 -> r2.into(table);
    }

    @Override
    public final <E> RecordMapper<R, E> mapper(Configuration configuration, Class<? extends E> type) {
        return configuration.recordMapperProvider().provide(this, type);
    }

    static final Row fieldsRow0(FieldsTrait fields2) {
        return fields2 instanceof Select ? ((Select)((Object)fields2)).asTable("t").fieldsRow() : fields2.fieldsRow();
    }

    private static final ThrowingFunction<SelectField<?>, Field<?>, RuntimeException> toField() {
        return f2 -> f2 instanceof Row ? new RowField((Row)((Object)f2)) : (Field)f2;
    }

    @Override
    public final int size() {
        return this.fields.length;
    }

    @Override
    public final <T> Field<T> field(Field<T> field) {
        return this.field0(field, RETURN_FIELD);
    }

    private final <U> U field0(Field<?> field, FieldOrIndex<U> result) {
        Field<?> f2;
        int i2;
        if (field == null) {
            return result.resultNull();
        }
        for (i2 = 0; i2 < this.fields.length; ++i2) {
            f2 = this.fields[i2];
            if (f2 != field) continue;
            return result.result(f2, i2);
        }
        for (i2 = 0; i2 < this.fields.length; ++i2) {
            f2 = this.fields[i2];
            if (!f2.equals(field)) continue;
            return result.result(f2, i2);
        }
        Field<?> columnOnlyMatch = null;
        Field<?> columnOnlyMatch2 = null;
        int columnOnlyIndexMatch = -1;
        Field<?> unaliased = null;
        Field<?> aliasMatch = null;
        Field<?> aliasMatch2 = null;
        int aliasIndexMatch = -1;
        String tableName = this.tableName(field);
        String fieldName = field.getName();
        for (int i3 = 0; i3 < this.fields.length; ++i3) {
            String tName;
            Field<?> f3 = this.fields[i3];
            String fName = f3.getName();
            if (tableName != null && (tName = this.tableName(f3)) != null && tableName.equals(tName) && fName.equals(fieldName)) {
                return result.result(f3, i3);
            }
            if (!fName.equals(fieldName)) continue;
            if (unaliased == null) {
                unaliased = Tools.unaliasTable(field);
            }
            if (unaliased != null && unaliased.equals(Tools.unaliasTable(f3))) {
                if (aliasMatch == null) {
                    aliasMatch = f3;
                    aliasIndexMatch = i3;
                } else {
                    aliasMatch2 = f3;
                }
            }
            if (columnOnlyMatch == null) {
                columnOnlyMatch = f3;
                columnOnlyIndexMatch = i3;
                continue;
            }
            columnOnlyMatch2 = f3;
        }
        if (aliasMatch2 != null && log.isInfoEnabled()) {
            log.info((Object)("Ambiguous match found for " + fieldName + ". Both " + aliasMatch + " and " + aliasMatch2 + " match."), new SQLWarning());
        }
        if (aliasMatch != null) {
            return result.result(aliasMatch, aliasIndexMatch);
        }
        if (columnOnlyMatch2 != null && log.isInfoEnabled()) {
            log.info((Object)("Ambiguous match found for " + fieldName + ". Both " + columnOnlyMatch + " and " + columnOnlyMatch2 + " match."), new SQLWarning());
        }
        return result.result(columnOnlyMatch, columnOnlyIndexMatch);
    }

    private final String tableName(Field<?> field) {
        TableField f2;
        Table table;
        if (field instanceof TableField && (table = (f2 = (TableField)field).getTable()) != null) {
            return table.getName();
        }
        return null;
    }

    @Override
    public final Field<?> field(String fieldName) {
        return this.field0(fieldName, RETURN_FIELD);
    }

    private final <U> U field0(String fieldName, FieldOrIndex<U> result) {
        if (fieldName == null) {
            return result.resultNull();
        }
        Field<?> columnMatch = null;
        int indexMatch = -1;
        for (int i2 = 0; i2 < this.fields.length; ++i2) {
            Field<?> f2 = this.fields[i2];
            if (!f2.getName().equals(fieldName)) continue;
            if (columnMatch == null) {
                columnMatch = f2;
                indexMatch = i2;
                continue;
            }
            log.info((Object)("Ambiguous match found for " + fieldName + ". Both " + columnMatch + " and " + f2 + " match."), new SQLWarning());
        }
        return result.result(columnMatch, indexMatch);
    }

    @Override
    public final <T> Field<T> field(String fieldName, Class<T> type) {
        Field<?> result = this.field(fieldName);
        return result == null ? null : result.coerce(type);
    }

    @Override
    public final <T> Field<T> field(String fieldName, DataType<T> dataType) {
        Field<?> result = this.field(fieldName);
        return result == null ? null : result.coerce(dataType);
    }

    @Override
    public final Field<?> field(Name name) {
        return this.field0(name, RETURN_FIELD);
    }

    private final <U> U field0(Name name, FieldOrIndex<U> result) {
        if (name == null) {
            return result.resultNull();
        }
        return this.field0(DSL.field(name), result);
    }

    @Override
    public final <T> Field<T> field(Name fieldName, Class<T> type) {
        Field<?> result = this.field(fieldName);
        return result == null ? null : result.coerce(type);
    }

    @Override
    public final <T> Field<T> field(Name fieldName, DataType<T> dataType) {
        Field<?> result = this.field(fieldName);
        return result == null ? null : result.coerce(dataType);
    }

    @Override
    public final Field<?> field(int index) {
        if (index >= 0 && index < this.fields.length) {
            return this.fields[index];
        }
        return null;
    }

    final int safeIndex(int index) {
        if (index >= 0 && index < this.fields.length) {
            return index;
        }
        throw new IllegalArgumentException("No field at index " + index + " in Record type " + this.fields);
    }

    @Override
    public final <T> Field<T> field(int fieldIndex, Class<T> type) {
        Field<?> result = this.field(fieldIndex);
        return result == null ? null : result.coerce(type);
    }

    @Override
    public final <T> Field<T> field(int fieldIndex, DataType<T> dataType) {
        Field<?> result = this.field(fieldIndex);
        return result == null ? null : result.coerce(dataType);
    }

    @Override
    public final Field<?>[] fields() {
        return this.fields;
    }

    @Override
    public final Row fieldsRow() {
        return new RowImplN(this.fields);
    }

    @Override
    public final Stream<Field<?>> fieldStream() {
        return Stream.of(this.fields);
    }

    @Override
    public final Field<?>[] fields(Field<?> ... f2) {
        return Tools.map(f2, i2 -> this.field((Field)i2), Field[]::new);
    }

    @Override
    public final Field<?>[] fields(String ... f2) {
        return Tools.map(f2, i2 -> this.field((String)i2), Field[]::new);
    }

    @Override
    public final Field<?>[] fields(Name ... f2) {
        return Tools.map(f2, i2 -> this.field((Name)i2), Field[]::new);
    }

    @Override
    public final Field<?>[] fields(int ... f2) {
        return Tools.map(f2, i2 -> this.field(i2), Field[]::new);
    }

    @Override
    public final int indexOf(Field<?> field) {
        return this.field0(field, RETURN_INDEX);
    }

    @Override
    public final int indexOf(String fieldName) {
        return this.field0(fieldName, RETURN_INDEX);
    }

    @Override
    public final int indexOf(Name fieldName) {
        return this.field0(fieldName, RETURN_INDEX);
    }

    @Override
    public final Class<?>[] types() {
        return Tools.map(this.fields, f2 -> f2.getType(), Class[]::new);
    }

    @Override
    public final Class<?> type(int fieldIndex) {
        return fieldIndex >= 0 && fieldIndex < this.size() ? this.field(fieldIndex).getType() : null;
    }

    @Override
    public final Class<?> type(String fieldName) {
        return this.type(Tools.indexOrFail((Fields)this, fieldName));
    }

    @Override
    public final Class<?> type(Name fieldName) {
        return this.type(Tools.indexOrFail((Fields)this, fieldName));
    }

    @Override
    public final DataType<?>[] dataTypes() {
        return Tools.map(this.fields, f2 -> f2.getDataType(), DataType[]::new);
    }

    @Override
    public final DataType<?> dataType(int fieldIndex) {
        return fieldIndex >= 0 && fieldIndex < this.size() ? this.field(fieldIndex).getDataType() : null;
    }

    @Override
    public final DataType<?> dataType(String fieldName) {
        return this.dataType(Tools.indexOrFail((Fields)this, fieldName));
    }

    @Override
    public final DataType<?> dataType(Name fieldName) {
        return this.dataType(Tools.indexOrFail((Fields)this, fieldName));
    }

    final int[] indexesOf(Field<?> ... f2) {
        int[] result = new int[f2.length];
        for (int i2 = 0; i2 < f2.length; ++i2) {
            result[i2] = Tools.indexOrFail((Fields)this, f2[i2]);
        }
        return result;
    }

    final int[] indexesOf(String ... fieldNames) {
        int[] result = new int[fieldNames.length];
        for (int i2 = 0; i2 < fieldNames.length; ++i2) {
            result[i2] = Tools.indexOrFail((Fields)this, fieldNames[i2]);
        }
        return result;
    }

    final int[] indexesOf(Name ... fieldNames) {
        int[] result = new int[fieldNames.length];
        for (int i2 = 0; i2 < fieldNames.length; ++i2) {
            result[i2] = Tools.indexOrFail((Fields)this, fieldNames[i2]);
        }
        return result;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(QueryPartListView.wrap((QueryPart[])this.fields));
    }

    final void add(Field<?> f2) {
        Field[] result = new Field[this.fields.length + 1];
        System.arraycopy(this.fields, 0, result, 0, this.fields.length);
        result[this.fields.length] = f2;
        this.fields = result;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof FieldsImpl) {
            return Arrays.equals(this.fields, ((FieldsImpl)that).fields);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.fields);
    }

    private static interface FieldOrIndex<U> {
        public U result(Field<?> var1, int var2);

        public U resultNull();
    }
}

