/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.jooq.BindContext;
import org.jooq.Configuration;
import org.jooq.Constants;
import org.jooq.ExecuteContext;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Param;
import org.jooq.Query;
import org.jooq.QueryPart;
import org.jooq.QueryPartInternal;
import org.jooq.RenderContext;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.conf.ParamType;
import org.jooq.conf.RenderFormatting;
import org.jooq.conf.RenderKeywordCase;
import org.jooq.conf.RenderNameCase;
import org.jooq.conf.RenderQuotedNames;
import org.jooq.conf.Settings;
import org.jooq.conf.SettingsTools;
import org.jooq.exception.ControlFlowSignal;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.AbstractContext;
import org.jooq.impl.DSL;
import org.jooq.impl.Identifiers;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.ScopeMappable;
import org.jooq.impl.ScopeMarker;
import org.jooq.impl.ScopeNestable;
import org.jooq.impl.TableImpl;
import org.jooq.impl.Tips;
import org.jooq.impl.Tools;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;

class DefaultRenderContext
extends AbstractContext<RenderContext>
implements RenderContext {
    private static final JooqLogger log;
    private static final Pattern IDENTIFIER_PATTERN;
    private static final Pattern NEWLINE;
    private static final Set<String> SQLITE_KEYWORDS;
    final StringBuilder sql;
    private final QueryPartList<Param<?>> bindValues;
    private int alias;
    private int indent;
    private Deque<Integer> indentLock;
    private boolean separatorRequired;
    private boolean separator;
    private boolean newline;
    private Boolean isQuery;
    RenderKeywordCase cachedRenderKeywordCase;
    RenderNameCase cachedRenderNameCase;
    RenderQuotedNames cachedRenderQuotedNames;
    boolean cachedRenderFormatted;
    String cachedIndentation;
    int cachedIndentWidth;
    String cachedNewline;
    int cachedPrintMargin;

    DefaultRenderContext(Configuration configuration, ExecuteContext ctx) {
        super(configuration, ctx, null);
        Settings settings = configuration.settings();
        this.sql = new StringBuilder();
        this.bindValues = new QueryPartList();
        this.cachedRenderKeywordCase = SettingsTools.getRenderKeywordCase(settings);
        this.cachedRenderFormatted = Boolean.TRUE.equals(settings.isRenderFormatted());
        this.cachedRenderNameCase = SettingsTools.getRenderNameCase(settings);
        this.cachedRenderQuotedNames = SettingsTools.getRenderQuotedNames(settings);
        RenderFormatting formatting = settings.getRenderFormatting();
        if (formatting == null) {
            formatting = new RenderFormatting();
        }
        this.cachedNewline = formatting.getNewline() == null ? "\n" : formatting.getNewline();
        this.cachedIndentation = formatting.getIndentation() == null ? "  " : formatting.getIndentation();
        this.cachedIndentWidth = this.cachedIndentation.length();
        this.cachedPrintMargin = formatting.getPrintMargin() == null ? 80 : formatting.getPrintMargin();
    }

    DefaultRenderContext(RenderContext context) {
        this(context, true);
    }

    DefaultRenderContext(RenderContext context, boolean copyLocalState) {
        this(context.configuration(), (ExecuteContext)context.data((Object)Tools.DataKey.DATA_EXECUTE_CONTEXT));
        this.paramType(context.paramType());
        this.qualifyCatalog(context.qualifyCatalog());
        this.qualifySchema(context.qualifySchema());
        this.quote(context.quote());
        this.castMode(context.castMode());
        if (copyLocalState) {
            this.data().putAll(context.data());
            this.declareCTE = context.declareCTE();
            this.declareWindows = context.declareWindows();
            this.declareFields = context.declareFields();
            this.declareTables = context.declareTables();
            this.declareAliases = context.declareAliases();
        }
    }

    @Override
    public final BindContext bindValue(Object value, Field<?> field) throws DataAccessException {
        throw new UnsupportedOperationException();
    }

    final QueryPartList<Param<?>> bindValues() {
        return this.bindValues;
    }

    @Override
    void scopeMarkStart0(QueryPart part) {
        this.applyNewLine();
        AbstractContext.ScopeStackElement e2 = (AbstractContext.ScopeStackElement)this.scopeStack.getOrCreate(part);
        e2.positions = new int[]{this.sql.length(), -1};
        e2.bindIndex = this.peekIndex();
        e2.indent = this.indent;
        this.resetSeparatorFlags();
    }

    @Override
    void scopeMarkEnd0(QueryPart part) {
        this.applyNewLine();
        AbstractContext.ScopeStackElement e2 = (AbstractContext.ScopeStackElement)this.scopeStack.getOrCreate(part);
        e2.positions[1] = this.sql.length();
    }

    @Override
    public QueryPart scopeMapping(QueryPart part) {
        AbstractContext.ScopeStackElement e2;
        if (this.scopeStack.inScope() && part instanceof ScopeMappable && (e2 = (AbstractContext.ScopeStackElement)this.scopeStack.get(part)) != null && e2.mapped != null) {
            return e2.mapped;
        }
        return part;
    }

    @Override
    public RenderContext scopeRegister(QueryPart part, boolean forceNew, QueryPart mapped) {
        if (this.scopeStack.inScope()) {
            AbstractContext.ScopeStackElement e2;
            if (part instanceof TableImpl) {
                Table<?> root;
                Table<?> child = root = (Table<?>)part;
                ArrayList tables = new ArrayList();
                while (root instanceof TableImpl && (child = ((TableImpl)root).child) != null) {
                    tables.add(root);
                    root = child;
                }
                AbstractContext.ScopeStackElement scopeStackElement = e2 = forceNew ? (AbstractContext.ScopeStackElement)this.scopeStack.create(root) : (AbstractContext.ScopeStackElement)this.scopeStack.getOrCreate(root);
                if (e2.joinNode == null) {
                    e2.joinNode = new AbstractContext.JoinNode(this.configuration(), root);
                }
                AbstractContext.JoinNode childNode = e2.joinNode;
                for (int i2 = tables.size() - 1; i2 >= 0; --i2) {
                    Table t2 = (Table)tables.get(i2);
                    ForeignKey k2 = ((TableImpl)t2).childPath;
                    AbstractContext.JoinNode next = childNode.children.get(k2);
                    if (next == null) {
                        next = new AbstractContext.JoinNode(this.configuration(), t2);
                        childNode.children.put(k2, next);
                    }
                    childNode = next;
                }
            } else {
                e2 = forceNew ? (AbstractContext.ScopeStackElement)this.scopeStack.create(part) : (AbstractContext.ScopeStackElement)this.scopeStack.getOrCreate(part);
            }
            e2.mapped = mapped;
        }
        return this;
    }

    @Override
    void scopeStart0() {
        for (AbstractContext.ScopeStackElement e2 : this.scopeStack) {
            if (e2.part == e2.mapped || e2.part instanceof ScopeNestable) continue;
            this.scopeStack.set(e2.part, null);
        }
    }

    @Override
    void scopeEnd0() {
        int i2;
        ScopeMarker[] markers = ScopeMarker.values();
        AbstractContext.ScopeStackElement[] beforeFirst = new AbstractContext.ScopeStackElement[markers.length];
        AbstractContext.ScopeStackElement[] afterLast = new AbstractContext.ScopeStackElement[markers.length];
        ScopeMarker.ScopeContent[] content = new ScopeMarker.ScopeContent[markers.length];
        for (ScopeMarker marker : markers) {
            if (marker.topLevelOnly && this.subqueryLevel() != 0) continue;
            i2 = marker.ordinal();
            content[i2] = (ScopeMarker.ScopeContent)this.data(marker.key);
            ScopeMarker.ScopeContent o2 = content[i2];
            if (o2 == null || o2.isEmpty()) continue;
            beforeFirst[i2] = (AbstractContext.ScopeStackElement)this.scopeStack.get(marker.beforeFirst);
            afterLast[i2] = (AbstractContext.ScopeStackElement)this.scopeStack.get(marker.afterLast);
        }
        for (AbstractContext.ScopeStackElement e1 : this.scopeStack.iterable(e2 -> e2.scopeLevel == this.scopeStack.scopeLevel())) {
            String replacedSQL = null;
            QueryPartList<Param<?>> insertedBindValues = null;
            if (e1.positions == null) continue;
            if (e1.joinNode != null && !e1.joinNode.children.isEmpty()) {
                replacedSQL = ((RenderContext)((RenderContext)((RenderContext)((RenderContext)((RenderContext)((RenderContext)((RenderContext)((RenderContext)this.configuration.dsl().renderContext().declareTables(true)).sql('(')).formatIndentStart(e1.indent)).formatIndentStart()).formatNewLine()).visit(e1.joinNode.joinTree())).formatNewLine()).sql(')')).render();
            } else {
                for (i2 = 0; i2 < beforeFirst.length; ++i2) {
                    AbstractContext.ScopeStackElement e3 = beforeFirst[i2];
                    ScopeMarker.ScopeContent c2 = content[i2];
                    if (e1 != e3 || c2 == null) continue;
                    DefaultRenderContext ctx = new DefaultRenderContext(this, false);
                    markers[i2].renderer.render((DefaultRenderContext)ctx.formatIndentStart(e3.indent), e3, afterLast[i2], c2);
                    replacedSQL = ctx.render();
                    insertedBindValues = ctx.bindValues();
                    break;
                }
            }
            if (replacedSQL == null) continue;
            this.sql.replace(e1.positions[0], e1.positions[1], replacedSQL);
            int shift = replacedSQL.length() - (e1.positions[1] - e1.positions[0]);
            for (AbstractContext.ScopeStackElement e22 : this.scopeStack) {
                if (e22.positions == null || e22.positions[0] <= e1.positions[0]) continue;
                e22.positions[0] = e22.positions[0] + shift;
                e22.positions[1] = e22.positions[1] + shift;
            }
            if (insertedBindValues == null) continue;
            this.bindValues.addAll(e1.bindIndex - 1, (Collection<Param<?>>)insertedBindValues);
            for (AbstractContext.ScopeStackElement e22 : this.scopeStack) {
                if (e22.positions == null || e22.bindIndex <= e1.bindIndex) continue;
                e22.bindIndex += insertedBindValues.size();
            }
        }
    }

    @Override
    public final String peekAlias() {
        return "alias_" + (this.alias + 1);
    }

    @Override
    public final String nextAlias() {
        return "alias_" + ++this.alias;
    }

    @Override
    public final String render() {
        String prepend = null;
        String append = null;
        if (Boolean.TRUE.equals(this.isQuery)) {
            prepend = (String)this.data((Object)Tools.DataKey.DATA_PREPEND_SQL);
            append = (String)this.data((Object)Tools.DataKey.DATA_APPEND_SQL);
        }
        String result = this.sql.toString();
        return prepend == null && append == null ? result : (this.format() ? (String)(prepend != null ? prepend + (prepend.endsWith(this.cachedNewline) ? "" : this.cachedNewline) : "") + result + (String)(append != null ? ";" + (append.endsWith(this.cachedNewline) ? "" : this.cachedNewline) + append : "") : (String)(prepend != null ? prepend + (prepend.endsWith(" ") ? "" : " ") : "") + result + (String)(append != null ? ";" + (append.endsWith(" ") ? "" : " ") + append : ""));
    }

    @Override
    public final String render(QueryPart part) {
        return ((RenderContext)new DefaultRenderContext(this).visit(part)).render();
    }

    @Override
    public final RenderContext keyword(String keyword) {
        return (RenderContext)this.visit(DSL.keyword(keyword));
    }

    @Override
    public final RenderContext sql(String s2) {
        return this.sql(s2, s2 == null || !this.cachedRenderFormatted);
    }

    @Override
    public final RenderContext sql(String s2, boolean literal) {
        if (!literal) {
            s2 = Tools.replaceAll(s2, NEWLINE.matcher(s2), r2 -> r2.group() + this.indentation());
        }
        if (this.stringLiteral()) {
            s2 = StringUtils.replace(s2, "'", this.stringLiteralEscapedApos);
        }
        this.applyNewLine();
        this.sql.append(s2);
        this.resetSeparatorFlags();
        return this;
    }

    @Override
    public final RenderContext sqlIndentStart(String c2) {
        return (RenderContext)this.sql(c2).sqlIndentStart();
    }

    @Override
    public final RenderContext sqlIndentEnd(String c2) {
        return (RenderContext)this.sqlIndentEnd().sql(c2);
    }

    @Override
    public final RenderContext sqlIndentStart() {
        return (RenderContext)this.formatIndentStart().formatNewLine();
    }

    @Override
    public final RenderContext sqlIndentEnd() {
        return (RenderContext)this.formatIndentEnd().formatNewLine();
    }

    @Override
    public final RenderContext sql(char c2) {
        this.applyNewLine();
        if (c2 == '\'' && this.stringLiteral()) {
            this.sql.append(this.stringLiteralEscapedApos);
        } else {
            this.sql.append(c2);
        }
        this.resetSeparatorFlags();
        return this;
    }

    @Override
    public final RenderContext sqlIndentStart(char c2) {
        return (RenderContext)this.sql(c2).sqlIndentStart();
    }

    @Override
    public final RenderContext sqlIndentEnd(char c2) {
        return (RenderContext)this.sqlIndentEnd().sql(c2);
    }

    @Override
    public final RenderContext sql(int i2) {
        this.applyNewLine();
        this.sql.append(i2);
        this.resetSeparatorFlags();
        return this;
    }

    @Override
    public final RenderContext sql(long l2) {
        this.applyNewLine();
        this.sql.append(l2);
        this.resetSeparatorFlags();
        return this;
    }

    @Override
    public final RenderContext sql(float f2) {
        this.applyNewLine();
        this.sql.append(this.floatFormat().format(f2));
        this.resetSeparatorFlags();
        return this;
    }

    @Override
    public final RenderContext sql(double d2) {
        this.applyNewLine();
        this.sql.append(this.doubleFormat().format(d2));
        this.resetSeparatorFlags();
        return this;
    }

    private final void resetSeparatorFlags() {
        this.separatorRequired = false;
        this.separator = false;
        this.newline = false;
    }

    @Override
    public final RenderContext formatNewLine() {
        if (this.cachedRenderFormatted) {
            this.newline = true;
        }
        return this;
    }

    private final void applyNewLine() {
        if (this.newline) {
            this.sql.append(this.cachedNewline);
            this.sql.append(this.indentation());
        }
    }

    @Override
    public final RenderContext formatNewLineAfterPrintMargin() {
        if (this.cachedRenderFormatted && this.cachedPrintMargin > 0 && this.sql.length() - this.sql.lastIndexOf(this.cachedNewline) > this.cachedPrintMargin) {
            this.formatNewLine();
        }
        return this;
    }

    private final String indentation() {
        return StringUtils.leftPad("", this.indent, this.cachedIndentation);
    }

    @Override
    public final RenderContext format(boolean format) {
        this.cachedRenderFormatted = format;
        return this;
    }

    @Override
    public final boolean format() {
        return this.cachedRenderFormatted;
    }

    @Override
    public final RenderContext formatSeparator() {
        if (!this.separator && !this.newline) {
            if (this.cachedRenderFormatted) {
                this.formatNewLine();
            } else {
                this.sql(" ", true);
            }
            this.separator = true;
        }
        return this;
    }

    @Override
    public final RenderContext separatorRequired(boolean separatorRequired) {
        this.separatorRequired = separatorRequired;
        return this;
    }

    @Override
    public final boolean separatorRequired() {
        return this.separatorRequired && !this.separator && !this.newline;
    }

    @Override
    public final RenderContext formatIndentStart() {
        return this.formatIndentStart(this.cachedIndentWidth);
    }

    @Override
    public final RenderContext formatIndentEnd() {
        return this.formatIndentEnd(this.cachedIndentWidth);
    }

    @Override
    public final RenderContext formatIndentStart(int i2) {
        if (this.cachedRenderFormatted) {
            this.indent += i2;
        }
        return this;
    }

    @Override
    public final RenderContext formatIndentEnd(int i2) {
        if (this.cachedRenderFormatted) {
            this.indent -= i2;
        }
        return this;
    }

    private final Deque<Integer> indentLock() {
        if (this.indentLock == null) {
            this.indentLock = new ArrayDeque<Integer>();
        }
        return this.indentLock;
    }

    @Override
    public final RenderContext formatIndentLockStart() {
        if (this.cachedRenderFormatted) {
            this.indentLock().push(this.indent);
            String[] lines = NEWLINE.split(this.sql);
            this.indent = lines[lines.length - 1].length();
        }
        return this;
    }

    @Override
    public final RenderContext formatIndentLockEnd() {
        if (this.cachedRenderFormatted) {
            this.indent = this.indentLock().pop();
        }
        return this;
    }

    @Override
    public final RenderContext formatPrintMargin(int margin) {
        this.cachedPrintMargin = margin;
        return this;
    }

    @Override
    public final RenderContext literal(String literal) {
        if (literal == null) {
            return this;
        }
        SQLDialect family = this.family();
        boolean needsQuote = family != SQLDialect.SQLITE && this.quote() || family == SQLDialect.SQLITE && SQLITE_KEYWORDS.contains(literal.toUpperCase(SettingsTools.renderLocale(this.configuration().settings()))) || family == SQLDialect.SQLITE && !IDENTIFIER_PATTERN.matcher(literal).matches();
        literal = this.applyNameCase(literal);
        if (needsQuote) {
            char[][][] quotes = Identifiers.QUOTES.get((Object)family);
            char start = quotes[0][0][0];
            char end = quotes[1][0][0];
            this.sql(start);
            if (literal.indexOf(end) > -1) {
                this.sql(StringUtils.replace(literal, new String(quotes[1][0]), new String(quotes[2][0])), true);
            } else {
                this.sql(literal, true);
            }
            this.sql(end);
        } else {
            this.sql(literal, true);
        }
        return this;
    }

    @Override
    final String applyNameCase(String literal) {
        if (RenderNameCase.LOWER == this.cachedRenderNameCase || RenderNameCase.LOWER_IF_UNQUOTED == this.cachedRenderNameCase && !this.quote()) {
            return literal.toLowerCase(SettingsTools.renderLocale(this.configuration().settings()));
        }
        if (RenderNameCase.UPPER == this.cachedRenderNameCase || RenderNameCase.UPPER_IF_UNQUOTED == this.cachedRenderNameCase && !this.quote()) {
            return literal.toUpperCase(SettingsTools.renderLocale(this.configuration().settings()));
        }
        return literal;
    }

    @Override
    protected final void visit0(QueryPartInternal internal) {
        Param param;
        if (this.isQuery == null) {
            this.isQuery = internal instanceof Query;
        }
        int before = this.bindValues.size();
        internal.accept(this);
        int after = this.bindValues.size();
        if (after == before && this.paramType != ParamType.INLINED && internal instanceof Param && !(param = (Param)((Object)internal)).isInline()) {
            this.bindValues.add(param);
            Integer threshold = this.settings().getInlineThreshold();
            if (threshold != null && threshold > 0) {
                this.checkForceInline(threshold);
            } else {
                switch (this.family()) {
                    case POSTGRES: 
                    case YUGABYTEDB: {
                        this.checkForceInline(Short.MAX_VALUE);
                        break;
                    }
                    case SQLITE: {
                        this.checkForceInline(999);
                        break;
                    }
                }
            }
        }
    }

    private final void checkForceInline(int max) throws ForceInlineSignal {
        if (this.bindValues.size() > max && Boolean.TRUE.equals(this.data((Object)Tools.BooleanDataKey.DATA_COUNT_BIND_VALUES))) {
            throw new ForceInlineSignal();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("rendering    [").append(this.render()).append("]\n");
        sb.append("formatting   [").append(this.format()).append("]\n");
        sb.append("parameters   [").append((Object)this.paramType).append("]\n");
        this.toString(sb);
        return sb.toString();
    }

    static {
        JooqLogger l2;
        log = JooqLogger.getLogger(DefaultRenderContext.class);
        IDENTIFIER_PATTERN = Pattern.compile("[A-Za-z][A-Za-z0-9_]*");
        NEWLINE = Pattern.compile("[\\n\\r]");
        SQLITE_KEYWORDS = new HashSet<String>();
        SQLITE_KEYWORDS.addAll(Arrays.asList("ABORT", "ACTION", "ADD", "AFTER", "ALL", "ALTER", "ANALYZE", "AND", "AS", "ASC", "ATTACH", "AUTOINCREMENT", "BEFORE", "BEGIN", "BETWEEN", "BY", "CASCADE", "CASE", "CAST", "CHECK", "COLLATE", "COLUMN", "COMMIT", "CONFLICT", "CONSTRAINT", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "DATABASE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DETACH", "DISTINCT", "DO", "DROP", "EACH", "ELSE", "END", "ESCAPE", "EXCEPT", "EXCLUDE", "EXCLUSIVE", "EXISTS", "EXPLAIN", "FAIL", "FILTER", "FOLLOWING", "FOR", "FOREIGN", "FROM", "FULL", "GLOB", "GROUP", "GROUPS", "HAVING", "IF", "IGNORE", "IMMEDIATE", "IN", "INDEX", "INDEXED", "INITIALLY", "INNER", "INSERT", "INSTEAD", "INTERSECT", "INTO", "IS", "ISNULL", "JOIN", "KEY", "LEFT", "LIKE", "LIMIT", "MATCH", "NATURAL", "NO", "NOT", "NOTHING", "NOTNULL", "NULL", "OF", "OFFSET", "ON", "OR", "ORDER", "OTHERS", "OUTER", "OVER", "PARTITION", "PLAN", "PRAGMA", "PRECEDING", "PRIMARY", "QUERY", "RAISE", "RANGE", "RECURSIVE", "REFERENCES", "REGEXP", "REINDEX", "RELEASE", "RENAME", "REPLACE", "RESTRICT", "RIGHT", "ROLLBACK", "ROW", "ROWS", "SAVEPOINT", "SELECT", "SET", "TABLE", "TEMP", "TEMPORARY", "THEN", "TIES", "TO", "TRANSACTION", "TRIGGER", "UNBOUNDED", "UNION", "UNIQUE", "UPDATE", "USING", "VACUUM", "VALUES", "VIEW", "VIRTUAL", "WHEN", "WHERE", "WINDOW", "WITH", "WITHOUT"));
        if (!Boolean.getBoolean("org.jooq.no-logo")) {
            l2 = JooqLogger.getLogger(Constants.class);
            String message = "Thank you for using jOOQ 3.16.18";
            l2.info("\n                                      \n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n@@@@@@@@@@@@@@@@  @@        @@@@@@@@@@\n@@@@@@@@@@@@@@@@@@@@        @@@@@@@@@@\n@@@@@@@@@@@@@@@@  @@  @@    @@@@@@@@@@\n@@@@@@@@@@  @@@@  @@  @@    @@@@@@@@@@\n@@@@@@@@@@        @@        @@@@@@@@@@\n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n@@@@@@@@@@        @@        @@@@@@@@@@\n@@@@@@@@@@    @@  @@  @@@@  @@@@@@@@@@\n@@@@@@@@@@    @@  @@  @@@@  @@@@@@@@@@\n@@@@@@@@@@        @@  @  @  @@@@@@@@@@\n@@@@@@@@@@        @@        @@@@@@@@@@\n@@@@@@@@@@@@@@@@@@@@@@@  @@@@@@@@@@@@@\n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  " + message + "\n                                      ");
        }
        if (!Boolean.getBoolean("org.jooq.no-tips")) {
            l2 = JooqLogger.getLogger(Constants.class);
            l2.info("\n\njOOQ tip of the day: " + Tips.randomTip() + "\n");
        }
    }

    static class Rendered {
        String sql;
        QueryPartList<Param<?>> bindValues;
        int skipUpdateCounts;

        Rendered(String sql, QueryPartList<Param<?>> bindValues, int skipUpdateCounts) {
            this.sql = sql;
            this.bindValues = bindValues;
            this.skipUpdateCounts = skipUpdateCounts;
        }

        public String toString() {
            return this.sql;
        }
    }

    class ForceInlineSignal
    extends ControlFlowSignal {
        public ForceInlineSignal() {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Re-render query", "Forcing bind variable inlining as " + DefaultRenderContext.this.configuration().dialect() + " does not support " + DefaultRenderContext.this.peekIndex() + " bind variables (or more) in a single query");
            }
        }
    }
}

