/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Function2;
import org.jooq.SQL;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Expression;
import org.jooq.impl.Names;
import org.jooq.impl.Operators;
import org.jooq.impl.QOM;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class BitXor<T extends Number>
extends AbstractField<T>
implements QOM.BitXor<T> {
    final Field<T> arg1;
    final Field<T> arg2;

    BitXor(Field<T> arg1, Field<T> arg2) {
        super(Names.N_BIT_XOR, Tools.allNotNull(Tools.dataType(SQLDataType.INTEGER, arg1, false), arg1, arg2));
        this.arg1 = Tools.nullSafeNotNull(arg1, SQLDataType.INTEGER);
        this.arg2 = Tools.nullSafeNotNull(arg2, SQLDataType.INTEGER);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case H2: 
            case HSQLDB: {
                ctx.visit(DSL.function(Names.N_BITXOR, this.getDataType(), this.arg1, this.arg2));
                break;
            }
            case FIREBIRD: {
                ctx.visit(DSL.function(Names.N_BIN_XOR, this.getDataType(), this.arg1, this.arg2));
                break;
            }
            case SQLITE: {
                ctx.visit(DSL.bitAnd(DSL.bitNot(DSL.bitAnd(this.arg1, this.arg2)), DSL.bitOr(this.arg1, this.arg2)));
                break;
            }
            default: {
                ctx.sql('(');
                SQL op2 = Expression.HASH_OP_FOR_BIT_XOR.contains((Object)ctx.dialect()) ? Operators.OP_NUM : Operators.OP_HAT;
                Expression.acceptAssociative(ctx, this, q2 -> new Expression.Expr(q2.arg1, op2, q2.arg2), c2 -> c2.sql(' '));
                ctx.sql(')');
            }
        }
    }

    @Override
    public final Field<T> $arg1() {
        return this.arg1;
    }

    @Override
    public final Field<T> $arg2() {
        return this.arg2;
    }

    @Override
    public final QOM.BitXor<T> $arg1(Field<T> newValue) {
        return this.constructor().apply(newValue, (Field<T>)this.$arg2());
    }

    @Override
    public final QOM.BitXor<T> $arg2(Field<T> newValue) {
        return this.constructor().apply((Field<T>)this.$arg1(), newValue);
    }

    @Override
    public final Function2<? super Field<T>, ? super Field<T>, ? extends QOM.BitXor<T>> constructor() {
        return (a1, a2) -> new BitXor(a1, a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.BitXor) {
            QOM.BitXor o2 = (QOM.BitXor)that;
            return StringUtils.equals(this.$arg1(), o2.$arg1()) && StringUtils.equals(this.$arg2(), o2.$arg2());
        }
        return super.equals(that);
    }
}

