/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jooq.Clause;
import org.jooq.Condition;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.QueryPart;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.conf.RenderOptionalKeyword;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.ArrayTable;
import org.jooq.impl.CommonTableExpressionImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.DerivedTable;
import org.jooq.impl.Keywords;
import org.jooq.impl.QOM;
import org.jooq.impl.QueryPartListView;
import org.jooq.impl.SelectFieldList;
import org.jooq.impl.TableImpl;
import org.jooq.impl.Tools;
import org.jooq.impl.Values;

final class Alias<Q extends QueryPart>
extends AbstractQueryPart
implements QOM.UEmpty {
    private static final Clause[] CLAUSES_TABLE_REFERENCE = new Clause[]{Clause.TABLE, Clause.TABLE_REFERENCE};
    private static final Clause[] CLAUSES_TABLE_ALIAS = new Clause[]{Clause.TABLE, Clause.TABLE_ALIAS};
    private static final Clause[] CLAUSES_FIELD_REFERENCE = new Clause[]{Clause.FIELD, Clause.FIELD_REFERENCE};
    private static final Clause[] CLAUSES_FIELD_ALIAS = new Clause[]{Clause.FIELD, Clause.FIELD_ALIAS};
    private static final Set<SQLDialect> SUPPORT_AS_REQUIRED = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.YUGABYTEDB);
    private static final Set<SQLDialect> SUPPORT_DERIVED_COLUMN_NAMES_SPECIAL1 = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.FIREBIRD, SQLDialect.MYSQL);
    private static final Set<SQLDialect> SUPPORT_DERIVED_COLUMN_NAMES_SPECIAL2 = SQLDialect.supportedBy(SQLDialect.IGNITE, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE);
    final Q wrapped;
    final Q wrapping;
    final Name alias;
    final Name[] fieldAliases;
    final Predicate<Context<?>> wrapInParentheses;

    Alias(Q wrapped, Q wrapping, Name alias) {
        this(wrapped, wrapping, alias, null, c2 -> false);
    }

    Alias(Q wrapped, Q wrapping, Name alias, Name[] fieldAliases, Predicate<Context<?>> wrapInParentheses) {
        this.wrapped = wrapped;
        this.wrapping = wrapping;
        this.alias = alias;
        this.fieldAliases = fieldAliases;
        this.wrapInParentheses = wrapInParentheses;
    }

    final Q wrapped() {
        return this.wrapped;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (ctx.declareAliases() && (ctx.declareFields() || ctx.declareTables())) {
            ctx.declareAliases(false);
            this.acceptDeclareAliasStandard(ctx);
            ctx.declareAliases(true);
        } else {
            ctx.qualify(false, c2 -> c2.visit(this.alias));
        }
    }

    private final void acceptDeclareAliasTSQL(Context<?> ctx) {
        ctx.visit(this.alias).sql(" = ");
        this.toSQLWrapped(ctx);
    }

    private final void acceptDeclareAliasStandard(Context<?> context) {
        if (this.wrapped instanceof TableImpl) {
            context.scopeMarkStart((QueryPart)this.wrapping);
        }
        SQLDialect dialect = context.dialect();
        SQLDialect family = context.family();
        boolean emulatedDerivedColumnList = false;
        if (this.fieldAliases != null && SUPPORT_DERIVED_COLUMN_NAMES_SPECIAL1.contains((Object)dialect) && (this.wrapped instanceof TableImpl || this.wrapped instanceof CommonTableExpressionImpl)) {
            Tools.visitSubquery(context, DSL.select(DSL.asterisk()).from((TableLike<?>)((Table)this.wrapped).as(this.alias)));
        } else if (this.fieldAliases != null && (emulatedDerivedColumnList || SUPPORT_DERIVED_COLUMN_NAMES_SPECIAL2.contains((Object)dialect))) {
            emulatedDerivedColumnList = true;
            if (this.wrapped instanceof Values && Values.NO_SUPPORT_VALUES.contains((Object)dialect)) {
                context.data((Object)Tools.DataKey.DATA_SELECT_ALIASES, this.fieldAliases, t2 -> this.toSQLWrapped((Context<?>)t2));
            } else {
                Select wrappedAsSelect = this.wrapped instanceof Select ? (Select)this.wrapped : (this.wrapped instanceof DerivedTable ? ((DerivedTable)this.wrapped).query() : DSL.select(DSL.asterisk()).from((TableLike<?>)((Table)this.wrapped).as(this.alias)));
                List<Field<?>> select = wrappedAsSelect.getSelect();
                if (emulatedDerivedColumnList) {
                    SelectFieldList fields2 = new SelectFieldList();
                    for (int i2 = 0; i2 < this.fieldAliases.length; ++i2) {
                        switch (family) {
                            default: 
                        }
                        fields2.add(DSL.field("null").as(this.fieldAliases[i2]));
                    }
                    Tools.visitSubquery(context, DSL.select(fields2).where((Condition)DSL.falseCondition()).unionAll(wrappedAsSelect));
                }
            }
        } else {
            this.toSQLWrapped(context);
        }
        this.toSQLAs(context);
        context.sql(' ').qualify(false, c2 -> c2.visit(this.alias));
        if (this.fieldAliases != null && !emulatedDerivedColumnList) {
            this.toSQLDerivedColumnList(context);
        } else {
            switch (family) {
                case HSQLDB: 
                case POSTGRES: 
                case YUGABYTEDB: {
                    Q o2 = this.wrapped;
                    if (!context.declareTables() || !(o2 instanceof ArrayTable)) break;
                    context.sql('(').visit(QueryPartListView.wrap((QueryPart[])((ArrayTable)o2).fields()).qualify(false)).sql(')');
                    break;
                }
            }
        }
        if (this.wrapped instanceof TableImpl) {
            context.scopeMarkEnd((QueryPart)this.wrapping);
        }
    }

    final void toSQLAs(Context<?> ctx) {
        if (Boolean.TRUE.equals(ctx.data((Object)Tools.BooleanDataKey.DATA_AS_REQUIRED))) {
            ctx.sql(' ').visit(Keywords.K_AS);
        } else if (this.wrapped instanceof Field) {
            if (ctx.settings().getRenderOptionalAsKeywordForFieldAliases() == RenderOptionalKeyword.DEFAULT && SUPPORT_AS_REQUIRED.contains((Object)ctx.dialect())) {
                ctx.sql(' ').visit(Keywords.K_AS);
            } else if (ctx.settings().getRenderOptionalAsKeywordForFieldAliases() == RenderOptionalKeyword.ON) {
                ctx.sql(' ').visit(Keywords.K_AS);
            }
        } else if (ctx.settings().getRenderOptionalAsKeywordForTableAliases() == RenderOptionalKeyword.DEFAULT && SUPPORT_AS_REQUIRED.contains((Object)ctx.dialect())) {
            ctx.sql(' ').visit(Keywords.K_AS);
        } else if (ctx.settings().getRenderOptionalAsKeywordForTableAliases() == RenderOptionalKeyword.ON) {
            ctx.sql(' ').visit(Keywords.K_AS);
        }
    }

    private final void toSQLWrapped(Context<?> ctx) {
        boolean wrap = this.wrapInParentheses.test(ctx);
        if (wrap) {
            ctx.data((Object)Tools.BooleanDataKey.DATA_WRAP_DERIVED_TABLES_IN_PARENTHESES, false, c2 -> this.toSQLWrapped((Context<?>)c2, wrap));
        } else {
            this.toSQLWrapped(ctx, wrap);
        }
    }

    private final void toSQLWrapped(Context<?> ctx, boolean wrap) {
        ctx.sql(wrap ? "(" : "").visit((QueryPart)this.wrapped).sql(wrap ? ")" : "");
    }

    private final void toSQLDerivedColumnList(Context<?> ctx) {
        ctx.sql(" (").visit(QueryPartListView.wrap((QueryPart[])this.fieldAliases)).sql(')');
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        if (ctx.declareFields() || ctx.declareTables()) {
            if (this.wrapped instanceof Table) {
                return CLAUSES_TABLE_ALIAS;
            }
            return CLAUSES_FIELD_ALIAS;
        }
        if (this.wrapped instanceof Table) {
            return CLAUSES_TABLE_REFERENCE;
        }
        return CLAUSES_FIELD_REFERENCE;
    }

    @Override
    public final boolean declaresFields() {
        return true;
    }

    @Override
    public final boolean declaresTables() {
        return true;
    }
}

