/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import org.jooq.AggregateFilterStep;
import org.jooq.AggregateFunction;
import org.jooq.ArrayAggOrderByStep;
import org.jooq.Condition;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.OrderedAggregateFunction;
import org.jooq.QueryPart;
import org.jooq.SQL;
import org.jooq.SQLDialect;
import org.jooq.WindowBeforeOverStep;
import org.jooq.impl.AbstractWindowFunction;
import org.jooq.impl.ConditionProviderImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.QueryPartCollectionView;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.SortFieldList;
import org.jooq.impl.Tools;

abstract class AbstractAggregateFunction<T>
extends AbstractWindowFunction<T>
implements AggregateFunction<T>,
OrderedAggregateFunction<T>,
ArrayAggOrderByStep<T> {
    static final Set<SQLDialect> SUPPORT_FILTER = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> SUPPORT_DISTINCT_RVE = SQLDialect.supportedBy(SQLDialect.H2, SQLDialect.POSTGRES);
    static final Field<Integer> ASTERISK = DSL.field("*", Integer.class);
    final QueryPartList<Field<?>> arguments;
    final boolean distinct;
    final ConditionProviderImpl filter;
    SortFieldList withinGroupOrderBy;
    SortFieldList keepDenseRankOrderBy;
    boolean first;

    AbstractAggregateFunction(String name, DataType<T> type, Field<?> ... arguments) {
        this(false, name, type, arguments);
    }

    AbstractAggregateFunction(Name name, DataType<T> type, Field<?> ... arguments) {
        this(false, name, type, arguments);
    }

    AbstractAggregateFunction(boolean distinct, String name, DataType<T> type, Field<?> ... arguments) {
        this(distinct, DSL.unquotedName(name), type, arguments);
    }

    AbstractAggregateFunction(boolean distinct, Name name, DataType<T> type, Field<?> ... arguments) {
        super(name, type);
        this.distinct = distinct;
        this.arguments = new QueryPartList((QueryPart[])arguments);
        this.filter = new ConditionProviderImpl();
    }

    @Override
    public void accept(Context<?> ctx) {
        this.toSQLArguments(ctx);
        this.acceptKeepDenseRankOrderByClause(ctx);
        this.acceptWithinGroupClause(ctx);
        this.acceptFilterClause(ctx);
        this.acceptOverClause(ctx);
    }

    private final void acceptKeepDenseRankOrderByClause(Context<?> ctx) {
        if (!Tools.isEmpty(this.keepDenseRankOrderBy)) {
            switch (ctx.family()) {
                default: 
            }
            ctx.sql(' ').visit(Keywords.K_KEEP).sql(" (").visit(Keywords.K_DENSE_RANK).sql(' ').visit(this.first ? Keywords.K_FIRST : Keywords.K_LAST).sql(' ').visit(Keywords.K_ORDER_BY).sql(' ').visit(this.keepDenseRankOrderBy).sql(')');
        }
    }

    final void acceptWithinGroupClause(Context<?> ctx) {
        if (this.withinGroupOrderBy != null) {
            switch (ctx.family()) {
                default: 
            }
            ctx.sql(' ').visit(Keywords.K_WITHIN_GROUP).sql(" (").visit(Keywords.K_ORDER_BY).sql(' ');
            if (this.withinGroupOrderBy.isEmpty()) {
                ctx.visit(Keywords.K_NULL);
            } else {
                ctx.visit(this.withinGroupOrderBy);
            }
            ctx.sql(')');
        }
    }

    private final void toSQLArguments(Context<?> ctx) {
        this.acceptFunctionName(ctx);
        ctx.sql('(');
        this.acceptArguments0(ctx);
        ctx.sql(')');
    }

    void acceptFunctionName(Context<?> ctx) {
        ctx.visit(this.getQualifiedName());
    }

    final void acceptArguments0(Context<?> ctx) {
        this.acceptArguments1(ctx, this.arguments);
    }

    final void acceptArguments1(Context<?> ctx, QueryPartCollectionView<Field<?>> args) {
        if (this.distinct) {
            ctx.visit(Keywords.K_DISTINCT).sql(' ');
            if (args.size() > 1 && SUPPORT_DISTINCT_RVE.contains((Object)ctx.dialect())) {
                ctx.sql('(');
            }
        }
        if (!args.isEmpty()) {
            this.acceptArguments2(ctx, args);
        }
        if (this.distinct && args.size() > 1 && SUPPORT_DISTINCT_RVE.contains((Object)ctx.dialect())) {
            ctx.sql(')');
        }
    }

    final void acceptArguments2(Context<?> ctx, QueryPartCollectionView<Field<?>> args) {
        this.acceptArguments3(ctx, args, Function.identity());
    }

    final void acceptArguments3(Context<?> ctx, QueryPartCollectionView<Field<?>> args, Function<? super Field<?>, ? extends Field<?>> fun) {
        if (!this.filter.hasWhere() || SUPPORT_FILTER.contains((Object)ctx.dialect())) {
            ctx.visit(QueryPartCollectionView.wrap(args).map(fun));
        } else {
            ctx.visit(QueryPartCollectionView.wrap(args).map((arg, i2) -> this.applyFilter((Field<?>)arg, i2) ? DSL.when((Condition)this.filter, arg == ASTERISK ? DSL.one() : arg) : arg).map(fun));
        }
    }

    boolean applyFilter(Field<?> arg, int i2) {
        return true;
    }

    final void acceptFilterClause(Context<?> ctx) {
        if (this.filter.hasWhere()) {
            AbstractAggregateFunction.acceptFilterClause(ctx, this.filter);
        }
    }

    static final void acceptFilterClause(Context<?> ctx, Condition filter) {
        switch (ctx.family()) {
            default: 
        }
        if (SUPPORT_FILTER.contains((Object)ctx.dialect())) {
            ctx.sql(' ').visit(Keywords.K_FILTER).sql(" (").visit(Keywords.K_WHERE).sql(' ').visit(filter).sql(')');
        }
    }

    final void acceptOrderBy(Context<?> ctx) {
        if (!Tools.isEmpty(this.withinGroupOrderBy)) {
            switch (ctx.family()) {
                default: 
            }
            ctx.sql(' ').visit(Keywords.K_ORDER_BY).sql(' ').visit(this.withinGroupOrderBy);
        }
    }

    final QueryPartList<Field<?>> getArguments() {
        return this.arguments;
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(Condition c2) {
        this.filter.addConditions(c2);
        return this;
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(Condition ... conditions) {
        return this.filterWhere(DSL.and(conditions));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(Collection<? extends Condition> conditions) {
        return this.filterWhere(DSL.and(conditions));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(Field<Boolean> field) {
        return this.filterWhere(DSL.condition(field));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(SQL sql) {
        return this.filterWhere(DSL.condition(sql));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(String sql) {
        return this.filterWhere(DSL.condition(sql));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(String sql, Object ... bindings) {
        return this.filterWhere(DSL.condition(sql, bindings));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(String sql, QueryPart ... parts) {
        return this.filterWhere(DSL.condition(sql, parts));
    }

    @Override
    public final AggregateFunction<T> withinGroupOrderBy(OrderField<?> ... fields2) {
        return this.withinGroupOrderBy(Arrays.asList(fields2));
    }

    @Override
    public final AggregateFunction<T> withinGroupOrderBy(Collection<? extends OrderField<?>> fields2) {
        if (this.withinGroupOrderBy == null) {
            this.withinGroupOrderBy = new SortFieldList();
        }
        this.withinGroupOrderBy.addAll(Tools.sortFields(fields2));
        return this;
    }

    @Override
    public AbstractAggregateFunction<T> orderBy(OrderField<?> ... fields2) {
        if (this.windowSpecification != null) {
            super.orderBy((OrderField[])fields2);
        } else {
            this.withinGroupOrderBy((OrderField[])fields2);
        }
        return this;
    }

    @Override
    public AbstractAggregateFunction<T> orderBy(Collection<? extends OrderField<?>> fields2) {
        if (this.windowSpecification != null) {
            this.windowSpecification.orderBy((Collection)fields2);
        } else {
            this.withinGroupOrderBy((Collection)fields2);
        }
        return this;
    }

    final Condition f(Condition c2) {
        return this.filter.hasWhere() ? this.filter.and(c2) : c2;
    }

    final <U> Field<U> fon(AggregateFunction<U> function) {
        return DSL.nullif(this.fo(function), DSL.zero());
    }

    final <U> Field<U> ofo(AbstractAggregateFunction<U> function) {
        return this.fo((AggregateFilterStep<U>)((Object)(Tools.isEmpty(this.withinGroupOrderBy) ? function : function.orderBy((Collection)this.withinGroupOrderBy))));
    }

    final <U> Field<U> fo(AggregateFilterStep<U> function) {
        return this.o(this.filter.hasWhere() ? function.filterWhere((Condition)this.filter) : function);
    }

    final <U> Field<U> o(WindowBeforeOverStep<U> function) {
        if (this.windowSpecification != null) {
            return function.over(this.windowSpecification);
        }
        if (this.windowDefinition != null) {
            return function.over(this.windowDefinition);
        }
        if (this.windowName != null) {
            return function.over(this.windowName);
        }
        return function;
    }

    final <U extends Number> Field<U> x(Field<U> x2, Field<? extends Number> y2) {
        return DSL.nvl2(y2, x2, DSL.NULL(x2.getDataType()));
    }

    final <U extends Number> Field<U> y(Field<? extends Number> x2, Field<U> y2) {
        return DSL.nvl2(x2, y2, DSL.NULL(y2.getDataType()));
    }

    final DataType<? extends Number> d(Context<?> ctx) {
        switch (ctx.family()) {
            case DERBY: 
            case FIREBIRD: 
            case HSQLDB: 
            case SQLITE: {
                return SQLDataType.DOUBLE;
            }
        }
        return SQLDataType.NUMERIC;
    }

    public final boolean $distinct() {
        return this.distinct;
    }

    @Override
    public final Condition $filterWhere() {
        return this.filter.getWhereOrNull();
    }
}

