/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.jooq.Name;
import org.jooq.SQLDialect;
import org.jooq.codegen.Language;
import org.jooq.impl.DSL;

class GenerationUtil {
    static final Pattern TYPE_REFERENCE_PATTERN = Pattern.compile("^((?:[\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*)((?:<.*>|\\[.*])*)$");
    static final Pattern PLAIN_GENERIC_TYPE_PATTERN = Pattern.compile("[<\\[]((?:[\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*)[>\\]]");
    static final Pattern UNDERSCORE_PATTERN = Pattern.compile("_+");
    private static final Set<String> JAVA_KEYWORDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "double", "do", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "interface", "int", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while")));
    private static final Set<String> SCALA_KEYWORDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("abstract", "case", "catch", "class", "def", "do", "else", "extends", "false", "final", "finally", "for", "forSome", "if", "implicit", "import", "lazy", "match", "new", "null", "object", "override", "package", "private", "protected", "return", "sealed", "super", "this", "throw", "trait", "try", "true", "type", "val", "var", "while", "with", "yield")));
    private static final Set<String> KOTLIN_KEYWORDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("as", "break", "class", "continue", "do", "else", "false", "for", "fun", "if", "in", "interface", "is", "null", "object", "package", "return", "super", "this", "throw", "true", "try", "typealias", "typeof", "val", "var", "when", "while", "yield", "constructor", "init", "actual", "abstract", "annotation", "companion", "const", "crossinline", "data", "enum", "expect", "external", "final", "infix", "inline", "inner", "internal", "lateinit", "noinline", "open", "operator", "out", "override", "private", "protected", "public", "reified", "sealed", "suspend", "tailrec", "vararg")));
    private static final Set<Character> SCALA_WHITESPACE = Collections.unmodifiableSet(new HashSet<Character>(Arrays.asList(Character.valueOf(' '), Character.valueOf('\t'), Character.valueOf('\r'), Character.valueOf('\n'))));
    private static final Set<Character> SCALA_PARENTHESES = Collections.unmodifiableSet(new HashSet<Character>(Arrays.asList(Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'))));
    private static final Set<Character> SCALA_DELIMITER = Collections.unmodifiableSet(new HashSet<Character>(Arrays.asList(Character.valueOf('`'), Character.valueOf('\''), Character.valueOf('\"'), Character.valueOf('.'), Character.valueOf(';'), Character.valueOf(','))));
    private static final Set<String> WINDOWS_FORBIDDEN = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("CON", "PRN", "AUX", "CLOCK$", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9")));

    GenerationUtil() {
    }

    private static Boolean isScalaOperator(char c2) {
        return c2 >= ' ' && c2 <= '\u007f' && !Character.isLetter(c2) && !Character.isDigit(c2) && !SCALA_DELIMITER.contains(Character.valueOf(c2)) && !SCALA_PARENTHESES.contains(Character.valueOf(c2)) && !SCALA_WHITESPACE.contains(Character.valueOf(c2)) || Character.getType(c2) == 25 || Character.getType(c2) == 28;
    }

    private static Boolean isScalaLetter(char c2) {
        return Character.isLetter(c2) || c2 == '_' || c2 == '$';
    }

    private static Boolean isScalaIdentifierStart(char c2) {
        return GenerationUtil.isScalaLetter(c2);
    }

    private static Boolean isScalaIdentifierPart(char c2) {
        return GenerationUtil.isScalaIdentifierStart(c2) != false || Character.isDigit(c2);
    }

    private static boolean isKotlinIdentifierPart(char c2) {
        return c2 != '\r' && c2 != '\n' && c2 != '`' && c2 != '(' && c2 != ')' && c2 != '{' && c2 != '}' && c2 != '[' && c2 != ']' && c2 != '.';
    }

    public static String escapeWindowsForbiddenNames(String name) {
        return name == null ? null : (WINDOWS_FORBIDDEN.contains(name.toUpperCase()) ? name + "_" : name);
    }

    public static String convertToIdentifier(String literal, Language language) {
        String result = GenerationUtil.convertToIdentifier0(literal, language);
        if (language == Language.JAVA && UNDERSCORE_PATTERN.matcher(result).matches()) {
            return result + "_";
        }
        return result;
    }

    private static String convertToIdentifier0(String literal, Language language) {
        if (language == Language.JAVA && JAVA_KEYWORDS.contains(literal)) {
            return literal + "_";
        }
        if (language == Language.SCALA && SCALA_KEYWORDS.contains(literal)) {
            return "`" + literal + "`";
        }
        if (language == Language.KOTLIN && KOTLIN_KEYWORDS.contains(literal)) {
            return "`" + literal + "`";
        }
        StringBuilder sb = new StringBuilder();
        if ("".equals(literal)) {
            if (language == Language.SCALA) {
                return "`_`";
            }
            if (language == Language.KOTLIN) {
                return "`_`";
            }
            return "_";
        }
        for (int i2 = 0; i2 < literal.length(); ++i2) {
            char c2 = literal.charAt(i2);
            if (language == Language.SCALA && i2 == literal.length() - 1 && literal.length() >= 2 && literal.charAt(i2 - 1) == '_' && GenerationUtil.isScalaOperator(c2).booleanValue()) {
                sb.append(c2);
                continue;
            }
            if (language == Language.SCALA && !GenerationUtil.isScalaIdentifierPart(c2).booleanValue()) {
                sb.append(GenerationUtil.escape(c2));
                continue;
            }
            if (language == Language.JAVA && !Character.isJavaIdentifierPart(c2)) {
                sb.append(GenerationUtil.escape(c2));
                continue;
            }
            if (language == Language.SCALA && i2 == 0 && !GenerationUtil.isScalaIdentifierStart(c2).booleanValue()) {
                sb.append("_").append(c2);
                continue;
            }
            if (language == Language.JAVA && i2 == 0 && !Character.isJavaIdentifierStart(c2)) {
                sb.append("_").append(c2);
                continue;
            }
            if (language == Language.KOTLIN && !GenerationUtil.isKotlinIdentifierPart(c2)) {
                sb.append(GenerationUtil.escape(c2));
                continue;
            }
            if (language == Language.KOTLIN && !Character.isJavaIdentifierPart(c2)) {
                return "`" + literal + "`";
            }
            if (language == Language.KOTLIN && i2 == 0 && !Character.isJavaIdentifierStart(c2)) {
                return "`" + literal + "`";
            }
            if (language == Language.KOTLIN && c2 == '$') {
                return "`" + literal + "`";
            }
            sb.append(c2);
        }
        return sb.toString();
    }

    @Deprecated
    public static String convertToJavaIdentifier(String literal) {
        return GenerationUtil.convertToIdentifier(literal, Language.JAVA);
    }

    private static String escape(char c2) {
        if (c2 == ' ' || c2 == '-' || c2 == '.') {
            return "_";
        }
        return "_" + Integer.toHexString(c2);
    }

    static String getSimpleJavaType(String qualifiedJavaType) {
        if (qualifiedJavaType == null) {
            return null;
        }
        return qualifiedJavaType.replaceAll(".*\\.", "");
    }

    static Name getArrayBaseType(SQLDialect dialect, String t2, Name u2) {
        switch (dialect.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                if (u2 != null) {
                    if (u2.last().startsWith("_")) {
                        String[] name = u2.getName();
                        name[name.length - 1] = name[name.length - 1].substring(1);
                        return DSL.name(name);
                    }
                    if (u2.last().toUpperCase().endsWith(" ARRAY")) {
                        String[] name = u2.getName();
                        name[name.length - 1] = name[name.length - 1].replaceFirst("(?i: ARRAY)", "");
                        return DSL.name(name);
                    }
                }
                return u2;
            }
        }
        if ("ARRAY".equalsIgnoreCase(t2)) {
            return DSL.name("OTHER");
        }
        return DSL.name(t2.replaceFirst("(?i: ARRAY)", ""));
    }

    static ExpressionType expressionType(String expression) {
        if (TYPE_REFERENCE_PATTERN.matcher(expression).matches()) {
            return ExpressionType.CONSTRUCTOR_REFERENCE;
        }
        return ExpressionType.EXPRESSION;
    }

    static enum ExpressionType {
        CONSTRUCTOR_REFERENCE,
        EXPRESSION;

    }
}

