/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.sqlserver;

import java.util.List;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.LineString;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.Point;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.codec.sqlserver.AbstractEncoder;
import org.geolatte.geom.codec.sqlserver.CountingPointSequenceBuilder;
import org.geolatte.geom.codec.sqlserver.Figure;
import org.geolatte.geom.codec.sqlserver.FigureAttribute;
import org.geolatte.geom.codec.sqlserver.OpenGisType;
import org.geolatte.geom.codec.sqlserver.Shape;

class PolygonEncoder
extends AbstractEncoder<Polygon> {
    PolygonEncoder() {
    }

    @Override
    public boolean accepts(Geometry geom) {
        return geom instanceof Polygon;
    }

    @Override
    protected void encode(Geometry geom, int parentShapeIndex, CountingPointSequenceBuilder coordinates, List<Figure> figures, List<Shape> shapes) {
        if (!(geom instanceof Polygon)) {
            throw new IllegalArgumentException("Polygon geometry expected.");
        }
        if (geom.isEmpty()) {
            shapes.add(new Shape(parentShapeIndex, -1, OpenGisType.POLYGON));
            return;
        }
        Polygon polygon = (Polygon)geom;
        int figureOffset = figures.size();
        shapes.add(new Shape(parentShapeIndex, figureOffset, OpenGisType.POLYGON));
        int pointOffset = coordinates.getNumAdded();
        this.addExteriorRing(polygon, coordinates, figures);
        this.addInteriorRings(polygon, coordinates, figures);
    }

    private void addInteriorRings(Polygon geom, CountingPointSequenceBuilder coordinates, List<Figure> figures) {
        for (int idx = 0; idx < geom.getNumInteriorRing(); ++idx) {
            this.addInteriorRing(geom.getInteriorRingN(idx), coordinates, figures);
        }
    }

    private void addInteriorRing(LineString ring, CountingPointSequenceBuilder coordinates, List<Figure> figures) {
        int pointOffset = coordinates.getNumAdded();
        this.addPoints(ring, coordinates);
        Figure figure = new Figure(FigureAttribute.InteriorRing, pointOffset);
        figures.add(figure);
    }

    private void addPoints(LineString ring, CountingPointSequenceBuilder coordinates) {
        for (Point c2 : ring.getPoints()) {
            coordinates.add(c2);
        }
    }

    private void addExteriorRing(Polygon geom, CountingPointSequenceBuilder coordinates, List<Figure> figures) {
        LinearRing shell = geom.getExteriorRing();
        int offset = coordinates.getNumAdded();
        this.addPoints(shell, coordinates);
        Figure exterior = new Figure(FigureAttribute.ExteriorRing, offset);
        figures.add(exterior);
    }
}

