/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.sqlserver;

import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.LineString;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.MultiPoint;
import org.geolatte.geom.MultiPolygon;
import org.geolatte.geom.Point;
import org.geolatte.geom.Polygon;

public enum OpenGisType {
    POINT(1, Point.class),
    LINESTRING(2, LineString.class),
    POLYGON(3, Polygon.class),
    MULTIPOINT(4, MultiPoint.class),
    MULTILINESTRING(5, MultiLineString.class),
    MULTIPOLYGON(6, MultiPolygon.class),
    GEOMETRYCOLLECTION(7, GeometryCollection.class),
    INVALID_TYPE(0, null);

    final byte byteValue;
    final Class geomClass;

    private OpenGisType(byte v2, Class geomClass) {
        this.byteValue = v2;
        this.geomClass = geomClass;
    }

    boolean typeOf(Object o2) {
        return this.geomClass.isAssignableFrom(o2.getClass());
    }

    static OpenGisType valueOf(byte b2) {
        for (OpenGisType t2 : OpenGisType.values()) {
            if (t2.byteValue != b2) continue;
            return t2;
        }
        return INVALID_TYPE;
    }
}

