/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.sqlserver;

import java.util.List;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.codec.sqlserver.AbstractEncoder;
import org.geolatte.geom.codec.sqlserver.CountingPointSequenceBuilder;
import org.geolatte.geom.codec.sqlserver.Encoders;
import org.geolatte.geom.codec.sqlserver.Figure;
import org.geolatte.geom.codec.sqlserver.OpenGisType;
import org.geolatte.geom.codec.sqlserver.Shape;

class GeometryCollectionEncoder<T extends GeometryCollection>
extends AbstractEncoder<T> {
    private final OpenGisType openGisType;

    GeometryCollectionEncoder(OpenGisType openGisType) {
        this.openGisType = openGisType;
    }

    @Override
    public boolean accepts(Geometry geom) {
        return this.openGisType.typeOf(geom);
    }

    @Override
    protected void encode(Geometry geom, int parentShapeIndex, CountingPointSequenceBuilder coordinates, List<Figure> figures, List<Shape> shapes) {
        if (geom.isEmpty()) {
            shapes.add(new Shape(parentShapeIndex, -1, this.openGisType));
            return;
        }
        int thisShapeIndex = shapes.size();
        Shape thisShape = this.createShape(parentShapeIndex, figures);
        shapes.add(thisShape);
        if (!(geom instanceof GeometryCollection)) {
            throw new IllegalArgumentException("Expect GeometryCollection argument.");
        }
        GeometryCollection gc2 = (GeometryCollection)geom;
        for (int i2 = 0; i2 < gc2.getNumGeometries(); ++i2) {
            Geometry component = gc2.getGeometryN(i2);
            this.encodeComponent(component, thisShapeIndex, coordinates, figures, shapes);
        }
    }

    protected Shape createShape(int parentShapeIndex, List<Figure> figures) {
        Shape thisShape = new Shape(parentShapeIndex, figures.size(), this.openGisType);
        return thisShape;
    }

    protected void encodeComponent(Geometry geom, int thisShapeIndex, CountingPointSequenceBuilder coordinates, List<Figure> figures, List<Shape> shapes) {
        AbstractEncoder encoder = (AbstractEncoder)Encoders.encoderFor(geom);
        encoder.encode(geom, thisShapeIndex, coordinates, figures, shapes);
    }
}

