/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.sqlserver;

import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.sqlserver.Decoder;
import org.geolatte.geom.codec.sqlserver.OpenGisType;
import org.geolatte.geom.codec.sqlserver.SqlServerGeometry;

abstract class AbstractDecoder<G extends Geometry>
implements Decoder<G> {
    AbstractDecoder() {
    }

    @Override
    public G decode(SqlServerGeometry nativeGeom) {
        if (!this.accepts(nativeGeom)) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " received object of type " + (Object)((Object)nativeGeom.openGisType()));
        }
        if (nativeGeom.isEmpty()) {
            G nullGeom = this.createNullGeometry();
            return nullGeom;
        }
        return this.createGeometry(nativeGeom);
    }

    @Override
    public boolean accepts(OpenGisType type) {
        return type == this.getOpenGisType();
    }

    @Override
    public boolean accepts(SqlServerGeometry nativeGeom) {
        return this.accepts(nativeGeom.openGisType());
    }

    protected abstract OpenGisType getOpenGisType();

    protected abstract G createNullGeometry();

    protected abstract G createGeometry(SqlServerGeometry var1);

    protected abstract G createGeometry(SqlServerGeometry var1, int var2);
}

