/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.codec.AbstractWktTokenizer;
import org.geolatte.geom.codec.WktDecodeException;
import org.geolatte.geom.codec.WktNumberToken;
import org.geolatte.geom.codec.WktTextToken;
import org.geolatte.geom.codec.WktToken;
import org.geolatte.geom.codec.WktVariant;

abstract class AbstractWktDecoder<T> {
    private final WktVariant wktVariant;
    protected WktToken currentToken;
    private AbstractWktTokenizer tokenizer;

    public AbstractWktDecoder(WktVariant wktVariant) {
        this.wktVariant = wktVariant;
    }

    protected void setTokenizer(AbstractWktTokenizer tokenizer) {
        this.tokenizer = tokenizer;
        this.currentToken = null;
    }

    protected String decodeText() {
        if (this.currentToken instanceof WktTextToken) {
            String text = ((WktTextToken)this.currentToken).getText();
            this.nextToken();
            return text;
        }
        throw new WktDecodeException("Expected text token, received " + this.currentToken.toString());
    }

    protected void nextToken() {
        this.currentToken = this.tokenizer.nextToken();
    }

    protected boolean matchesOpenList() {
        if (this.currentToken == this.getWktVariant().getOpenList()) {
            this.nextToken();
            return true;
        }
        return false;
    }

    protected boolean matchesCloseList() {
        if (this.currentToken == this.getWktVariant().getCloseList()) {
            this.nextToken();
            return true;
        }
        return false;
    }

    protected boolean matchesElementSeparator() {
        if (this.currentToken == this.getWktVariant().getElementSeparator()) {
            this.nextToken();
            return true;
        }
        return false;
    }

    protected double decodeNumber() {
        if (this.currentToken instanceof WktNumberToken) {
            double value = ((WktNumberToken)this.currentToken).getNumber();
            this.nextToken();
            return value;
        }
        throw new WktDecodeException("Expected a number ; received " + this.currentToken.toString());
    }

    protected WktVariant getWktVariant() {
        return this.wktVariant;
    }

    protected int getTokenizerPosition() {
        return this.tokenizer.position();
    }
}

