/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.util;

public class WildcardMatch {
    private char singleCharacterWildcard = (char)63;
    private char multipleCharacterWildcard = (char)42;
    private char escapeCharacter = (char)92;
    private boolean caseSensitive = true;
    private boolean isEscaped = false;
    private int escCnt = 0;
    boolean preceededByMultipleChar = false;

    public WildcardMatch(char singleCharWildcard, char multipleCharsWildcard, char escapeChar) {
        this.setWildcardChars(singleCharWildcard, multipleCharsWildcard);
        this.setEscapeChar(escapeChar);
    }

    public WildcardMatch(char singleCharWildcard, char multipleCharsWildcard) {
        this.setWildcardChars(singleCharWildcard, multipleCharsWildcard);
    }

    public WildcardMatch() {
    }

    public void setWildcardChars(char singleChar, char multipleChars) {
        this.singleCharacterWildcard = singleChar;
        this.multipleCharacterWildcard = multipleChars;
    }

    public void setEscapeChar(char escapeChar) {
        this.escapeCharacter = escapeChar;
    }

    public char getSingleWildcardChar() {
        return this.singleCharacterWildcard;
    }

    public char getMultipleWildcardChar() {
        return this.multipleCharacterWildcard;
    }

    public char getEscapeChar() {
        return this.escapeCharacter;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean match(String s2, String pattern) {
        this.preceededByMultipleChar = false;
        this.isEscaped = false;
        if (!this.caseSensitive) {
            pattern = pattern.toLowerCase();
            s2 = s2.toLowerCase();
        }
        int offset = 0;
        do {
            String ps2 = this.getNextSubString(pattern);
            int len = ps2.length();
            pattern = pattern.substring(len + this.escCnt);
            if (len > 0 && this.isWildcard(ps2.charAt(0)) && this.escCnt == 0) {
                offset = this.getWildcardOffset(ps2.charAt(0));
                if (this.isSingleWildcardChar(ps2.charAt(0))) {
                    s2 = s2.substring(1);
                }
                if (pattern.length() != 0) continue;
                return s2.length() <= offset || this.preceededByMultipleChar;
            }
            int idx = s2.indexOf(ps2);
            if (idx < 0 || idx > offset && !this.preceededByMultipleChar) {
                return false;
            }
            s2 = s2.substring(idx + len);
            this.preceededByMultipleChar = false;
        } while (pattern.length() != 0);
        return s2.length() == 0;
    }

    private String getNextSubString(String pat) {
        this.escCnt = 0;
        if ("".equals(pat)) {
            return "";
        }
        if (this.isWildcard(pat.charAt(0))) {
            if (pat.length() > 1 && !this.isSingleWildcardChar(pat.charAt(0)) && this.isSingleWildcardChar(pat.charAt(1))) {
                this.preceededByMultipleChar = true;
            }
            return pat.substring(0, 1);
        }
        String s2 = "";
        for (int i2 = 0; i2 < pat.length() && !this.isWildcard(pat.charAt(i2), this.isEscaped); ++i2) {
            if (pat.charAt(i2) == this.escapeCharacter) {
                boolean bl2 = this.isEscaped = !this.isEscaped;
                if (!this.isEscaped) {
                    s2 = s2 + pat.charAt(i2);
                    continue;
                }
                ++this.escCnt;
                continue;
            }
            if (this.isWildcard(pat.charAt(i2))) {
                this.isEscaped = false;
                s2 = s2 + pat.charAt(i2);
                continue;
            }
            s2 = s2 + pat.charAt(i2);
        }
        return s2;
    }

    private boolean isWildcard(char c2, boolean isEsc) {
        return !isEsc && this.isWildcard(c2);
    }

    private boolean isSingleWildcardChar(char c2) {
        return c2 == this.singleCharacterWildcard;
    }

    private boolean isWildcard(char c2) {
        return c2 == this.multipleCharacterWildcard || c2 == this.singleCharacterWildcard;
    }

    private int getWildcardOffset(char c2) {
        if (c2 == this.multipleCharacterWildcard) {
            return Integer.MAX_VALUE;
        }
        return 0;
    }
}

