/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.expressions;

import org.geolatte.common.expressions.BooleanExpression;
import org.geolatte.common.expressions.PropertyExpression;
import org.geolatte.common.reflection.EntityClassReader;
import org.geolatte.common.reflection.InvalidObjectReaderException;

public class BooleanProperty
extends BooleanExpression
implements PropertyExpression<Boolean> {
    private final String propertyName;

    public BooleanProperty(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public Boolean evaluate(Object o2) {
        EntityClassReader classReader = EntityClassReader.getClassReaderFor(o2.getClass());
        if (classReader.getPropertyType(this.propertyName) != Boolean.class) {
            throw new RuntimeException("Property " + this.propertyName + " on object " + o2 + " is not of type Boolean");
        }
        Object result = null;
        try {
            result = classReader.getPropertyValue(o2, this.propertyName);
        }
        catch (InvalidObjectReaderException invalidObjectReaderException) {
            // empty catch block
        }
        return (Boolean)result;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }
}

